






#ifndef ER_DWG_SPECIAL_H
#define ER_DWG_SPECIAL_H
#include "Clib/gring.h"
#include "Clib/stringt.h"
#include "er_heap.h"
#include "scalddir.h"
class erule_extension;

/*
    A special model found in some particular SCALD directory
    for some drawing.
*/
gring_define(_next,erule_drawing_special);
class erule_drawing_special {
    friend boolean operator==(const erule_drawing_special&, const erule_extension&);
    friend boolean operator==(const erule_extension&, const erule_drawing_special&);
    string _name;
    gring_inst(_next,erule_drawing_special);
    erule_scalddir _scalddir;
public:
    // Internal to erule subsystem
    erule_drawing_special(const string&, const erule_scalddir&);
    ~erule_drawing_special() { fault("~erule_drawing_special()"); }
    const string& name();
    const erule_scalddir& scalddir();
    void collision_error(const erule_scalddir&);

    void dump(ostream&);
};

#ifndef VAX
gring_inline(_next,erule_drawing_special);
#endif
inline erule_drawing_special::erule_drawing_special(const string& name, const erule_scalddir& dir)
{
    AS(!this);
    this = (erule_drawing_special*)erule_heap.mem(sizeof(*this));
    _name = name;  _scalddir = dir;
}

inline const erule_scalddir& erule_drawing_special::scalddir()
    { return _scalddir; }
inline const string& erule_drawing_special::name()
    { return _name; }

#endif













