#include <stdio.h>
#include "Clib/gavl.h"
#include "add/v_add.h"
#include "er_heap.h"
#include "error.h"
#include "lex.h"
#include "dwg_extension.h"
#include "dwg_version.h"
#include "dwg_entry.h"


const MAX_PAGE_NUM = 10000;	// per previous ValidCOMPILERs


#ifdef VAX
gring_functions(next,erule_drawing_extension,);
#endif


erule_drawing_extension::
erule_drawing_extension(erule_drawing_version* v, const string& ext,
                        const erule_scalddir& scalddir)
{ 
    AS(!this);
    this = (erule_drawing_extension*)erule_heap.mem(sizeof(*this));
    AS(!pages.first());
    version = v;
    _name = ext;  
    expr_found_in_menu = FALSE;
    scald_directory = scalddir;
}


erule_drawing_extension::~erule_drawing_extension()
{ 
    erule_drawing_page* pg;
    while (pg = pages.remove_first()) delete pg;

    erule_heap.memfree(this, sizeof(*this));  this = 0;
}

void erule_drawing_extension::dump(ostream& f)
{
    erule_drawing_page* p = pages.first();
    
    if (!p) 
	f << "    " << _name << "." << version_number() << " (no pages) " <<
	    scald_directory.which(TRUE) << " " << scald_directory.name() NL;
    int first = TRUE;
    while (p) { 
	f << "    " << _name << "." << version_number() << "." <<
	    p->page_number();
        if (first) {
	    f << " " << scald_directory.which(TRUE) << " " << 
		scald_directory.name();
	    first = FALSE;
	}
        f NL;
	p = pages.next(p);
    }
}

char* erule_drawing_extension::
connectivity_file(erule_drawing_entry* d, erule_drawing_page* p)
{
    char page_desc[64];
    const char* ext_name = _name;
    sprintf(page_desc, "%s.%d.%d", ext_name, version_number(),
				   p->page_number());
    char* filename = s_file_name(scald_directory.name(), 
				 scald_directory.which(),
				 "CN", d->name(), page_desc, S_NOCREATE);
    if (!filename) erule_err.sdl();
    return filename;
}


static string PRIM;	// Should be local, but cfront can't handle it yet
static string PART;
boolean erule_drawing_extension::is_prim()
{
    if (PRIM == 0) { PRIM = "PRIM";  PART = "PART"; }
    return _name == PRIM || _name == PART;
}


erule_drawing_page* erule_drawing_extension::
enter_page(int num)
{
    if (num < 0 || num > MAX_PAGE_NUM) {
	erule_err.current_conn_file(ERR_PAGE_NUM);
        return 0;
    }

    erule_drawing_page* prev;
    erule_drawing_page* page;

    // Hack to optimize case where we get them in order

    prev = pages.last();
    if (prev && prev->page_number() <= num) {
	page = new erule_drawing_page(num);
	pages.insert_rear(page);
	return page;
    }

    // General-purpose (n-squared) algorithm

    prev = 0;
    page = pages.first();
    while (page) {
	if (page->page_number() >= num) break;
	prev = page;
	page = pages.next(page);
    }
    if (!page || page->page_number() != num) {
	page = new erule_drawing_page(num);
	if (prev) pages.insert_after(page, prev);
	else pages.insert_front(page);
    }
    return page;
}


boolean erule_drawing_extension::
operator==(const erule_drawing_extension& e)
{
    if (is_prim())
	if (e.is_prim()) 
	    return scald_directory.type() == e.scald_directory.type();
	else return FALSE;
    else return name() == e.name();
}


void erule_drawing_extension::error_dump_expression()
{
    erule_err ERR_INDENT << _name << "." << version_number();
    erule_err << " EXPR=" << _expression ERR_NL;
}


void erule_drawing_extension::
set_expression_from_menu(erule_drawing_entry* drawing,
			 const erule_expression& e)
{ 
    if (expr_found_in_menu) {
	erule_err.message(76 /* already assigned */, drawing, this);
	return;
    }
    _expression = e;  expr_found_in_menu = TRUE;
}

	
boolean erule_drawing_extension::read_expression(erule_drawing_entry* drawing)
{
    if (expr_found_in_menu) return TRUE;

    erule_drawing_page* page = pages.first();  AS(page);

    char page_desc[256];
    const char* myname = name();
    sprintf(page_desc, "%s.%d.%d", myname, version_number(), page->page_number());
    char* filename = s_file_name(scald_directory.name(), 
                                 scald_directory.which(), "CN",
			         drawing->name(), page_desc, S_NOCREATE);
    if (!filename) {
	erule_err.sdl();
	erule_err ERR_INDENT << "Unable to read selection expression for " <<
		  name() << "." << version_number() ERR_NL;
	return TRUE;		// Leaves expression defaulting to TRUE
				// (which is the backward-compatible thing)
    }

    erule_lex lex;
    if (!lex.parse(filename)) {
	erule_err.message(ERR_CANT_OPEN_CN);
	erule_err ERR_INDENT << "File name=" << filename ERR_NL;
	return TRUE;
    }

    if (!lex.scald_file_type()) return TRUE;

    if (!strcmp(lex.val(), "CONNECTIVITY")) {
	lex.next_token();
	if (lex == LEX_SEMI) lex.next_token();
	else lex.error(ERR_EXP_SEMI);

	if (lex == LEX_ID && !strcmp(lex.val(), "EXPR")) {
	    lex.next_token();
	    if (lex != LEX_EQ) lex.error(ERR_EXP_EQ);
	    else lex.next_token();
	    if (lex != LEX_STRING) lex.error(ERR_EXP_STRING);
	    else _expression = lex.val();
	}
    }
    else if (!strcmp(lex.val(), "MACRO_DEFINITION")) {
	if (version_number() == 1) return FALSE;	// A menu drawing
	else erule_err.message(ERR_EXP_MENU, drawing, this);
    }
    else {
	lex.error(ERR_WRONG_FILETYPE);
	erule_err ERR_INDENT << "Expected CONNECTIVITY" ERR_NL;
    }
    return TRUE;
}


struct reported_collision {
    erule_drawing_extension* ext;
    erule_scalddir other_dir;
    int error;
    reported_collision(erule_drawing_extension* _ext,
                       const erule_scalddir& dir,
		       int _error)
	{ ext = _ext;  other_dir = dir;  error = _error; }
};
typedef reported_collision* reported_collisionP;

static int compare_collisions(reported_collision* c1, reported_collision* c2)
{
    int val = c1->ext - c2->ext;
    if (val) return val;

    if (val = c1->other_dir.which() - c2->other_dir.which()) return val;
    if (val = c1->other_dir.name().ptr_cmp(c2->other_dir.name())) return val;
    return c1->error - c2->error;
}
static gavlkey_define(reported_collisionP);
static gavlkey_search(reported_collisionP, compare_collisions);


gavl_define(entry,collision_entry,reported_collisionP);
static class collision_entry {
    gavl_inst(entry,collision_entry,reported_collisionP);
    reported_collision collision;
public:
    collision_entry(int error, erule_drawing_extension* ext, const erule_scalddir& other);
    ~collision_entry() { erule_heap.memfree(this, sizeof(*this));  this = 0; }
};
gavl_inline(entry,collision_entry,reported_collisionP);


collision_entry::
collision_entry(int error, erule_drawing_extension* ext, const erule_scalddir& other)
: collision(ext, other, error)
{
    AS(!this);
    this = (collision_entry*)erule_heap.mem(sizeof(*this));
    entry = &collision;
}


static class reported_collisions {
    gavlroot(entry,collision_entry,reported_collisionP) collisions;
public:
    boolean operator()(int error, erule_drawing_extension* e, const erule_scalddir& dir);
} already_reported;

static boolean reported_collisions::
operator()(int error, erule_drawing_extension* e, const erule_scalddir& dir) {
    collision_entry* coll = new collision_entry(error, e, dir);
    boolean val = (int)(collisions.insert(coll) != coll);
	// (int) type cast avoids stupid c compiler bug -- it thinks
	// that the result of ptr != ptr is of type ptr.
    if (val) delete coll;
    return val;
}


void erule_drawing_extension::collision_error(const erule_scalddir& dir)
{
    if (already_reported(ERR_VERSION_ACROSS_DIRECTORIES, this, dir)) return;

    erule_err.message(ERR_VERSION_ACROSS_DIRECTORIES, 
                      erule_current_drawing, this);
    erule_err ERR_INDENT << "Already in " << 
	      scald_directory.which(FALSE) << " " <<
	      scald_directory.name() ERR_NL;
    erule_err ERR_INDENT << "Ignoring " <<
	      dir.which(FALSE) << " " << dir.name() ERR_NL;
}


erule_drawing_extension* erule_drawing_extension::
check_prim_collision(const string& extension, const erule_scalddir& scalddir)
{
    if (name() != extension) {
	if (already_reported(ERR_PART_AND_PRIM, this, scalddir)) return 0;
    
	erule_err.message(ERR_PART_AND_PRIM, erule_current_drawing, this);
	erule_err ERR_INDENT << "Using ." << name() << " from " << 
		  scald_directory.which(FALSE) << " " <<
		  scald_directory.name() ERR_NL;
	erule_err ERR_INDENT << "Ignoring ." << extension << " from " <<
		  scalddir.which(FALSE) << " " << scalddir.name() ERR_NL;
	return 0;
    }

    return check_scalddir_collision(scalddir);
}

