.DS L

.BC
dwg_exception.cl -- A drawing for which a specific extension has been chosen;
bypassing the selection rules.
.EC
.PV
#ifndef ER_DWG_EXCEPTION_H
#define ER_DWG_EXCEPTION_H 1
#include "er_heap.h"
#include "Clib/stringt.h"
#include "dwg_special.h"
#include "dwg_version.h"
class erule_drawing_extension;
class erule_rule;
class erule_scalddir;
class erule_lex;

gavl_define(_name,erule_drawing_exception,string);
.EP
class erule_drawing_exception {
.PV
    gavl_inst(_name,erule_drawing_exception,string);
    erule_drawing_extension* _extension;
    erule_drawing_special* _special;
.EP
public:
    erule_drawing_exception(const string& name, erule_drawing_extension*
                            erule_drawing_special*);
    ~erule_drawing_exception() 
	{ fault("~erule_drawing_exception() not implemented"); }
    erule_drawing_special* special();
    erule_drawing_extension* extension();
};
.PV
gavl_inline(_name,erule_drawing_exception,string);

inline const string& erule_drawing_exception::name() { return _name; }
inline erule_drawing_special* erule_drawing_exception::special()
    { return _special; }
inline erule_drawing_extension* erule_drawing_exception::extension()
    { return _extension; }
#endif
.EP
.DE
