\" This is the template for the release documentation
\"
\" You need to fill in the following 4 lines with your
\" package name, version string, number of blocks, and
\" Installation format (generally Vinstall or VMSinstall).
\" Then fill in the necessary paragraphs.

.ds PN ValidCOMPILER
.ds VR 1.4 VAC-P1
.ds OV 1.3 VMS-P6
.ds BL 3384
.ds IF VMSinstall

.ds CF \*(PN   Version \*(VR
.sp 20
.TL
Release Notice
.sp 12
.LG
.LG
\*(PN
.SM
.SM
.sp 3
Version \*(VR
.sp 3
\*(BL Blocks
.sp 4
\*(IF Installation Format
.sp 15
.AU
.LG
Valid Logic Systems Incorporated
.SM
.AE
.bp
.nr PS 12
.nr VS 14
.NH 1
Introduction
.LP

The \fBValidCOMPILER\fP converts a design, which may be hierarchical,
into a flat netlist usable by verification tools.  It detects and reports
errors in the use of the \fBSCALD III\fP schematic language.
.NH 1
Changes in Version \*(VR
.LP
Table-driven expansion control has been added.  This facilitates library
development and the use of multiple types of models with the same analysis
tool (such as a mixed-mode simulation).

Support for bit taps which interpret the specified bits as cardinal numbers.

Strings and identifiers are allowed in relational expressions (such as may
occur within selection expressions).  Such comparisons as param='foo\ bar'
are now legal.  (The example would be true if param was a
parameter or other text macro whose value
was the string 'foo\ bar'.)
Strings and identifiers may be compared together
or with each other, but not with integers.

A selection expression may consist of the keywork DEFAULT, in which case
it evaluates TRUE if and only if none of the other expressions evaluate
TRUE. 

Some new error messages have been added that are appropriate to the
above enhancements.

The following bugs have been fixed over version \*(OV
.IP *
Primitives that contain text-macro invocations dependent on parameterization
are not correctly handled unless an EXPR property is present.
.IP *
Linker generates assertion check failure "Page already exists" and
then exits when compiler compiles a drawing with many (and/or long-valued)
parameters. (That is, that parameter names and values concatenated 
together produces a long string.)
.IP *
Some designs with interface signals synonymed together AND interface
signals synonymed to globals will cause the linker to fail with
the message "Global-tie insertion fails".  STARS 1574.
.IP *
Linker fails to report synonyming together 2 signals with name properties
(timing verifier assertions).
.IP *
Can't turn off creation of cmpexp.dat with OUTPUT directive.
STARS 1564.
.IP *
Infinite loop in SCALD compiler ERROR_HELP processing.  STARS 1659.
.IP *
OVERSIGHT 176 not documented in ERROR_HELP output.  STARS 1820.
.IP *
Compiler issues no error when SIG_NAME is improperly connected to
something by the user.  STARS 1866.
.IP *
Compiler doesn't report pin that's a subrange of another pin as
an error -- linker then dumps core.  STARS 1780.

.NH 1
Dependencies
.LP
Library installation resulting in the existence of the files
SCALD$ROOT:[LANGUAGE]CONFIG.DAT and SCALD$ROOT:[LIBRARIES]MASTER.LIB.
\fBGed\fP installation -- \fBged\fP drawings are the \fBValidCOMPILER\fP's
primary input.
.NH 1
Known Problems in Version \*(VR
.LP
.IP *
When SCALD directories are moved and have had shadow directories created
by the system, then the system will create new shadow directories for
the "new" SCALD directories without deleting the ones created for the old
directories.
.IP *
The linker will not report signals synonymed to their own complement.
The SCALD compiler reports these as ERRORs and the ValidCOMPILER should
do likewise.
.IP *
Errors in processing compiler directives and the "path name exceeds 
maximum length"
error (when generated by the linker)
are generated when no list file is open and thus do not make it into the
cmplst.dat file.  Directives errors are reported to the monitor and to
cmplog.dat.  The "path name exceeds maximum length" error when generated by 
the linker is reported only to the monitor and does not stop the host
tool (ValidCOMPILER, ValidSIM, etc.) from proceeding, 
though its results will be erroneous.  This occurs
because the error is detected while the design is being communicated to
the host tool (other errors being detected before this phase).
Note that this error
occurs \fBextremely\fP rarely -- only in cases of \fBvery\fP
deep hierarchy and 
only when the host program was written in PASCAL (as was ValidSIM).
.IP *
The compiler does not detect changes to property attributes 
(such as making a property INHERIT(PIN) where before it was not) when
deciding whether to recompile a page.  
(Property attributes describe how a property can be used, not what
its value is -- see the ValidCOMPILER manual for a full description.)
This kind of change is usually
made very infrequently.
If changes of this kind are made, then
all old page compiler results must be removed by deleting the shadow 
directories that have been used to hold them.
.NH 1
Installation and Configuration
.LP
Use \*(IF.
.NH 1
Documentation
.LP
Please refer to the ValidCOMPILER Manual and the SCALD III Language manual.
Details of the expansion control and bit tap features are described in the
attached ERSes.
.bp
.de BC \"	BC -- begin (filled) comment within unfilled code
/*
.in +4
.fi
..
.de EC \"	EC -- end filled comment
.in -4
.nf
*/
..
.de NM \"	NM -- normal (or text) mode 
.ds TP text \"		elide .PV -> .EV sections
.ds CH - % - \"		Restore headers and footers
.ds CF \\*(Cf
.nr HM \\n(Hm
.nr FM \\n(Fm
..
.de PV \"	PV -- begin private (to code) section
.di zX
..
.de EP \"       EP -- end private section
.di
.if '\\*(TP'code' .zX
..
.de CD \"	CD -- code mode 
.ds TP code
.ds CH
.ds CF
.nr HM 0i
.nr FM 0i
..
\"
\" Initialize
\"
.ds Cf \*(CF \"		Save state
.nr Hm \n(HM
.nr Fm \n(FM
.CD \"			Code mode 'til stated otherwise
.de CR \"	Copyright notice
.FS
.ie \\n(.$ \\{
(C)\\ Copyright\\ \\$1,1988\\ \\ Valid\\ Logic\\ Systems,\\ Inc.
\\}
.el \\{
(C)\\ Copyright\\ 1988\\ \\ Valid\\ Logic\\ Systems,\\ Inc.
\\}

This document contains confidential proprietary information which is not
to be disclosed to unauthorized persons without the written consent of an
officer of Valid Logic Systems, Inc.

The copyright notice appearing above is included to provide statutory
protection in the event of unauthorized or unintentional public disclosure.

Copy Number____
.FE
..
.	\"SY - cover sheet of released paper
.	\"     (Redifine this to insert copyright junk)
.de SY
.ll \\n(LLu
.ns
.if \\n(TV .TX
.if \\n(AV .AX
.rs
.ce 0
.nf
.sp 3
.ls 1
.pn 2
.WB
.ls 
.sp 3v
\\*(DY
.sp |7.5i	\" Used to be |9i
.if \\n(FP>0 .FA
.FG
.if \\n(GA=1 .nr GA 2
.fi
..
.ds VR NEW
.NM
.RP
.TL
Expansion Control -- ERS
.AU
Bill Hunsicker
.AI
Valid Logic Systems, Inc.
.AB
.CR 1987

Proposes a way to customize expansion rules in the SCALD language
to facilitate multi-level simulation and simplify the specification
(to the system) of
the existence of special (non-schematic) models.  The introduction
describes the problems being addressed and the ways in which they
are addressed.  The remainder of the document gives the specific
details of how the mechanism is used.  Note the last section which
describes a limitaion on the use of the mechanism over a network.

.AE
.NH 1
Introduction
.LP
The existing SCALD Language has a very restricted notion of how to
expand a hierarchy down to primitives.  This is described in the 
SCALDsystem manual.  This mechanism causes several difficulties.

.IP 1.
Some tools require textual (or other) descriptions be associated
with some "primitives".  REALCHIPtm descriptions (used by the simulator)
and "chips" files (used by the packager) are examples.
The current method requires that PRIM (or PART) drawings exist for
these components (to tell the compiler where to stop)
and that the location of the additional information be determined by
other means.  Currently, the simulator gets REALCHIP descriptions via
its own directives and the packager gets chips files by knowing about
libraries and the convention adopted for naming the chips files therein.
This is very clumsy.
.IP 2.
Mixed-mode simulation (such as use of behavior models for some
drawings and expansion to primitives for others) requires that the
use fake out the compiler in a manner similar to that used for REALCHIPtm.
.IP 3.
There is a potential for producing combined simulator/timing verifier
models for some components.  Currently, there is no good way to
represent the integrated model, if it were produced.  (It would
need to be copied or linked into both SIM.* and TIME.* files.)
.IP 4.
There is no good way to specify exceptions to the rules.
Given a behavioral description for some drawing along with an
implementation of the drawing (which expands into lower-level models),
one might want to pick the behavioral model for some simulations and
expand further for others.  It would be nice to be able to do this
without having to move around the files in the "database" to fool
the system into stopping at the right place.
.IP 5.
Some components (such as resistors) are meaningful in both analog
and digital circuits.
A mixed analog-digital simulator must be able to choose between
an analog model and a digital model on an instance-by-instance basis.
Currently, this would have to be done by using a different drawing
name to identify the 2 different types.
.LP
The proposed solution is intended to address these problems in a way that
is general, user configurable, consistent in flavor with the SCALD language,
backward-compatible and "sufficiently" easy to use.

The first two of these are addressed by providing a way to define (to
the system) "special" files (containing non-schematic models for some
target tool).
Where these files are encountered in
drawing directrories (while compiling for the target for which
the special file is defined),
primitives (called herein psuedo-primitives) are
manufactured with the expansion
data reflecting both the kind of primitive and the full name of the
file that represents it.  The tool does not then need to be told in
other ways how to find the information.  Note that this does away with
the need for the simulator to have directives which give the location of
realchip models.  It also does away with the need for the packager to
know anything at all about libraries.

The third problem is addressed by providing configurable expansion
rules.  This also handles the problem of what precedence to assign
to the psuedo-primitives discussed above.  The syntax for specifying
these rules also provides the way to specify the names of the
non-schematic model files.
Each compile type is given its own set of rules.  Compile types not
explicitly given rules will be treated as they are now.

The fifth problem is best addressed within the tool itself.  Given an analog
psuedo-primitive for a resistor, the simulator can choose to substitue a
digital model where more appropriate.  However; in discussions with the
mixed-mode simulator group at Valid, they have requested that the user also
be allowed to make an explicit specification where he wishes to do so.
This is most 
naturally addressed by some way of distinguishing
the different kinds of components by parameterization -- the system already
contains mechanisms for dealing with this form of context sensitivity.
Selection expressions are added to the rules to allow them to be varied
according to the parameterization on the body.  For example, the expansion
rule for a mixed mode simulation can specify that if CKT_DOMAIN=ANALOG then
a SUBCKT file takes precedence over a SIM drawing, but if CKT_DOMAIN=DIGITAL
then the SIM drawing takes precedence.  Resistors (having both of these)
could then be characterized by parameterization.

The fourth problem (exceptions generated to limit the complexity of the
resulting curcuit) could be addressed by clever use of the above mechanisms,
but this is too cumbersome for most users.  A mechanism for specifying
explicit exceptions by drawing name is provided.  Later this may be expanded
to allow more instance-dependent exceptions to be made, but for the first
cut only drawings may be specified.  The exception is applied wherever
the drawing is encountered.
.NH 1 
Expansion Rules
.LP
Expansion rule specifications are made in expansion rule files.
The expansion rules for a given compile type are completely defined in one 
file.  A user can specify his own rules by writing an expansion rules file
and informing the compiler of its existence with the
EXP_RULES_FILE
directives, which take a list of file names as usual.
When rules for a compile type are found in some rules file, any rules for
that compile type previously found in other files are discarded.

These files follow usual SCALD conventions.  The syntax is as follows.

.DS
file :== FILE_TYPE = EXPANSION_RULES ;
         compile_type_spec_list
	 END .

compile_type_spec_list :== compile_type_spec |
                           compile_type_spec_list compile_type_spec
compile_type_spec :== compile_type selection_expression : drawing_type_list ;

compile_type :== identifier
drawing_type_list :== drawing_type_list drawing_type | null
drawing_type :== identifier | 
                 identifier ( attribute ) |
		 standard_prim
standard_prim :== PRIM ( directory_type ) |
                  PART ( directory_type )
directory_type :== identifier;

attribute :== PRIMITIVE | SPECIAL
.DE
The non-terminal "selection_expression" follows the syntax of
SCALD selection expressions.  
It must be quoted unless it consists of a single identifier only.

The order of specification of the drawing types determines their
precedence.  (Earlier ones win over later ones.)

Any drawing type without the attribute SPECIAL is taken to be a
(GED) drawing extension name (such as LOGIC or SIM).

Drawing types (other than PRIM or PART) without attributes are taken to
be hierarchical (non-primitive) drawings.  If they turn out to be leaf
drawings, an oversight is emitted unless the TERMINAL property exists
on the drawing body.  (This is consistent with current behaviour.)

Drawing types with the attribute PRIMITIVE are GED drawings that will be
regarded as primitive.  
.ie '\*(VR'OLD' \{
When compiling primitives, any internal 
connectivity is ignored -- they are compiled only to obtain any
properties attached to the drawing body.
\}
.el \{
These are not compiled -- their presence causes the generation of a primitive.
\}


The PRIM and PART drawing types are special and equivalent --
this is required for backward compatibility.
They are
always considered primitive when encountered.  They are considered only
when they appear in a drawing that was found in a SCALD directory of the
right type.  Note that the SCALD directory for the sim library starts with
the line "FILE_TYPE=SIM_DIR;".  This line gives the directory the type "SIM".
User directories are given the type "LOGIC" (their first line will
be "FILE_TYPE=LOGIC_DIR;").  The expansion rules allow the specification 
of the directory types that contain primitives recognized by the target
program.  Note that the specification of such in the expansion rules
does not by itself make the target tool understand the primitive -- it
just declares (to the compiler) that the drawings are primitive.

Drawing types with the SPECIAL attribute are taken to be the names of
non-GED files for which psuedo-primitives are to be generated.  The compiler
gives them 2 body properties to identify them to the target tool and 
tell it where to get them.
.IP 1.
The PRIM_TYPE property has the drawing type as its value.
.IP 2.
The PRIM_FILE property contains the rooted name of the special file.
(This should contain whatever modelling information is needed by the tool.)
.LP
One such (expansion rules) 
file will be provided, giving default rules for Valid-supplied
tools.  It consists (in part) of the following (the simulator
material being hypothetical):
.DS
FILE_TYPE=EXPANSION_RULES;
SPICE: subckt(special), prim(spice), spice, logic;
SIM: realchip(special), prim(sim), prim(simtv), sim, simtv, logic;
MIXED_SIM DEFAULT: realchip(special), subckt(special), 
    prim(spice), spice, prim(sim), prim(simtv), sim, simtv, logic;
MIXED_SIM ckt_domain=digital: realchip(special), subckt(special), 
    prim(spice), spice, prim(sim), prim(simtv), sim, simtv, logic;
TIME: prim(time), prim(simtv), time, simtv, logic;
LOGIC: chips_prt(special), prim(logic), logic;
END.
.DE

Note that compile for MIXED_SIM will pick an analog description for a
component whereever that exists unless the component is given the
parameter ckt_domain=digital.  

.NH 2
Default Rules
.LP
When compiling for a target whose rules are unspecified, the compiler
will behave as previous compilers behaved.
Compile for logic (barring expansion rule specification) is equivalent to use
of the rule 
.DS
LOGIC: prim(logic), logic;
.DE
and compile for FOO (other than logic) is equivalent to use of
.DS
FOO: prim(foo), foo, logic;
.DE
.NH 2
LOGIC is Special
.LP
The drawing/directory type LOGIC is special in the following ways:
.IP 1.
Directories of type logic are ALWAYS read (for any compile type).
Directories of other types are read only if they could contain
PRIM (or PART) drawings.
.IP 2.
Drawings of type LOGIC can always be used -- if LOGIC is not explicitly
mentioned in the expansion rule for some compile type then the rule
is treated as if LOGIC were appended to the end of the list.
Thus "FOO:\ prim(foo),\ foo;" is 
equivalent to "FOO:\ pim(foo),\ foo,\ logic;".
.IP 3.
Plumbing bodies can have only LOGIC (and, of course, BODY) drawings.
This is because they are compiled out within the pages where they
occur so thier meanings can not be dependent on compile type.
.LP
In general, drawings of type LOGIC are created to implement something and
other types are created to model the behavior of something in a way that
is significant to some particular tool or set of tools.
.NH 2
Mixing primitives and psuedo-primitives
.LP
Where a non-schematic model has been chosen for a drawing, but a primitive
also exists (and whould have been chosen over other schematic 
representations), the compiler will combine them.  This results in adding
the properties on the DRAWING body within the primitive to the list of
properties on the pseudo-primitive.  It also results in the processing
of special SCALD properties on the drawing body (such as the dreaded
PART_NAME property).  (In some of our library components, the packager 
counts on the part name to select between alternate package types
for a component.  The part name is changed by the presence of a property
of the form PART_NAME=prefix%param.)

For most components, this mechanism is not necessary and the PART drawings
could be deleted from their library representations.
.NH 1
Rules for Naming Special Files
.LP
Special files (non-schematic models) are kept in the drawing directory of
the drawing with which they are associated.  Their names correspond to
the identifier used to represent them in expansion rules.
On UNIX systems the file name is a lower-case version of this identifier.
On VMS machines the names
are case-insensitive and are (the same) identifiers but with the added
file type ".DAT".  
References to special file types in the rules definition files are 
case-insensitive.

To avoid confusion with GED files, user-defined names should
not contain the underscore
character ('_'), though this is not specifically prohibited, as the
Valid defined file chips_prt contains it.

These rules result in the contents of expansion rules files being
system independent
and are consistent with the way that drawing directories are transported
between UNIX and VMS systems with netcopy.
.NH 1
Specifying Exceptions
.LP
Exceptions cover both wanting to delete some portion of the hierarchy
to save time and wanting to force the selection of some particular
extension (or special) file for selected drawings in violation of the
normal precedence rules.  Both of these could be done by clever use
of parameterization and expansion rule selection expressions, but that
is cumbersome.

A compiler directive allows the specification of specific extensions to
be chosen for certain drawings for specified compile types.  The compile
type for which the directive is effective is included so that the same
directives file can be used to compile for multiple compile
types.
Its syntax
is:
.DS
pick_directive :== PICK ( compile_type ) extension_to_use drawing_list ;
compile_type :== identifier
.ie '\*(VR'OLD' \{
extension_to_use :== identifier
\}
.el \{
extension_to_use :== drawing_type
(drawing_type takes same syntax as in rules file)
\}
drawing_list :== drawing_name more_drawings
more_drawings :== , drawing_name more_drawings | null
drawing_name :== string
.DE
The directive can be specified as many times as desired.
.NH 1
Limitation on Backward Compatibility
.LP
The PRIM_FILE property is included in the 
expanded netlist for "special" primitives to identify
the file containing their model.
As NFS does not contain the concept of a "network
rooted" name, the name given can only be guaranteed to be good for the 
node on which the compilation occurred (and only as long as the mount
table remains consistent regarding those file names).  

For tools using the linker, this is not much of a problem -- the file name
is guaranteed to be used on the node that calculated it, and remapping the
directories while programs are running
can be considered playing with a loaded gun -- if you get shot, 
its your fault.

For tools using expansion files this means that an expansion file
produced on one node may not be valid on other nodes if the design
contains references to special models.

This effect can be minimized by mounting libraries in the same locations
on all nodes that will be used by project personnel; however, this
assumes that all such nodes are either UNIX or VMS nodes -- not a mixture.

This problem can be overcome entirely given a mechanism that makes
the project drawing name space available to all tools in some
automatic manner.  Then the PRIM_FILE property becomes redundant --
the tool simply asks the file name server for the name of the
file of type \fIspecial\fP
(as given the PRIM_TYPE property) that goes with the current drawing.
.bp
.NM
.TL
Cardinal Bit Taps -- ERS
.AU
Bill Hunsicker
.AI
Valid Logic Systems, Inc.
.CR
.NH 1
Problem
.LP
Current bit tap implementations are confusing.  Because of this, 
the flattener
concocts bogus non-functional bit taps that look good but are difficult
to use if the flattened drawing is edited with ged.
.NH 1
Data
.LP
The current SCALD 3 language supports plumbing bodies that take apart
signals based on ordinal values.  The standard library contains MSB TAP
and LSB TAP which can split off high-order and low-order bits of a bus.
It is also possible to construct bit taps that take off bits within the
bus starting at a specified offset from the high or low end.  However,
this can be confusing.  Attaching such a bit tap to FOO<7..0> to split off
bit 4 (as an offset from the LSB) yields FOO<4> (by synonyming); however,
attaching the same tap (with same offset) to FOO<12..3> yields FOO<7>.

We need a
bit tap that splits off a cardinal bit (or bits) from a named bus.
If the bit tap is attached to FOO<7..0> and splits off bit 4, you get
FOO<4>.  If attached to FOO<12..3> and splits off bit 4, you still
get FOO<4>.
.if 0 \{
.NH 1
Solution -- Cardinal Bit Tap Bodies
.LP
A cardinal bit tap is a special kind of plumbing body.
It has one pin that must be attached to a \fBnamed\fP bus.  
It has other pins
(usually just one) that have the CARDINAL_TAP property.  
The
value of the cardinal tap property is a bit number or subrange specification.
The specification can be with or without enclosing angle brackets.
The signal attached to a pin with the CARDINAL_TAP property is synonymed
to the bit(s) of the bus specified by the value of the property.

The bus pin must be connected \fBdirectly\fP (not via other plumbing bodies)
to a \fBsingle named\fP bus.  Pass through pins are allowed for the
bus pin, as long as the connection is to exactly one named bus (with the
pass-through side connected to an unnamed signal, NC or the same bus.

The CARDINAL_TAP pins may \fBnot\fP have pass-through pins.

Whenever a body has a CARDINAL_TAP property on one or more of its pins,
it is a cardinal tap body and must conform to this syntax.

Cardinal tap bodies do not have drawings other than body drawings, as their
meaning is conveyed entirely through what is on the body.

All \\NAC pins on the body will inherit the same polarity.
\}
.if 0 \{
.NH 1
Solution -- Cardinal Bit Tap Bodies
.LP
A cardinal bit tap is a special kind of plumbing body.
It has one pin that must be attached to a \fBnamed\fP bus and
one other pin that functions a the tap.  This pin is identified by the
presence of the TAPWIDTH property (whose value is unused).
The body is given a CARDINAL_TAP property.
The value of the cardinal tap property is a bit number or subrange specification.
The specification can be with or without enclosing angle brackets.
The signal attached to the tap pin is synonymed
to the bit(s) of the bus specified by the value of the CARDINAL_TAP property.

The bus pin must be connected \fBdirectly\fP (not via other plumbing bodies)
to a \fBsingle named\fP bus.  Pass through pins are not allowed.

Cardinal tap bodies do not have drawings other than body drawings, as their
meaning is conveyed entirely through what is on the body.

If both pins are \\NAC pins then they must connect to signals of the same
assertion.

A body is a cardinal tap body if it has either of these properties present,
though it is an error not to have both of them.
\}
.if 0 \{
.NH 1
Solution -- Cardinal Bit Tap Bodies
.LP
A cardinal bit tap is a special kind of plumbing body.
It has one pin called BUS that must be attached to a \fBnamed\fP bus and
one other pin called TAP that functions a the tap.
These pins are identified by name.  
The body is given a CARDINAL_TAP property.  The presence of this property
denotes a cardinal tap body.
The value of the cardinal tap property is a bit number or subrange specification.
The specification can be with or without enclosing angle brackets.
The signal attached to the tap pin is synonymed
to the bit(s) of the bus specified by the value of the CARDINAL_TAP property.

The bus pin must be connected \fBdirectly\fP (not via other plumbing bodies)
to a \fBsingle named\fP bus.  Pass through pins are not allowed.

Cardinal tap bodies do not have drawings other than body drawings, as their
meaning is conveyed entirely through what is on the body.

If both pins are \\NAC pins then they must connect to signals of the same
assertion.
\}
.if 1 \{
.NH 1
Solution -- Cardinal Bit Tap Bodies
.LP
A cardinal bit tap is a special kind of plumbing body.
It has one pin that must be attached to a \fBnamed\fP bus.  
It has one other pin with the BN (bit number) property.
The
value of the BN property is a bit number or subrange specification.
The specification can be with or without enclosing angle brackets.
The signal attached to a pin with the BN property is synonymed
to the bit(s) of the bus specified by the value of the property.
Pass through pins are not allowed.

When using the body,
the bus pin must be connected \fBdirectly\fP (not via other plumbing bodies)
to a \fBsingle named\fP bus.  That bus may be part of a concatenated signal
and may appear multiple times therein, but there must be exactly one named
bus in such a signal.  If a the same bit appears more than once in the
attached bus then its tapped representation gathers properties from all
of its appearances.  This subtelty is important only for inherit-pin
properties, as they are cumulative and appear in the output as many times
as they are specified.

Whenever a body has a BN property on one or more of its pins,
it is a cardinal tap body and must conform to this syntax.  

Cardinal tap bodies do not have drawings other than body drawings, as their
meaning is conveyed entirely through what is on the body.

The presence
of the BN property implies \\NWC on that pin.
The bus pin should be explicitly given the NOWIDTH property (\\NWC);
otherwise, it is restricted to being a fixed-width pin
which is not very useful here.

All \\NAC pins on the body will inherit the same polarity.  Non-\\NAC
pins behave according to their own bubble-state.
The standard library will contain a cardinal tap body which has \\NAC
on both pins.

Note: this syntax leaves open the door to future generalization by allowing
pass-through pins and more than one tap pin per cardinal tap body.

GED must display the value of the BN property by default.  (The normal
behavior for default pin properties is display "invisible".)
\}
.bp
