\" This is the template for the release documentation
\"
\" You need to fill in the following 4 lines with your
\" package name, version string, number of blocks, and
\" Installation format (generally Vinstall or VMSinstall).
\" Then fill in the necessary paragraphs.

.ds PN ValidCOMPILER
.ds VR 1.4 SUN4-P6
.ds LV 1.4 SUN4-P4
.ds OV 1.4 SUN4-P3
.ds BL 5542
.ds IF Vinstall

.ds CF \*(PN   Version \*(VR
.sp 20
.TL
Release Notice
.sp 12
.LG
.LG
\*(PN
.SM
.SM
.sp 3
Version \*(VR
.sp 3
\*(BL Blocks
.sp 4
\*(IF Installation Format
.sp 15
.AU
.LG
Valid Logic Systems Incorporated
.SM
.AE
.bp
.nr PS 12
.nr VS 14
.NH 1
Introduction
.LP

The \fBValidCOMPILER\fP converts a design, which may be hierarchical,
into a flat netlist usable by verification tools.  It detects and reports
errors in the use of the \fBSCALD III\fP schematic language.
.NH 1
Changes in Version \*(VR
.LP
This is a replacement for thw \*(LV kit which contained sun3 access daemons.
Instead the Highland Digital security package has been used.
.LP
The following bugs have been fixed over version \*(OV
,IP *
The only other difference between this release and the \*(LV release is that
STARS 27694 has been fixed (for expansion file generation).  
This was a bug that caused unnamed signals that became low-asserted to be
treated as named signals for the purpose of base signal name selection. In
other words the unnamed signal "-UN$1$LS04$2P$A<0>" would get chosen over
the named signal "-ZZ<0>" as the base signal name where these were synonymed.
This bug affects only users who use BUBBLE_CHECK ON (as BUBBLE_CHECK OFF generates
only high-asserted unnamed signals).  
.LP
.NH 1
Dependencies
.LP
Library installation resulting in the existence of the files
/usr/valid/tools/language/config.dat and /usr/valid/lib/master.lib.
\fBGed\fP installation -- \fBged\fP drawings are the \fBValidCOMPILER\fP's
primary input.
.LP
Requires Sun OS version 4.xx (not compatible with version 3).
.NH 1
Known Problems in Version \*(VR
.LP
.IP *
The file-locking mechanism works only locally. If 2 users on different
machines compile the same drawing simultaneously and write to the same
(NFS-mounted) shadow directory, collisions may occur.  Using only local
(non-NFS-mounted) shadow directories will prevent this occurrence entirely.
.IP *
When SCALD directories are moved and have had shadow directories created
by the system, then the system will create new shadow directories for
the "new" SCALD directories without deleting the ones created for the old
directories.
.IP *
The linker will not report signals synonymed to their own complement.
The SCALD compiler reports these as ERRORs and the ValidCOMPILER should
do likewise.
.IP *
Errors in processing compiler directives and the "path name exceeds 
maximum length"
error (when generated by the linker)
are generated when no list file is open and thus do not make it into the
cmplst.dat file.  Directives errors are reported to the monitor and to
cmplog.dat.  The "path name exceeds maximum length" error when generated by 
the linker is reported only to the monitor and does not stop the host
tool (ValidCOMPILER, ValidSIM, etc.) from proceeding, 
though its results will be erroneous.  This occurs
because the error is detected while the design is being communicated to
the host tool (other errors being detected before this phase).
Note that this error
occurs \fBextremely\fP rarely -- only in cases of \fBvery\fP
deep hierarchy and 
only when the host program was written in PASCAL (as was ValidSIM).
.IP *
The compiler does not detect changes to property attributes 
(such as making a property INHERIT(PIN) where before it was not) when
deciding whether to recompile a page.  
(Property attributes describe how a property can be used, not what
its value is -- see the ValidCOMPILER manual for a full description.)
This kind of change is usually
made very infrequently.
If changes of this kind are made, then
all old page compiler results must be removed by deleting the shadow 
directories that have been used to hold them.
(If shadow directories have not been explicitly specified, then
"rm -r xshadowx" will work just fine when executed from the directories
in which compilation has been done.)
.NH 1
Installation and Configuration
.LP
Use vinstall.  The executables expgen (ValidCOMPILER) and comp (SCALD compiler)
end pcomp (ValidPAGECOMP) use the Highland Digital security package.
.NH 1
Documentation
.LP
Please refer to the ValidCOMPILER Manual and the SCALD III Language manual.
