#define FCNTL_NOT_SUPPORTED 1
#if PC_AT
#define FLOCK_NOT_SUPPORTED 1
#endif
/* This file implements the following functions usable by SVS pascal.
   None of them allocate C heap space, so don't worry!
   
   These routines require the installation of /u0/scald/compiler/rcomp
   the remote node.
   These functions operate only on remote nodes (and do not work for 
   OPUS system 5).

function efs_rm(uid: Cint; node, name, err: xtring): boolean;
  { remove name (EFS path name) from node (redundant, but this pointer
    is used as a partial key in the table of remote slaves).  uid
    must be set to reflect the current effective user id (and is used
    as a partial key in the table of remote slaves). Return TRUE iff
    successful.  If err is non-NIL then assume it points to a buffer
    of MAX_STRING_LENGTH + 1 bytes and return an error message in it
    upon failure. }
cexternal;                                                            {S32}
{ begin  efs_rm := FALSE;  end;                                    }(*SUN*)
{ begin  efs_rm := FALSE;  end;                                  }(*OPUS5*)
{ begin  efs_rm := FALSE;  end;                                    }(*VAX*)


function efs_lock(uid: Cint; node, name, err: xtring): boolean;
  { lock name (EFS path name) on node (redundant, but this pointer
    is used as a partial key in the table of remote slaves).  uid
    must be set to reflect the current effective user id (and is used
    as a partial key in the table of remote slaves). Return TRUE iff
    successful.  If err is non-NIL then assume it points to a buffer
    of MAX_STRING_LENGTH + 1 bytes and return an error message in it
    upon failure. }
cexternal;                                                          {UNIX}
{ begin  efs_lock := FALSE;  end;                                 }(*VAX*)


function efs_unlock(uid: Cint; node, name, err: xtring): boolean;
  { unlock name (EFS path name) on node (redundant, but this pointer
    is used as a partial key in the table of remote slaves).  uid
    must be set to reflect the current effective user id (and is used
    as a partial key in the table of remote slaves). Return TRUE iff
    successful.  If err is non-NIL then assume it points to a buffer
    of MAX_STRING_LENGTH + 1 bytes and return an error message in it
    upon failure. }
cexternal;                                                        {UNIX}
{ begin  efs_unlock := FALSE;  end;                             }(*VAX*)


*/

#ifdef S32
#define UNIX
#define BSD42
#define REVERSE
#endif S32

#if defined(SUN3) || defined(SUN4) || defined(PMAX)
#define UNIX
#define BSD42
#endif

#ifdef PC_AT
#define REVERSE
#define UNIX
#define SYS5
#endif PC_AT


#ifdef UNIX  /* no VMS code here */


#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/file.h>
#include <fcntl.h>
#include <errno.h>
#include "lib/misc/assert.h"
extern int errno;

#define NULL 0
#define MAX_STRING_LENGTH 255

#define PBOOLEAN int    /* PASCAL boolean (for return values) */
#define PTRUE 1
#define PFALSE 0


typedef char *xtring;  /* Valid Logic Sys portable pascal string --
                         first byte has char count, no terminating null.
			 ex. "Hi there" is '\9'Hi there */


static        char      errbuf[MAX_STRING_LENGTH+1]={""};


/*
 * Convert C string to PASCAL sstring (will work for p == c).
 */
static int
c_to_pas(p, c)
register char *p, *c;
{
    register char *startc;
    int ret, len;

    for (startc = c ; *c ; c++) ;
    if ((c - startc) > MAX_STRING_LENGTH) c = startc + MAX_STRING_LENGTH;
    ret = (int)(!(*c));
    p += (len = (c-- - startc));
    while (c >= startc) *p-- = *c--;
    *p = (char)len;
    return ret;
}


/*
 * Convert PASCAL sstring to C string (will work for c == p).
 */
static void
pas_to_c(c, p)
register char *c, *p;
{
    register char *end;

    end = p + *(unsigned char*)p;
    p++;
    while (p <= end) *c++ = *p++;
    *c = '\0';
}



static int locked_fd={-1};       /* fd used to lock a local file */
static char locked_file[MAX_STRING_LENGTH+1];

PBOOLEAN
#ifdef REVERSE
efs_lock(err,name,node,uid)
#else
efs_lock(uid,node,name,err)
#endif REVERSE
    /* lock name (EFS path name) from node (redundant, but this pointer
       is used as a partial key in the table of remote slaves).  uid
       must be set to reflect the current effective user id (and is used
       as a partial key in the table of remote slaves). Return TRUE iff
       successful.  May return message in err if not successful. */
    xtring err,name,node;
    int uid;
{
    struct flock lock_desc;
    lock_desc.l_type = F_WRLCK;
    lock_desc.l_whence = 0;	/* from start of file to EOF */
    lock_desc.l_start = 0;
    lock_desc.l_len = 0;
    lock_desc.l_pid = 0;

    if (locked_fd >= 0) {
        strcpy(errbuf,"can only lock 1 file at a time");
	if (err != NULL) c_to_pas(err,errbuf);
	return PFALSE;
	}

    if (*node != 0) FAULT("Expected null node");

    pas_to_c(locked_file, name);
    if ((locked_fd = open(locked_file, O_RDWR+O_CREAT, 0666)) < 0) {
	strcpy(errbuf, "open failed");
	if (err != NULL) c_to_pas(err,errbuf);
	return PFALSE;
	}

#if FCNTL_NOT_SUPPORTED
#if !FLOCK_NOT_SUPPORTED
    while (flock(locked_fd,LOCK_EX+LOCK_NB)!=0) {
        if (errno!=EWOULDBLOCK) {
	    sprintf(errbuf, "flock() failed -- errno %d", errno);
	    if (err != NULL) c_to_pas(err,errbuf);
#ifdef DEBUG
	    fprintf(stderr, "%s; closing fd %d\n", errbuf, locked_fd);
#endif DEBUG
	    close(locked_fd);
	    locked_fd = -1;
	    return PFALSE;
	    }
	sleep(5);
	}
#endif FLOCK_SUPPORTED
#else
    if (fcntl(locked_fd, F_SETLKW, &lock_desc) == -1) {
	sprintf(errbuf, "fcntl() failed -- errno %d", errno);
	if (err != NULL) c_to_pas(err,errbuf);
#ifdef DEBUG
	fprintf(stderr, "%s; closing fd %d\n", errbuf, locked_fd);
#endif
	close(locked_fd);
	locked_fd = -1;
	return PFALSE;
	}
#endif /* FCNTL_NOT_SUPPORTED */
#ifdef DEBUG
    fprintf(stderr, "locked '%s' with fd %d\n", locked_file, locked_fd);
#endif DEBUG
    return PTRUE;
}

#ifdef S32
#define efs_unlock efs_unlo
#endif S32

PBOOLEAN
#ifdef REVERSE
efs_unlock(err,name,node,uid)
#else
efs_unlock(uid,node,name,err)
#endif REVERSE
    /* lock name (EFS path name) from node (redundant, but this pointer
       is used as a partial key in the table of remote slaves).  uid
       must be set to reflect the current effective user id (and is used
       as a partial key in the talbe of remote slaves). Return TRUE iff
       successful.  May return message in err if not successful. */
    xtring err,name,node;
    int uid;
{
    char specified_file[MAX_STRING_LENGTH+1];
    if (*node != 0) FAULT("Expected null node");

    if (locked_fd < 0) {
	sprintf(errbuf,"no locked file");
	if (err != NULL) c_to_pas(err,errbuf);
	return PFALSE;
	}

    pas_to_c(specified_file, name);
    if (strcmp(locked_file, specified_file)) {
	sprintf(errbuf,"this file is not locked");
	if (err != NULL) c_to_pas(err,errbuf);
	return PFALSE;
	}

    close(locked_fd);
#ifdef DEBUG
    /* ok to printf -- compiler now uses compatible heap */
    fprintf(stderr, "unlocked '%s' (closing fd %d)\n", locked_file, locked_fd);
#endif DEBUG
    locked_fd = -1;
    return PTRUE;
}
#endif UNIX
