/*
 * Wrapper for munge_remote_name so that its use can be platform-independent
 * and can pass xtrings.  NOTE: the actual C entry point is munge_remote_names
 * (munge, not mung).  PASCAL uses mung, so that this wrapper will be used
 * even under VMS.
 */

#define MAX_STRING_LENGTH 255

#ifdef S32
#define REVERSE
#endif S32

#ifdef PC_AT
#define REVERSE
#endif PC_AT


/*
 * Convert C string to PASCAL sstring (will work for p == c).
 * Return TRUE if success, FALSE (0) if string too long.
 */
static int
c_to_pas(p, c)
register char *p, *c;
{
    register char *startc;
    int ret, len;

    for (startc = c ; *c ; c++) ;
    if ((c - startc) > MAX_STRING_LENGTH) c = startc + MAX_STRING_LENGTH;
    ret = (int)(!(*c));
    p += (len = (c-- - startc));
    while (c >= startc) *p-- = *c--;
    *p = (char)len;
    return(ret);
}


/*
 * Convert PASCAL sstring to C string (will work for c == p).
 */
static void
pas_to_c(c, p)
register char *c, *p;
{
    register char *end;

    end = p + *(unsigned char*)p;
    p++;
    while (p <= end) *c++ = *p++;
    *c = '\0';
}

#ifdef DEBUG
#ifndef VAX
#define init_debug()
#define STDERR 2
#else
#include <file.h>
#define STDERR stderr_fd
static int STDERR={-1};
#define init_debug() if (STDERR < 0)\
    STDERR = open("stderr.out", O_RDWR|O_CREAT, 0644)
#endif VAX
#endif DEBUG


#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif

#ifdef REVERSE
mung_remote_names(ln, f)
#else
mung_remote_names(f, ln)
#endif REVERSE
char *f, *ln;
{
    int ret;
    char _f[MAXPATHLEN];
    char _ln[MAXPATHLEN];
#ifdef DEBUG
    init_debug();
    write(STDERR, "mung_remote_names - \"", 22);
    if (f && *f) write(STDERR, f+1, (int)*f);
    write(STDERR, "\" \"", 3);
    if (ln && *ln) write(STDERR, ln+1, (int)*ln);
    write(STDERR, "\"\n", 2);
#endif DEBUG
    pas_to_c(_f, f);
    pas_to_c(_ln, ln);
    ret = munge_remote_names(_f, _ln);
    if (!c_to_pas(ln, _ln)) ret = -1; /* too long */
#ifdef DEBUG
    if (!ret) {
        write(STDERR, "  ->\"", 5);
	write(STDERR, ln+1, (int)*ln);
	write(STDERR, "\"\n", 2);
	}
#endif DEBUG
    return(ret);
}
#ifdef S32
asm("	.text");
asm("	.globl mung_rem");
asm("mung_rem:");
asm("	jmp mung_remote_names");
#endif S32
#ifdef PC_AT
asm("	.text");
asm("	.align 1");
asm("	.globl mung_remote_names");
asm("mung_remote_names:");
asm("	jump @_mung_remote_names");
#endif PC_AT


#ifdef VAX
/*
 * Wrapper for translate$filename that returns the canonicalized
 * name (upon success) or the original name (upon failure).
 */
static char canonical[MAX_STRING_LENGTH+1];
char *
translate_vms_filename(_s)
char *_s;
{
    int ret;
    char s[MAX_STRING_LENGTH+1];
    pas_to_c(s, _s);
    if (translate$filename(s, canonical)) return _s;
    c_to_pas(canonical, canonical);
    return canonical;
}
#endif VAX

