(**){--------- page expansioin file preparateion ---------------------}


procedure process_nodes_for_separate_compilation;
  { Prepare the expansion file dictionaries for output of invoked modules.
    the modules.

    For each leaf node,
      
      1. Resolve parameters.  If an integer parameter does not resolve,
         then report error and make this a non-leaf node.
      2. Enter it in modules_in_page and establishes its module number.
      3. Enter pertinent strings and identifiers in the expansion
	 file string and id dictionaries.
    
    Assumptions: 
      for all sons of root nodes, 
      if node^.is_leaf_node then node^.called_by is de-referenceable. }
  var
    current_root: mtree_node_ptr; { current root (support size rep of root) }
    son: mtree_node_ptr;          { current son of mtree_root }
    first_leaf_node: boolean;     { TRUE until one is processed }
    dummy: numbered_token_ptr;    { for dictionary entry return value }


  function enter_into_module_table(drawing_name: xtring;
				   var parameters: parameter_ptr;
				   var module_number: natural_number): boolean;
    { finds or creates an entry for the specified module in the
      modules table.  Returns the module number of the module. Returns
      function value TRUE if the module was created - FALSE if not.
      If entry is created, then parameters (the pointer) is copied to it
      and that list is now "rooted" there.  If no entry is created, then
      parameters is released and returned as NIL }
    var
      index: module_table_range;  { bucket }
      found: boolean;             { TRUE if found module }
      temp: module_list_ptr;      { current entry of new_module_list }
      parent: module_list_ptr;    { parent of temp }
  begin
    if debug_24 then writeln(outfile, ' enter_into_module_table');

    index := module_table_index(drawing_name, parameters);
    temp := modules_in_page.table[index];  parent := NIL;
    found := FALSE;
    while (temp <> NIL) and not found do
      case compare_strings(temp^.drawing^.string_p, drawing_name) of
        LT:
          begin
            parent := temp;  temp := temp^.next;
          end;
        GT: temp := NIL; { too far }
        EQ:
          case compare_parameter_lists(temp^.context, parameters) of
            LT: 
              begin
                parent := temp;
                temp := temp^.next;
              end;
            EQ: found := TRUE;
            GT: temp := NIL; { too far }
          end;
      end;
    
    if found then 
      begin
        enter_into_module_table := FALSE;  release_all_parameters(parameters);
        module_number := temp^.number;
        if debug_24 then writeln(outfile, '   found it, ', module_number:1);
      end
    else if modules_in_page.highest < MAXINT then 
      begin
        enter_into_module_table := TRUE;
        if (parent = NIL) then 
          begin
            new_module_list(modules_in_page.table[index]);
            temp := modules_in_page.table[index];
          end
        else
          begin
            new_module_list(parent^.next);
            temp := parent^.next;
          end;
        temp^.drawing  := enter_numbered_string(drawing_name,
                                                expansion_string_dictionary);
        if (temp^.drawing = NIL) then
          begin
            enter_into_module_table := FALSE;
            if parent = NIL then 
              release_module_list(modules_in_page.table[index])
            else release_module_list(parent^.next);
            release_all_parameters(parameters);
            module_number := 0;
          end
        else 
          begin
            temp^.context := parameters;
            modules_in_page.highest := modules_in_page.highest + 1;
            module_number := modules_in_page.highest;
            temp^.number := module_number;
          end;
        if debug_24 then writeln(outfile, '  new entry ', module_number:1);
      end
    else
      begin
        enter_into_module_table := FALSE;  release_all_parameters(parameters);
        module_number := 0;
        error(24 { ovf });  { damn near impossible }
      end;
  end { enter_into_module_table } ;


  function resolve_parameters(node: mtree_node_ptr;
                              var params: parameter_ptr): boolean;
    { Builds schema parameter list for node^.called_by if this
      has not already been done.
      Returns TRUE if parameters have been successfully resolved.
      If not successfully resolved, error message has already been
      issued --  node is deleted from expansion by setting is_leaf_node 
      to FALSE.
      NOTE: the reason why we don't save the results for use by each
      node called by an invoke is that it is possible that the value
      would be different due to different values of X. }
    var
      current_param: property_ptr;  { current param on invoke_list }
      last: parameter_ptr;          { tail of list headed by params }
      id: identifier_ptr;           { symbol table entry for current_param }
      error_found: boolean;         { TRUE if an error was found }


    procedure handle_error_condition;
      { sets error_found to TRUE and node^.is_leaf_node to FALSE and
        releases the parameter list }
    begin
      error_found := TRUE;  node^.is_leaf_node := FALSE;
      number_leaf_nodes := number_leaf_nodes - 1;
      number_terminal_nodes := number_terminal_nodes + 1;
      release_all_parameters(params);  last := NIL;
    end { handle_error_condition } ;


  begin { resolve_parameters }
    if debug_24 then
      begin 
        writeln(outfile, ' resolve_parameters ');
        dump_property_list(outfile, node^.called_by^.parameters);
      end;
    error_found := FALSE;  params := NIL;  last := NIL;
    sort_param_properties(node^.called_by^.parameters);
    current_param := node^.called_by^.parameters;
    while (current_param <> NIL) and not error_found do 
      begin
        if not found_id(node, current_param^.name, id) then
          begin
            assert(36 { it must be in symbol table from pass 1 });
            handle_error_condition;
          end
        else if not id^.resolves then handle_error_condition
        else
          begin
            if last = NIL then
              begin
                new_parameter(params);  last := params;
              end
            else
              begin
                new_parameter(last^.next);  last := last^.next;
              end;
            last^.name := enter_numbered_id(id^.name,
                                            expansion_id_dictionary);
            last^.text := 
              enter_numbered_string(id^.definition, 
                                    expansion_string_dictionary);
            if (last^.name = NIL) or (last^.text = NIL) then
              handle_error_condition;
          end;
        current_param := current_param^.next;
      end;
    resolve_parameters := not error_found;
  end { resolve_parameters } ;

     
  procedure process_leaf_node(node: mtree_node_ptr);
    { Performs the process_invokes_for_separate_compilation tasks on the
      node. }
    label
      90; { return }
    var
      parameters: parameter_ptr;        { param list for module }
  begin
    if not resolve_parameters(node, parameters) then goto 90 { return };

    if enter_into_module_table(node^.called_by^.macro_name, parameters,
                               node^.module_number) then ;

    {  enter property names and values into dictionaries }
    enter_numbered_property_list(node^.called_by^.properties);

  90:
  end { process_leaf_node } ;


begin { process_nodes_for_separate_compilation }
  if debug_20 or debug_24 then 
    writeln(outfile, ' process_nodes_for_separate_compilation');
  
  current_root := mtree_root;  first_leaf_node := TRUE;
  while current_root <> NIL do
    begin
      if current_root^.macro <> NIL then
        enter_numbered_property_list(current_root^.macro^.properties);
        
      son := current_root^.son;
      while son <> NIL do
        begin
          if debug_24 then
            begin 
              if son^.is_leaf_node then write(outfile, ' LEAF node ')
                                   else write(outfile, ' NON-leaf node ');
              writestring(outfile, son^.macro_name);
              writeln(outfile);
            end;
          if son^.is_leaf_node then
	    begin
	      process_leaf_node(son);
              if first_leaf_node then
                begin
                  first_leaf_node := FALSE;
	          dummy := enter_numbered_id(PATH_prop_name,
		                             expansion_id_dictionary);
                end;
	    end;
          son := son^.next;
        end;
      current_root := current_root^.next;
    end;

  if debug_20 or debug_24 then
    writeln(outfile, ' exit process_nodes_for_separate_compilation');
end { process_nodes_for_separate_compilation } ;


procedure process_signals_for_separate_compilation;
  { Peruse signal table and enter signal names, pin names and pin/signal
    property name/values into the expansion dictionaries. }
  var
    ntok: numbered_token_ptr;               { returned token }
    sig: signal_definition_ptr;             { signal in root drawing }
    prop: bit_property_ptr;                 { prop on a sig }
    node: mtree_node_ptr;                   { current node }
    param: formal_actual_ptr;               { formal-actual on a leaf node }
    subsprop: subscript_property_ptr;       { prop list on a formal }
begin { process_signals_for_separate_compilation }
  if debug_20 then
    writeln(Outfile, 'enter process_signals_for_separate_compilation');

  (************************************************************************)
  (* Note that considerable advantage has been taken of the fact that     *)
  (* we have only compiled one page, and are therefore interested only    *)
  (* in the actuals of the root node and the formals of leaf nodes.       *)
  (************************************************************************)
  
  enter_numbered_property(BUBBLED_prop_name, nullstring);

  if mtree_root <> NIL then
    begin
      { process root and its (X-replicated) siblings -- enter signal
        names and property names and non-expanding property values. }

      node := mtree_root;
      while node <> NIL do
        begin
          sig := mtree_root^.signals;
          while sig <> NIL do
            begin
              if not is_NC_signal(sig^.signal^.name) then
	        ntok := enter_numbered_string(
	          X_replicated_name(sig^.signal^.name, node, sig^.scope),
                  expansion_string_dictionary);

              if node = mtree_root then
                begin
                  prop := sig^.properties;
                  while prop <> NIL do
                    begin
                      enter_numbered_property(prop^.name, prop^.text);
                      prop := prop^.next;
                    end;
		end;
              sig := sig^.next;
            end;
	  node := node^.next;
	end;

      { process (non-plumbing) leaf nodes, entering pin names,
        pin property names and (non-expanding) pin property values.  Ignore
	X-replication of the drawing (as this information should be the
	same for each replication. }

      node := mtree_root^.son;
      while node <> NIL do
        begin
          if node^.is_leaf_node then
            begin
              param := node^.params;
              while param <> NIL do with param^ do
                begin
                  ntok := enter_numbered_string(pin_name^.signal_name,
                                                expansion_string_dictionary);
                  subsprop := properties;
                  while subsprop <> NIL do
                    begin
                      if subsprop^.properties <> NIL then
                        enter_numbered_property_list(subsprop^.properties);
                      subsprop := subsprop^.next;
                    end;
                  param := next;
                end;
            end;
          node := node^.next;
        end;
    end;
  if debug_20 then 
    writeln(Outfile, 'exit process_signals_for_separate_compilation');
end { process_signals_for_separate_compilation } ;
