procedure forced_exit;
  { if in a critical routine, then do nothing, else clean up and return }
begin
  if in_critical_section <= 0 then
    begin
      enter_critical_section;
      if expansion_file_open then
        begin
          pipe_close(CmpExp_pipe);
          if not remove_file(page_expansion_file_name) then ;
	  { Expansion file is still marked dirty -- it will be recompiled
	    regardless of whether or not the deletion succeeded }
          expansion_file_open := FALSE;
        end;

      if schema_file_open then
        begin
          write_schema_file(schema_of_drawing_being_compiled);
        end;

      pipe_close(CmpDraw_pipe);
      pipe_close(Design_pipe);
      if debugging then writeln(Monitor, '        exiting.');
      halt_with_status(FATAL_COMPLETION);
      { exit_critical_section, obviously }
    end;
end { forced_exit } ;


procedure catch_kill_signal;
  { if this is the first kill signal, then acknowledge and call forced_exit
    to handle clean-up and exit.  Otherwise, complain about the 
    interruption. }


  procedure acknowledge_signal;
    { if debugging, then print something that indicates what happened }
  begin
    if debugging then
      begin
        writeln(Monitor, 'SIGNAL received...');
        writeln(Outfile, 'SIGNAL received...');
      end;
  end { acknowledge_signal } ;


  procedure complain_about_multiple_signals;
    { Politely inform user that he should knock off the continuous
      control-Cs }
  begin
    if monitor_open then
      if produce_amusing_messages then
        writeln(Monitor, 'I''m dying as fast as I can!!')
      else 
        begin
          writeln(Monitor, 'KILL signal already received (cleaning up)...');
          kill_count := kill_count + 1;
          if kill_count >= RIDICULOUS_KILL_COUNT then
            produce_amusing_messages := TRUE;
        end;
  end { complain_about_multiple_signals } ;


begin { catch_kill_signal }
  if kill_received then complain_about_multiple_signals
  else
    begin
      kill_received := TRUE;
      acknowledge_signal;
      forced_exit;
    end;
end { catch_kill_signal } ;


procedure enter_critical_section;
  { increment the semaphore }
begin
  in_critical_section := in_critical_section + 1;
end { enter_critical_section } ;


procedure exit_critical_section;
  { decrement the semaphore and, if not still in critical section, check
    for need to force an exit }
begin
  if in_critical_section = 0 then assert(254 { semaphore underflow })
  else in_critical_section := in_critical_section - 1;
  if (in_critical_section = 0) and kill_received then forced_exit;
end { exit_critical_section } ;


procedure init_interrupt;
  { initialize interrupt variables and enable interrupt catching.  This
    should be one of the first procedure calls made -- it should be
    before init_comp_vms (VMS), but probably after authorize (PC/AT). }
begin
  in_critical_section := 0;
  kill_received := FALSE;
  debugging := FALSE;
  expansion_file_open := FALSE;
  schema_file_open := FALSE;
  kill_count := 0;
  monitor_open := FALSE;
  pipe_init(CmpDraw_pipe);
  pipe_init(Design_pipe);
#if UNIX
  def_handler(catch_kill_signal);
#endif 
end { init_interrupt } ;


procedure kill_self;
  { Kill self via signal (to test signal catching) }
begin
#if UNIX
  suicide;
#endif
#if VAX 
  $dclast(catch_kill_signal); 
#endif
end { kill_self } ;
