
function get_time_stamp(name: xtring; var stamp: time_stamp): boolean;
  { Returns the time stamp of the file.  Returns FALSE and emits error
    if unable to do this.  Existence of the file is assumed. }
  var
    success: boolean;      { indicates success }
begin
  if debug_23 then
    begin
      write(outfile, 'get_time_stamp ');
      writestring(outfile, name);
    end;

  stamp := 0;
  success := gettime(name, stamp);
  if debug_23 then
    if success then writeln(outfile, ' ', stamp:1)
    else writeln(outfile, ' FAILED');

  if not success then
    begin
      error(237 { can't get it });
      error_dump_file_name(name);
    end;
  get_time_stamp := success;
end { get_time_stamp };


function remove_file(name: xtring): boolean;
  { Remove the named file. Return TRUE iff successful. }
  var 
#if VAX
    name_buff: VAXstring;                                        
    code: longint;
#endif
    success: boolean;
begin
#if UNIX
  success := delete_file(name);
#endif
#if VAX
  vaxname(name, name_buff);
  delete_file(name_buff, code);
  success := odd(code);
#endif

  remove_file := success;
end { remove_file };

