(**){ -- UNIX only file utilities -- }


#if UNIX
function dup_file_descriptor(var fi: textfile; 
			     desc: Cint; mode: open_mode): boolean;
  { Do a dup to get the textfile var fi to refer to the file descriptor
    described by desc.  (note: does not close the original descriptor.)
    Returns TRUE iff successful. }
  var
    ok: boolean;      { value for return }
    dev_null: xtring; { '/dev/null' }
    code: longint;    { system dependent return code }
begin
  dev_null := nullstring;
  copy_to_string('/dev/null       ', dev_null);
  ok := vopen(fi, null_alpha, dev_null, mode, code);
  release_string(dev_null);

  if debug_22 then
    if ok then write(outfile, 'dup of file descriptor ', desc:1)
    else 
      write(outfile, 'reset/rewrite failed -- dup of file descriptor ',
            desc:1);

#if SVS
  if ok then ok := (dup2(text_file_descr(fi), desc) <> - 1);
#else 
  if ok then ok := (dup2(desc, text_file_descr(fi)) <> - 1);
#endif 

  if debug_22 then
    if ok then writeln(outfile, ' SUCCEEDS')
          else writeln(outfile, ' FAILS');

  dup_file_descriptor := ok;
end { dup_file_descriptor } ;


function dup_inputfile_descriptor(var fi: inputfile; desc: Cint): boolean;
  { Do a dup to get the inputfile var fi to refer to the file descriptor
    described by desc.  (note: does not close the original descriptor.)
    Returns TRUE iff successful. }
  var
    ok: boolean;     { value for return }
    logical: alpha;  { dummy logical name }
    name: xtring;    { name of bit bucket }
begin
  ok := FALSE;
  name := nullstring;
  copy_to_string('/dev/null       ', name);
  logical := NULL_ALPHA;
  ok := creset(fi, logical, name, 0);
 
  release_string(name);

  if debug_22 then
    if ok then write(outfile, 'dup of file descriptor ', desc:1)
    else
      write(outfile, 'creset failed -- dup of file descriptor ', desc:1);


#if SVS
  if ok then ok := (dup2(cfdsc(fi), desc) <> - 1); 
#else
  if ok then ok := (dup2(desc, cfdsc(fi)) <> - 1); 
#endif

  if debug_22 then
    if ok then writeln(outfile, ' SUCCEEDS')
          else writeln(outfile, ' FAILS');

  dup_inputfile_descriptor := ok;
end { dup_inputfile_descriptor } ;
#endif UNIX
