function expression(expr_kind: expression_type): longint;
  { parse an expression and return its value. All identifiers are
    logged as hard expandable ids (which handles logging for
    selection expressions, integer parameter values, signal subscripts, 
    and any similar thing which might come along all in one swell foop!). }
  var
    val: longint;           { value of expression to be returned }

    
  function boolean_expression: longint;
    { parse a boolean expression }
    var
      val: longint;      { value of the expression so far }
      tmp_val: longint;  { temp value to parse relation expr in AND expr }
			 { because when code is translated to c, c stops }
			 { if first and condition is false, thereby exiting }
			 { midway from parsing }


    function string_expression: xtring;
      { return value of current string expression }
      var
	val: xtring;
    begin
      if sy = IDENT then
	begin
	  val := make_and_enter_string(id.name^.name);
	  insymbol;
	end
      else if sy = STRINGS then
	begin
	  val := lex_string;
	  insymbol;
	end
      else
	begin
	  val := nullstring;
	  error(4 { expected a string or identifier });
	end;
      string_expression := val;
      if debug then
	begin
	  disp_line('string_expression');
	  write(outfile, 'VALUE=');
	  writestring(Outfile, val);
	  writeln(Outfile);
	end;
    end { string_expression } ;
  
  
    function simple_expression: longint;
      { parse a simple expression and return its value }
      var
	val: longint;         { value of simple expression to be returned }
	sym: symbols;         { addition operator }
	negative: boolean;    { TRUE if expression has unary minus }
  
  
      function term: longint;
	{ parse a term and return its value }
	var
	  val,                  { value of term to be returned }
	  temp: longint;        { temp for calculations }
	  sym: symbols;         { multiplying operator }
  
  
	function factor: longint;
	  { parse a factor and return its value }
	  var
	    temp1, temp2: longint;    { temp results for MIN and MAX }
	    ret: longint;             { final result }
	begin
	  { <unsigned constant> }
  
	  if sy = CONSTANT then 
	    begin  ret := const_val;  insymbol;  end
  
	  { ( <expression> ) }
  
	  else if sy = LPAREN then
	    begin
	      insymbol;
	      ret := expression(expr_kind);
	      if sy = RPAREN then insymbol else error(7 { expected ) });
	    end
  
	  { not <factor> }
  
	  else if sy = NOTSY then
	    begin  insymbol;  ret := ord(not (factor<>0));  end
  
	  { ABS ( <expression> ) }
  
	  else if sy = ABSSY then
	    begin
	      insymbol;  
	      if sy = LPAREN then insymbol else error(15 { expected ( });
	      ret := abs( expression(expr_kind) );
	      if sy = RPAREN then insymbol else error(7 { expected ) });
	    end
  
	  { ORD ( <expression> ) }
  
	  else if sy = ORDSY then
	    begin
	      insymbol;  
	      if sy = LPAREN then insymbol else error(15 { expected ( });
	      if expression(ALLOW_RELOPS) = 0 then ret := 0
					      else ret := 1;
	      if sy = RPAREN then insymbol else error(7 { expected ) });
	    end
  
	  { MIN ( <expression> , <expression> ... ) }
  
	  else if sy = MINSY then
	    begin
	      insymbol;
	      if sy = LPAREN then insymbol else error(15 { expected ( });
	      temp1 := expression(expr_kind);
	      repeat
		if sy = COMMA then insymbol else error(5 { expected , });
		temp2 := expression(expr_kind);
		if temp1 > temp2 then temp1 := temp2;
	      until (sy <> COMMA);
	      if sy = RPAREN then insymbol else error(7 { expected ) });
  
	      ret := temp1;
	    end
  
	  { MAX ( <expression> , <expression> ... ) }
  
	  else if sy = MAXSY then
	    begin
	      insymbol;
	      if sy = LPAREN then insymbol else error(15 { expected ( });
	      temp1 := expression(expr_kind);
	      repeat
		if sy = COMMA then insymbol else error(5 { expected , });
		temp2 := expression(expr_kind);
		if temp1 < temp2 then temp1 := temp2;
	      until (sy <> COMMA);
	      if sy = RPAREN then insymbol else error(7 { expected ) });
  
	      ret := temp1;
	    end
  
	  { error conditions }
  
	  else if sy = IDENT then
	    begin  
	      error(39 { undefined });  ret := 1;  
	    end
	  else if sy = ENDOFDATASY then
	    begin  error(57 { end of input! });  ret := 1;  end
	  else
	    begin  error(14 { error in factor });  ret := 1;  end;
  
	  factor := ret;
  
	  if debug then 
	    begin
	      disp_line('factor           ');
	      writeln(outfile, 'VALUE=', ret:1);
	    end;
	end { factor } ;
  
  
      begin { term } 
	val := factor;
  
	while sy IN mulops do
	  begin
	    sym := sy;  insymbol;  temp := factor;
	    case sym of
	      ASTERISK: if temp = 0 then val := 0
			else 
			  if abs(MAXINT DIV temp) < abs(val) then error(24)
			  else val := val * temp;                    
	      SLASH:    if temp = 0 then error(25 { divide by 0 })
			else val := val DIV temp;
	      MODSY:    if temp = 0 then error(25 { divide by 0 })
			else val := val MOD temp;
	    end;
	  end;
  
	term := val;
  
	if debug then
	  begin
	    disp_line('term             ');
	    writeln(outfile, 'VALUE=', val:1);
	  end;
      end { term } ;
  
  
    begin { simple_expression }
      if sy IN [PLUS,MINUS] then
	begin  negative := (sy = MINUS);  insymbol;  end
      else negative := FALSE;
  
      val := term;
  
      if negative then 
	if val <> -MAXINT-1 then val := -val else error(24 { ovf });
  
      while sy IN addops do
	begin
	  sym := sy;  insymbol;
	  case sym of
	    PLUS:  val := check_addition(val, term);
	    MINUS: val := check_subtraction(val, term);
	  end;
	end;
  
      simple_expression := val;
  
      if debug then
	begin
	  disp_line('simple_expression');
	  writeln(outfile, 'VALUE=', val:1);
	end;
    end { simple_expression } ;


    function relational_expression: longint;
      { parse a relational expression }
      var
        val: longint;    { value of the expression so far }
        sym: symbols;    { relational oeprator }
	str: xtring;     { value of first string_expression }
	comparison: compare_type;  { comparison of string expressions }


      { Would nest simple_expression and string_expression here, but
        this exceeds SVS PASCAL's nesting depth limitiations. }


    begin { relational_expression }
      if ((sy = IDENT) or (sy = STRINGS)) and (expr_kind = ALLOW_RELOPS) then
	  begin
	    str := string_expression;
	    if not (sy in relops) then
	      begin
		val := 0;
	        error(8 { Expected boolean operator });
	      end
	    else
	      begin
	        sym := sy;  insymbol;
		comparison := compare_strings(str, string_expression);
		case sym of
		  EQUAL:        val := ord(comparison = EQ);
		  NESY:         val := ord(comparison <> EQ);
		  LESSTHAN:     val := ord(comparison = LT);
		  LESY:         val := ord(comparison <> GT);
		  GREATERTHAN:  val := ord(comparison = GT);
		  GESY:         val := ord(comparison <> LT);
		end;
	      end;
	  end
      else
        begin
	  val := simple_expression;
    
	  if (expr_kind = ALLOW_RELOPS) and (sy IN relops) then
	    begin
	      sym := sy;  insymbol;
	      case sym of
		EQUAL:        val := ord(val =  simple_expression);
		NESY:         val := ord(val <> simple_expression);
		LESSTHAN:     val := ord(val <  simple_expression);
		LESY:         val := ord(val <= simple_expression);
		GREATERTHAN:  val := ord(val >  simple_expression);
		GESY:         val := ord(val >= simple_expression);
	      end;
	    end;
          end;
    
      relational_expression := val;

      if debug then
        begin
          disp_line('relational_expres');
          writeln(outfile, 'VALUE=', val:1);
        end;
    end { relational_expression } ;


  begin { boolean_expression }
    val := relational_expression;

    while (sy = ANDSY) do
      begin
        insymbol;
	tmp_val := relational_expression;
        val := ord((val <> 0) and (tmp_val <> 0));
      end;

    boolean_expression := val;

    if debug then
      begin
        disp_line('boolean_expressio');
        writeln(outfile, 'VALUE=', val:1);
      end;
  end { boolean_expression } ;


begin { expression }
  val := boolean_expression;

  while (sy = ORSY) or (sy = XORSY) do
    if sy = ORSY then
      begin
        insymbol;
        val := ord((val <> 0) or (boolean_expression <> 0));
      end
    else
      begin
        insymbol;
        if (boolean_expression <> 0) then val := ord(val = 0)
	                             else val := ord(val <> 0);
      end;

  expression := val;

  if debug then
    begin
      disp_line('expression       ');  writeln(outfile, 'VALUE=', val:1);
    end;

end { expression } ;


