  { bittap.p -- internal to evaluate_bindings }

  { WARNING -- this is really a hack.  The current implementaion of
    evaluate_bindings leaves no really good place to hook in and implement
    the cardinal bit tap.  The main problem is that it immediately replaces
    references to formal parameters, so that if the tapped bus is an
    interface signal, it does not exist in the structures resulting from
    evaluate_bindings.

    What we do is go back to the clear_text description of the actual(s)
    and parse it (them) all over again.  Then we examine this list of
    signal descriptors and extract all portions that apply to a unique
    named bus, being careful to preserve any inherit pin properties found.
    (If there is not one single unique named bus represented, then this is
    an error and we don't proceed).

    Next we check the extracted list of bus bits against the specified
    subrange to be tapped.  If it contains the appropriate bits, we fasion
    a signal descriptor that contains the tapped subrange with all of 
    the appropriate inherit pin properties.  In the majority of cases
    the attached bus will be a simple subrange or will contain no inherit-pin
    properties, in which case we can easily create a single-element
    descriptor for the tapped bus.  If we can't, then we create a bitwise
    descriptor so that we can get the appropriate properties on each bit.

    Note that inherit-pin properties are cumulative, so if a tapped bit
    appears more than once in the bus being tapped, then the properties
    on the tapped bit will be the union of all properties appearing on
    references to that bit in the bus.  Note also that we only care about
    inherit-pin properties, as inherit-signal properties are not cumulative,
    so they have already been appropriately handled.

    Lastly, we create a bogus clear_text_actual_list to represent the
    created signal_descriptor.  It is bogus as there is no clear text
    for the actual_parameter.  It is now effectively another net
    attached to the tap pin. We pass this to parse_the_actual along
    with the signal descriptor for the tapped bits.  Parse_the_actual
    has been hacked to use the passed descriptor as the parsed value
    for the actual parameter, thus bypassing its only reference to
    the clear-text actual, which we have not produced.  Parse_the_actual
    then takes care of any further processing that is needed, particularly
    if the tapped bus is an interface signal. 

    I strongly hope that this is the last enhancement I have to add to
    this code -- It's time to reimplement with a more friendly 
    signal/binding data structure. }


  procedure process_cardinal_tap(var tap: cardinal_tap_pin);
    { The pin to be tapped is in cardinal_tap.  The other pin is the
      bus pin.  If there is more than one other pin, the tap is ill-formed.
      NOTE: assume all bindings have already been resolved without error.
      (Nevertheless, we must re-parse the actual connected to the bus
      pin, as we need the original actual, not one that may have been
      obtained by hierarchical resolution of an interface signal.) }
    var
      bus_clear_text: bindings_list_ptr;
      bus: signal_descriptor_ptr;        { describes "parsed" tapped bus }
      assertion_control: control_type;   { If both tap pin and bus pin are
                                           NAC pins, then they cross-inherit,
					   otherwise their assertions
					   are independently processed -- so
					   the tapped bus is treated as
					   an IGNORE_ALL signal when synonymed
					   to the tapped pin's acutal. }
      save_debug_3: boolean;


    function find_bus_pin: bindings_list_ptr;
      { Return the bus pin being tapped }
      var
	pin, bus_pin: bindings_list_ptr;
	error_found: boolean;


      procedure error_dump_bus_pin(p: bindings_list_ptr);
      begin
	error_dump_indent(indent);
	error_dump_alpha('Bus pin:        ');
	error_dump_string(p^.formal_parameter);
	error_dump_CRLF;
      end { error_dump_bus_pin } ;


    begin  { find_bus_pin }
      pin := clear_text_bindings_list;  bus_pin := NIL;  error_found := FALSE;
      while (pin <> NIL) do
	begin
	  if pin <> tap.clear_text_binding then
	    if bus_pin = NIL then bus_pin := pin
	    else
	      begin
		if not error_found then
		  begin
		    error_found := TRUE;
		    error(69 { ill-formed tap });
		    error_dump_indent(indent);
		    error_dump_alpha('Only one bus pin');
		    error_dump_alpha(' allowed on card');
		    error_dump_alpha('inal tap body.  ');
		    error_dump_CRLF;
		    error_dump_bus_pin(bus_pin);
		  end;
		error_dump_bus_pin(pin);
	      end;
	  pin := pin^.next;
	end;
      if error_found then find_bus_pin := NIL
                     else find_bus_pin := bus_pin;
    end { find_bus_pin } ;


    function bus_uses_NAC: boolean;
      var
        formal: formal_actual_ptr;
    begin
      { NOTE: find_bus_pin does exhaustive check of cardinal tap and
        guarantees that there is exactly one bus pin and one tap pin.
	Assuming that this has been done, we know that the bindings
	also fit these criteria. }

      formal := formal_actual_list;
      while (formal <> NIL) and (formal = tap.binding) do
        formal := formal^.next;

      if (formal = NIL) then
        begin
	  assert(255 { bus binding not found });
	  bus_uses_NAC := FALSE;
        end
      else bus_uses_NAC := formal^.uses_NAC;
    end { bus_uses_NAC } ;


    function build_matching_bus(clear_text_binding: bindings_list_ptr;
				subs: subscript_ptr): signal_descriptor_ptr;
      { Build a signal descriptor describing all bits of the bus to be tapped,
	then from that build a descriptor describing the tapped subrange
	with all appropriate properties.  Return the latter. }
      var
	sig, next: signal_descriptor_ptr;
	clear_text: clear_text_actual_list_ptr;
	bus_SD: signal_descriptor_ptr;          { Available bus bits + props }
	tapped_SD: signal_descriptor_ptr;       { Resulting tapped bus }
	err: boolean;
  
  
      procedure report_bus_error(num: error_range);
	{ Report clear-text of bus pin and its actual(s) }
      var
	actual: clear_text_actual_list_ptr;
      begin
	err := TRUE;
	error(num);
	error_dump_current_parse_environment;
	error_dump_pin_name_string(clear_text_binding^.formal_parameter);
	actual := clear_text_binding^.actual_parameter;
	while actual <> NIL do
	  begin
	    error_dump_signal_name_string(actual^.actual_parameter);
	    actual := actual^.next;
	  end;
      end { report_bus_error } ;
  
  
      function add_to_bus_SD(desc: signal_descriptor_ptr; 
			     net_props: property_ptr): 
	signal_descriptor_ptr;
	{ Add (the individual record) to list describing the bits of the bus
	  and return the next element in the original list.  Fold in 
	  the inherit-pin properties attached to the graphical net. }
	var
	  name_props: property_ptr;
      begin
	add_to_bus_SD := desc^.next;
	desc^.next := bus_SD;
	bus_SD := desc;
  
	name_props := desc^.properties;
	desc^.properties := NIL;
	copy_inherit_pin_properties(desc^.properties, name_props);
	release_entire_property_list(name_props);
	copy_inherit_pin_properties(desc^.properties, net_props);
      end { add_to_bus_SD } ;
  
  
      function properties_of_bit(num: bit_range): property_ptr;
	{ return the properties of the bit from bus_SD -- if it is
	  there more than once, then accumulate all of them. }
	var
	  props: property_ptr;
	  sd: signal_descriptor_ptr;
	  ss: subscript_ptr;
	  i: natural_number;
  
  
	procedure add_props(list: property_ptr);
	  var
	    p: property_ptr;
	begin
	  while list <> NIL do
	    begin
	      new_property(p);
	      p^.name := list^.name;
	      p^.text := list^.text;
	      p^.next := props;
	      props := p;
	      list := list^.next;
	    end;
	end { add_props } ;
  
  
      begin  { properties_of_bit }
	props := NIL;
	sd := bus_SD;
	while sd <> NIL do
	  begin
	    if sd^.properties <> NIL then
	      begin
		ss := sd^.bit_subscript;
		while ss <> NIL do with ss^ do
		  begin
		    if left_index > right_index then
		      begin
			if (num <= left_index) and (num >= right_index) then
			  for i := 1 to sd^.replication_factor do
			    add_props(sd^.properties);
		      end
		    else
		      begin
			if (num >= left_index) and (num <= right_index) then
			  for i := 1 to sd^.replication_factor do
			    add_props(sd^.properties);
		      end;
		    ss := next;
		  end;
	      end;
	    sd := sd^.next;
	  end;
	properties_of_bit := props;
	if debug_14 then
	  begin
	    write(Outfile, 'properties_of_bit(', num:1, ') ->');
	    dump_property_list(Outfile, props);
	  end;
      end { properties_of_bit } ;
  
  
      function munge_bus_SD: signal_descriptor_ptr;
	{ create tapped SD by munging bus_SD.  It is known that all bits are
	  there and all necessary properties are represented in the 
	  first element. }
	var
	  sd: signal_descriptor_ptr;
  
  
	procedure duplicate_properties(props: property_ptr; 
				       num: natural_number);
	  { assume num > 1 and props <> NIL }
	  var
	    end_element: property_ptr;
	    i: natural_number;
	    copies: property_ptr;
	begin
	  copies := NIL;
	  for i := num - 1 downto 1 do copy_properties(copies, props);
	  end_element := end_of_property_list(props);
	  end_element^.next := copies;
	end { duplicate_properties } ;
  
  
      begin { munge_bus_SD }
	sd := bus_SD;
	bus_SD := bus_SD^.next;
	sd^.next := NIL;       
  
	release_entire_subscript(sd^.bit_subscript);
	sd^.bit_subscript := copy_subscript(subs);
	if (sd^.replication_factor > 1) and (sd^.properties <> NIL) then
	  duplicate_properties(sd^.properties, sd^.replication_factor);
	sd^.replication_factor := 1;
  
	munge_bus_SD := sd;
      end { munge_bus_SD } ;
  
  
      function tap_bitwise: signal_descriptor_ptr;
	{ create the tapped SD bitwise -- this is horribly slow, but should
	  only get executed in cases of concatenated signals with more than
	  one reference to the same bus (with different properties).  In
	  other words, we could have just disallowed this case entirely, but
	  that would have been un-SCALD-like. }
	var
	  i, num: bit_range;
	  sd, tapped_SD: signal_descriptor_ptr;
      begin
	if debug_3 then writeln(Outfile, 'Must tap BITWISE');
	if debug_3 then
	  begin
	    write(Outfile, 'bus_SD ');
	    dump_signal_descriptor(Outfile, bus_SD);
	  end;
	tapped_SD := NIL;
	for i := width_of_subscript_list(subs) downto 1 do
	  begin
	    num := i;
	    if nth_bit_subscript(num, subs) then ;
	    sd := NIL;
	    new_signal_descriptor(sd);
	    sd^ := bus_SD^;
	    with sd^ do
	      begin
		next := tapped_SD;
		tapped_SD := sd;
		properties := properties_of_bit(num);
		replication_factor := 1;
		bit_subscript := NIL;
		new_subscript(bit_subscript);
		bit_subscript^.left_index := num;
		bit_subscript^.right_index := num;
	      end;
	  end;
	tap_bitwise := tapped_SD;
      end { tap_bitwise } ;
  
  
      function bus_has_the_bits: boolean;
	{ return TRUE iff all of subs can be found in bus_SD }
	var
	  unfound: subscript_ptr;
	  merged_bus, merged_tap: subscript_ptr;
      begin { bus_has_the_bits }
	merged_tap := bit_set_from_subscript(subs);
	merged_bus := bit_set_from_descriptor(bus_SD);
        if debug_3 then
	  begin
	    write(Outfile, 'merged_tap=');
	    dump_bit_subscript(Outfile, merged_tap, VECTOR);
	    writeln(Outfile);
	    write(Outfile, 'merged_bus=');
	    dump_bit_subscript(Outfile, merged_bus, VECTOR);
	    writeln(Outfile);
	  end;

	unfound := bit_difference(merged_tap, merged_bus);
	if unfound = NIL then bus_has_the_bits := TRUE
	else
	  begin
	    bus_has_the_bits := FALSE;  err := TRUE;
	    report_bus_error(73 { unfound bit(s) });
	    error_dump_indent(indent);
	    error_dump_alpha('tapped bit list=');
	    error_dump_subscript(subs);
	    error_dump_CRLF;
	    error_dump_indent(indent);
	    error_dump_alpha('unfound bit(s)= ');
	    error_dump_subscript(unfound);
	    error_dump_CRLF;
  
	    release_entire_subscript(unfound);
	  end;

	release_entire_subscript(merged_bus);
	release_entire_subscript(merged_tap);
      end { bus_has_the_bits } ;
  
  
      function descriptor_has_properties(sd: signal_descriptor_ptr): boolean;
	var
	  props: property_ptr;
      begin
	props := NIL;
	while (sd <> NIL) and (props = NIL) do
	  begin
	    props := sd^.properties;
	    sd := sd^.next;
	  end;
	descriptor_has_properties := props <> NIL;
      end { descriptor_has_properties } ;
  
  
    begin { build_matching_bus }
      tapped_SD := NIL;
      bus_SD := NIL;
      err := FALSE;
      clear_text := clear_text_binding^.actual_parameter;
      while (clear_text <> NIL) and not err do
	begin
	  sig := parse_signal_name(clear_text^.actual_parameter, FALSE);
	  while (sig <> NIL) and not err do
	    begin
	      if (sig^.kind = VECTOR) and 
		 not is_unnamed_signal(sig^.signal_name) then
		begin
		  if (bus_SD = NIL) then sig := 
		      add_to_bus_SD(sig, clear_text^.properties)
		  else 
		    if (sig^.signal_name <> bus_SD^.signal_name) or
		       (sig^.polarity <> bus_SD^.polarity) then
			 report_bus_error(74 { multiple bus }) { err now TRUE }
		    else sig := add_to_bus_SD(sig, clear_text^.properties);
		end
	      else 
		begin
		  next := sig^.next;
		  sig^.next := NIL;
		  release_complete_signal_descriptor(sig);
		  sig := next;
		end;
	    end;
	  if sig <> NIL then release_complete_SD_list(sig); { in case of error }
	  clear_text := clear_text^.next;
	end;
  
      if not err then
	if bus_SD = NIL then report_bus_error(75 { no bus })
	else
	  begin
	    if debug_3 then
	      begin
		write(Outfile, 'bus_SD ');
		dump_signal_descriptor(Outfile, bus_SD);
	      end;
	    if bus_has_the_bits then
	      if (bus_SD^.next = NIL) and 
	         (bus_SD^.bit_subscript^.next = NIL) then
		tapped_SD := munge_bus_SD
	      else if not descriptor_has_properties(bus_SD) then
		tapped_SD := munge_bus_SD
	      else tapped_SD := tap_bitwise;
	  end;
  
      release_complete_SD_list(bus_SD);
      build_matching_bus := tapped_SD;
    end { build_matching_bus } ;


  begin { process_cardinal_tap }
    if debug_14 { inherit_pin properties } then
      begin
        save_debug_3 := debug_3;
	debug_3 := TRUE;  { all of this stuff reports to debug_3 }
      end;
    if debug_3 then
      begin
        write(Outfile, 'process_cardinal_tap(');
	dump_bit_subscript(Outfile, tap.tap, VECTOR);
	writeln(Outfile, ')');
	write(Outfile, 'tap binding: ');
	dump_formal_actual(Outfile, tap.binding);
      end;
    bus_clear_text := find_bus_pin;
    if debug_3 then
      begin
	write(Outfile, 'bus_clear_text ');
	dump_clear_text_binding(Outfile, bus_clear_text);
      end;
    if bus_clear_text <> NIL then 
      begin
	bus := build_matching_bus(bus_clear_text, tap.tap);
	if bus <> NIL then with tap.clear_text_binding^ do
	  begin
	    new_clear_text_actual_list(tap.clear_text_binding^.
	                               actual_parameter);
	    tap.clear_text_binding^.actual_parameter^.net_id :=
	      generate_unique_net_ID;

            if tap.binding^.uses_NAC and bus_uses_NAC then
	      assertion_control := NORMAL_SIGNAL
	    else assertion_control := IGNORE_ALL;

	    new_actual_list(tap.binding^.actual_parameter);
	    parse_the_actual(tap.binding,
			     tap.clear_text_binding^.actual_parameter,
			     bus, assertion_control);
	    { bus has now been released }
	    if check_and_fix_formal_actual(tap.binding, 
	                                   FALSE, dummy) then;

	  end;
      end;
    if debug_14 then debug_3 := save_debug_3;
  end { process_cardinal_tap } ;
