

procedure parse_string(string_to_parse: xtring; way_to_parse: parse_type);
  { push the given string onto the parse stack }
begin

  if (stack_top >= MAX_STACK) or (parse_stack_pointer >= MAX_STACK) then
    error(137 { text macro depth exceeded })
  else
    begin
      if parse_stack_pointer > stack_top then
        stack_top := parse_stack_pointer;

      { save state of current environment }
	    
      with stack[parse_stack_pointer] do
        begin
          str      := instring;
          last_pos := last_sym_pos;
          pos      := line_pos;
          state    := read_state;
          last     := last_char;
          symbol   := sy;
          constant := const_val;
          how      := how_to_parse;
          keys     := allowed_key_words;
        end;

      parse_stack_pointer := stack_top + 1;

      instring     := string_to_parse;
      line_pos     := 0;
      last_sym_pos := 0;
      how_to_parse := way_to_parse;
      read_state   := finput;

      allowed_key_words := signal_keysys;


      insymbol;
    end;
end { push_string_to_parse } ;


procedure pop_parsed_string(string_to_pop: xtring);
  var
    done: boolean;       { TRUE when proper string popped }
begin


  if parse_stack_pointer > 0 then stack_top := parse_stack_pointer - 1
  else stack_top := 0;

  if stack_top = 0 then error( 187 { assertion })
  else
    begin
      repeat
        done := (instring = string_to_pop);
        with stack[stack_top] do
          begin
            sy := symbol;  
	    const_val := constant;
            instring           := str;
            last_sym_pos       := last_pos;
            line_pos           := pos;
            read_state         := state;
            last_char          := last;
            allowed_key_words  := keys;


            how_to_parse := how;
          end;

        stack_top := stack_top - 1;
      until done or (stack_top <= 0);
      
      if not done then error( 187 { assertion });
    end;

  parse_stack_pointer := stack_top + 1;

end { pop_parsed_string } ;

procedure skip(syms: setofsymbols);
  { used to try to gracefully recover from errors }
begin
  while not (sy IN syms+[ENDOFDATASY]) do insymbol;
end { skip } ;


{ -------- file handling routines   --------- }



function rewrite_file(var f: textfile; file_name: alpha): boolean;
  { rewrite a file of the given name.  Return FALSE if not successful }
  var
    val: boolean;        { return value }
    code: longint;       { system return code }
begin
  val := vopen(f, file_name, nullstring, WRITE_MODE, code);

  if not val then
    if file_name = MONITOR_FILE_NAME then
      begin
#if SVS
        writeln(stderr, 'compiler: unable to open MONITOR (fatal)'); 
	write_ioresult(stderr, to_ioresult(code)); 
        halt_with_status(FATAL_COMPLETION); 
#endif
        writeln(output, 'compiler: unable to open MONITOR (fatal)');
	write_ioresult(output, to_ioresult(code));
        halt_with_status(FATAL_COMPLETION);
      end
    else
      begin
        error(169 { cannot open this file });
        error_dump_alpha_file_name(file_name);
	error_dump_ioresult(to_ioresult(code));
      end;
 
  rewrite_file := val;

end { rewrite_file } ;


function reset_file(filename: xtring; which: parse_file_type): boolean;
  { reset a file of the given name.  If the name is NULL, open nameless.  If
    no file can be opened, return FALSE.  WHICH specifies which logical 
    file is to be opened. }
  var
    logical: alpha;                     { for passing logical name }
    val: boolean;                       { return value }
    code: longint;                      { system dependent code }
begin
  if current_file <> UNKNOWN_FILE then
    begin
      val := FALSE;
      error(187 { assertion check failure });
    end
  else
    begin
      case which of
        DIRECTIVES_FILE:
          begin
            logical := 'INFILE          ';
            val := vopen(infile, logical, filename, READ_MODE, code);
          end;

        STANDARD_FILE:
          begin
            logical := 'CMPSTAN         ';
            val := vopen(CmpStan, logical, filename, READ_MODE, code);
          end;

        OTHERWISE
          begin
            val := FALSE;
            error(187 { assertion failure });
          end;
      end { case } ;
    end;
  if val then current_file := which;
  reset_file := val;
end { reset_file } ;


function open_a_file(file_name: xtring; which: parse_file_type): boolean;
  { open the specified file for read and parse the first token from it.
    If the FILE_NAME is not empty (NULLSTRING), open the file named.  If
    it is empty, open the file as specified in the file equation. }
  var
    ok: boolean;         { TRUE iff file open successful }
begin
  ok := reset_file(file_name, which);

  if ok then  
    begin
      read_state := FINIT;
      insymbol;
    end;
  open_a_file := ok;
end { open_a_file } ;


function get_file_type: file_types;
  { check to see that the current file has correct type and return type }
  var
    this_file: file_types;      { type of this file }
    found: boolean;             { TRUE if file type found in table }


begin { get_file_type }
  this_file := FIRST_FILE_TYPE;
  if sy <> FILETYPESY then error(85 { expected FILE_TYPE })
  else
    begin
      insymbol;
      if sy = EQUAL then insymbol else error(2 { expected = });
      if sy <> IDENT then error(1 { expected ident })
      else
        begin
          this_file := succ(FIRST_FILE_TYPE);  found := FALSE;
          while (this_file < LAST_FILE_TYPE) and not found do
            if file_type_list[this_file] = id.name then found := TRUE
            else this_file := succ(this_file);

          if not found then this_file := FIRST_FILE_TYPE;
          insymbol;
          if sy = SEMI then insymbol else error( 187 { assertion });
        end;
    end;

  get_file_type := this_file;
end { get_file_type } ;


procedure new_file_list(var list: file_list_ptr);
  { create a new element and add to the head of the list }
  var
    FLP: file_list_ptr;     { new element created for the list }
begin
  new(FLP);

  FLP^.next := list;  list := FLP;
  FLP^.file_name := nullstring;
end { new_file_list } ;


procedure close_file(var f: textfile; file_name: alpha);
  { close the given file }
begin
  if not vclose(f) then
    begin
      error(168 { cannot close specified file });
      error_dump_alpha_file_name(file_name);
    end;
end { close_file } ;


function close_parse_file(which: parse_file_type): boolean;
  { close the input file }
  var
    val: boolean;      { success? }
begin
  val := FALSE;
  if current_file <> which then error(187 { assertion failure })
  else
    case which of
      DIRECTIVES_FILE: val := vclose(infile);
      STANDARD_FILE: val := vclose(CmpStan);
      OTHERWISE
        begin
	  error(187 {assertion} );
        end;
    end { case } ;
  current_file := UNKNOWN_FILE;
  close_parse_file := val;
end { close_parse_file } ;

