
(**)     { ------- lexical analyzer ------- }


procedure insymbol;
  { parse the next token from the input string }
  type
    line_read_type = (NORMAL, CONTINUATION);

  var
    ch,                             { last character read in }
    next: char;                     { the next character in the input stream }
    looking_for_string,             { TRUE if reading in a string }
    done: boolean;                  { TRUE when symbol has been parsed }
    upper_case_on_input: boolean;   { TRUE if upper casing of all characters }
#ifndef SUBROUTINE
    need_a_char: boolean;           { used during get_char to flag whether
                                      or not we still need a character }
#endif SUBROUTINE


  procedure copy_to_buffer(ch: char);
    { copy the character to a global buffer }
  begin
    if (copy_pos < MAX_STRING_LENGTH) and (ch >= ' ') and not copy_error then
      begin
        copy_pos := copy_pos + 1;  copy_buffer[copy_pos] := ch;
      end
    else if not copy_error and (ch >= ' ') then
      begin
        error(116 { too big });  copy_error := TRUE;
      end;
  end { copy_to_buffer } ;


  function get_line(which: line_read_type): boolean;
    { read the next line from the input file.  Return TRUE if a string
      was popped from the stack instead of reading in another line.
      If a string was popped, the state of the lexical analyzer was
      restored from stack.  Otherwise, the character returned is space.
      Don't read in a new line if currently reading a string. }
    var
      i: string_range;            { index into the input line }
   

    procedure unexecuted_read(var f: textfile);        {UNIX}
  { procedure read_a_line(var f: inputfile);         }(*VAX*)
  { procedure read_a_line(var f: inputfile);         }(*370*)
  { procedure read_a_line(var f: inputfile);       }(*ELXSI*)
      { read a line from the specified input file }
      var
        i: string_range;      { index into the parse string }
    begin
      while eoln(f) and not eof(f) do 
        begin
	  readln(f);
          input_line_number := input_line_number + 1;
	end;

      i := 0;
      while not eoln(f) and not eof(f) do
        begin
          read(f, ch);  
          if i < MAX_STRING_LENGTH then
            begin  i := i + 1;  instring^[i] := ch;  end
          else
            begin
              instring^[0] := chr(MAX_STRING_LENGTH);
              error(53 { input line length exceeded });
              while not eof(f) and not eoln(f) do get(f);
            end;
        end;
      if eof(f) then ch := chr(EOL) else ch := ' ';
      instring^[0] := chr(i);  
    end { read_a_line } ;


    procedure read_a_line(var f: inputfile);            {UNIX}
{   procedure unexecuted_read(var f: inputfile);       }(*VAX*)
{   procedure unexecuted_read(var f: inputfile);       }(*370*)
{   procedure unexecuted_read(var f: inputfile);     }(*ELXSI*)
      { read a line from the specified input file }
      const                         {UNIX}
        END_OF_FILE = 2;            {UNIX}
        OVERFLOW_ERR = 1;           {UNIX}
        SUCCESS = 0;                {UNIX}
      var
        result: 0..2;  { SUCCESS,OVERFLOW,END_OF_FILE returns from C }
    begin
    { ch := chr(EOL);                                        }(*VAX*)
    { ch := chr(EOL);                                        }(*370*)
    { ch := chr(EOL);                                      }(*ELXSI*)
      repeat                                                   {UNIX}
        result := creadln(f, instring);                        {UNIX}
        input_line_number := input_line_number + 1;            {UNIX}
      until (result = END_OF_FILE) or (ord(instring^[0]) > 0); {UNIX}
      case result of                                           {UNIX}
        END_OF_FILE: ch := chr(EOL);                           {UNIX}
        OVERFLOW_ERR:                                          {UNIX}
          begin                                                {UNIX}
            error(53 { line too long });                       {UNIX}
            ch := ' ';                                         {UNIX}
          end;                                                 {UNIX}
        SUCCESS: ch := ' ';                                    {UNIX}
      end;                                                     {UNIX}
    end { read_a_line } ;


  begin { get_line }
    get_line := FALSE;

    if looking_for_string and (which = NORMAL) then
      ch := chr(EOL)

    else
      begin
        case current_file of
          STANDARD_FILE:    read_a_line(CmpStan);
          otherwise:     assert(173 { no file has been opened });
        end;
        line_pos := 0;  read_state := FINPUT;
      end;

    if debug then
      begin 
        dump_string(outfile, instring);
        writeln(outfile);
      end;
  end { get_line } ;


#define get_char_insymbol(ch) ##\
  begin##\
    repeat##\
      if read_state = FGOT_CHAR then##\
        begin  ch := last_char;  need_a_char := FALSE;  end##\
      else##\
        if (read_state = FINIT) or (line_pos >= ord(instring^[0])) then ##\
          need_a_char := get_line(NORMAL)##\
        else##\
          begin##\
            line_pos := line_pos + 1;##\
            ch := instring^[line_pos];##\
            if (ch = CONTINUATION_CHAR) and (line_pos = ord(instring^[0])) then##\
              begin##\
                need_a_char := get_line(CONTINUATION);##\
                need_a_char := TRUE;##\
              end##\
            else##\
              begin##\
                if ch = chr(TAB_char) then ch := ' '##\
                else if not (ch IN legal_chars) then##\
                  begin##\
                    error(32);  ch := ' ';##\
                  end##\
                else if (ch IN lower_case) and upper_case_on_input then##\
                  ch := chr(ord(ch) - ord('a') + ord('A'));##\
                need_a_char := FALSE;##\
              end;##\
          end;##\
    until not need_a_char;##\
    read_state := FINPUT;##\
    last_char := ch;##\
  end

#ifdef SUBROUTINE
  procedure get_char(var ch: char);
    { read the next char from the input buffer } 
    var
      need_a_char: boolean; {  whether or not we still need a character } get_char_insymbol(ch) { get_char } ;
#else
#define get_char get_char_insymbol
#endif SUBROUTINE
        

{ NOTE:  the following macro must NOT be called on a local ch, as it
  must change the global ch }
#define nextchar_insymbol(next) ##\
  begin##\
    get_char(ch);  next := ch;##\
    if ch <> chr(EOL) then read_state := FGOT_CHAR;##\
  end


#ifdef SUBROUTINE
  procedure nextchar(var next_ch: char);
    { get the next char. Set a flag indicating that the next char was read } nextchar_insymbol(next_ch) { nextchar } ;
#else
#define nextchar nextchar_insymbol
#endif SUBROUTINE
        

(**)     { ------- scan for an identifier ------- }


  procedure get_identifier;
    { read in an identifier }
    var
      i: 0..ID_LENGTH;            { index into the identifier }
      temp: alpha;                { identifier being parsed }
      id_error: boolean;          { TRUE iff id too long }
  begin
    temp := NULL_ALPHA;  id.name := NIL;

    i := 0;  sy := IDENT;  id_error := FALSE;
    repeat
      if i >= ID_LENGTH then
        begin
          error(41 { identifier length exceeded });
          id_error := TRUE;
          while (ch IN identifier_chars) do get_char(ch);
        end
      else
        begin  
          i := i + 1;  temp[i] := ch;  get_char(ch);
        end;
    until not (ch IN identifier_chars);

    if ch <> chr(EOL) then read_state := FGOT_CHAR;
    
    if not id_error then
      begin
        id.name := enter_name(temp);

        { check for a key word if not just copying input }

        
        if (KEY_WORD IN id.name^.kind) then
          if id.name^.sy IN allowed_key_words then sy := id.name^.sy;
      end;

    if debug then disp_line('identifier       ');
  end { get_identifier } ;

    
(**)     { ------- scan for constant ------- }


  procedure get_constant;
    { read in one of three different constant types }
    var
      new_radix: natural_number;     { radix specified in constant }


    procedure skip_to_end_of_constant(number_radix: radix_range);
      { skip to the end of the constant;  error recovery }
    begin
      while ch in valid_chars[number_radix] do get_char(ch);
    end { skip_to_end_of_constant } ;


    function build_number(radix: radix_range): natural_number;
      { build a number with the specified radix }
      var
        temp: natural_number;      { value of the function to be returned }
        next_digit: 0..MAX_RADIX;  { numeric value of current digit }
    begin
      temp := 0;  const_width := 0;
      repeat
        const_width := const_width + 1;
        if ch <= '9' then  next_digit := ord(ch) - ord('0')
                     else  next_digit := ord(ch) - ord('A') + 10;

        if (temp > MAXINT DIV radix) or 
           ((temp = MAXINT DIV radix) and
            (next_digit > MAXINT MOD radix)) then
          begin  
            error(24 { ovf });
            skip_to_end_of_constant(radix);
          end
        else
          begin  temp := radix * temp + next_digit;  get_char(ch);  end;
      until not (ch IN valid_chars[radix]);

      const_width := const_width * radix_width[radix];

      build_number := temp;
    end { build_number } ;


  begin { get_constant }
    sy := CONSTANT;
    const_val := build_number(10);

    if parse_SCALDconstants then
      if ch in letters then
        begin
          repeat
            get_char(ch);
          until not (ch in letters);
        end

      else
        begin
          if ch = '#' then
            begin
              new_radix := const_val;
              if (new_radix < min_radix) or (new_radix > max_radix) then
                begin  error(61 { out of range });  new_radix := 10;  end;

              get_char(ch);
              const_val := build_number(new_radix);

              sy := SIGNALCONST;
            end;

          if ch = '(' then    { width specification }
            begin
              get_char(ch);
              const_width := build_number(10);

              if (const_width <= 0) or (const_width > max_bit_value) then
                begin  error(44 { invalid width });  const_width := 1;  end;

              if ch = ')' then get_char(ch) else error(7 { expected ) });

              sy := SIGNALCONST;
            end;
        end;

    read_state := FGOT_CHAR;

    if debug then disp_line('constant         ');
  end { get_constant } ;


(**)     { ------- scan for string ------- }


  procedure get_string(stopper: char);
    { read a string }
    var
      len: string_range;   { length of the string read in }
      done: boolean;       { TRUE when end of the string has been found }
      nch: char;           { next charactar }
  begin
    len := 0;  done := FALSE;  looking_for_string := TRUE;
    if not upper_case_strings then upper_case_on_input := FALSE;        {UNIX}
    repeat
      get_char(ch);
      if ch = stopper then
        begin
	  nextchar(nch);
          if nch = stopper then get_char(ch) else done := TRUE;
	end;

      if (ch = chr(EOL)) and not done then
        begin  error(89 { string not closed });  done := TRUE;  end;

      if not done then
        if len >= MAX_STRING_LENGTH then
          begin error(22 { string length exceeded });
            while (ch <> stopper) and (ch <> chr(EOL)) do get_char(ch);
          end
        else
          begin len := len + 1;  input_buffer^[len] := ch;  end;
    until done;

    input_buffer^[0] := chr(len);
    sy := STRINGS;
    looking_for_string := FALSE;
    upper_case_on_input := TRUE;

    lex_string := enter_string(input_buffer);

    if debug then disp_line('string           ');
  end { get_string } ;


(**)     { ------- main lexical analyzer ------- }


begin { insymbol }
  looking_for_string := FALSE;
  upper_case_on_input := TRUE;
  copy_pos := current_pos;

  if read_state = finput then last_sym_pos := line_pos
  else
    if line_pos >= 1 then last_sym_pos := line_pos-1
                     else last_sym_pos := 1;

  repeat
    done := TRUE;
    get_char(ch);
    while ch = ' ' do get_char(ch);  current_pos := copy_pos;

    if ch = chr(EOL) then sy := ENDOFDATASY
    else
      case ch of
        '!':  sy := EXCLAMATION;
        '"':  get_string(ch);
        '#':  sy := SHARP;
        '$':  sy := DOLLAR;
        '%':  sy := PERCENT;
        '&':  sy := AMPERSAND;
       '''':  get_string(ch);
        '(':  sy := LPAREN;
        ')':  sy := RPAREN;
        '*':  sy := ASTERISK;
        '+':  sy := PLUS;
        ',':  sy := COMMA;
        '-':  sy := MINUS;
        '.':  begin
	        nextchar(next);
	        if next = '.' then sy := DOTDOTSY else sy := PERIOD;
	      end;
        '/':  sy := SLASH;
        '0','1','2','3','4','5','6','7','8','9':  get_constant;
        ':':  begin
	        nextchar(next);
	        if next = ':' then sy := COLONCOLONSY else sy := COLON;
	      end;
        ';':  sy := SEMI;
        '<':  begin
                nextchar(next);
                if next = '=' then sy := LESY
                else if next = '>' then sy := NESY
                else sy := LESSTHAN;
              end;
        '=':  sy := EQUAL;
        '>':  begin
                nextchar(next);
                if next = '=' then sy := GESY
                else sy := GREATERTHAN;
              end;
        '?':  sy := QUESTION;
{       '@':  sy := ATSY;      this symbol is not used: @=^ in EBCDIC! }
        'A','B','C','D','E','F','G','H','I','J','K','L','M','N',
        'O','P','Q','R','S','T','U','V','W','X','Y','Z':  get_identifier;
        '[':  sy := LBRACKET;
{       '\':  sy := BACKSLASH;                                        }(*VAX*)
{       '\':  sy := BACKSLASH;                                        }(*370*)
{       '\':  sy := BACKSLASH;                                        }(*SUN*)
        '\\': sy := BACKSLASH;                                           {SVS}
        ']':  sy := RBRACKET;
        '^':  sy := CIRCUMFLEX;
        '_':  sy := UNDERBAR;
        '`':  sy := ACCENTGRAVE;
        '{':  begin
                repeat
                  get_char(ch)
                until (ch='}')  or (ch=chr(EOL));

                if ch = chr(EOL) then error(34 { comment not closed });
                done := FALSE;
              end;
        '|':  sy := VERTICALBAR;
        '}':  begin  error(20 { unmatched symbol });  done := FALSE;  end;
        '~':  sy := TILDA;
        otherwise:
	  begin
              error(23 { illegal character in input });
	      error_dump_alpha('Character       ');
	      error_dump_integer(ord(ch));
	      error_dump_CRLF;
	  end;
      end;
  until done;

  if sy IN [COLONCOLONSY,DOTDOTSY,LESY,GESY,NESY] then read_state := FINPUT;

{ if debug then writeln(outfile, 'insymbol: ', sy);                   }(*VAX*)
{ if debug then writeln(outfile, 'insymbol: ', ord(sy));              }(*370*)
  if debug then writeln(outfile, 'insymbol: ', ord(sy));                {UNIX}
{ if debug then writeln(outfile, 'insymbol: ', ord(sy));            }(*ELXSI*)
end { insymbol } ;



procedure skip(symbols: setofsymbols);
begin
  symbols := symbols + [ENDSY,ENDOFDATASY];
  while not (sy in symbols) do insymbol;
end { skip } ;
