
(**)    { ------- initialization routines ------- }


procedure init;
  { initialize global (and some local) 'constants' and vars }
  

  procedure init_directives;
  begin
    check_properties := TRUE;
  end { init_directives } ;


  procedure init_built_in_identifier_names;
  begin
    REP_prop_name            := enter_name('REP             ');
    PATH_NAME_prop_name      := enter_name('PATH_NAME       ');
  end { init_built_in_identifier_names } ;

  
  procedure init_keywords;
    { init macro keywords }
    var
      id: alpha;              { key word to be added }
      sy: symbols;            { corresponding symbol for the key word }
    

    procedure add_keyword;
      { add the key word to the name table and set its value }
      var
        name: name_ptr;       { name to be added to the name table }
    begin
      name := enter_name(id);
      if KEY_WORD in name^.kind then assert(159 { name already there })
      else
        begin  name^.kind := name^.kind + [KEY_WORD];  name^.sy := sy;  end;
    end { add_keyword } ;
      

  begin { init_keywords }
    id := 'END             ';  sy := ENDSY;          add_keyword;
    id := 'PRIMITIVE       ';  sy := PRIMITIVESY;    add_keyword;
    id := 'END_PRIMITIVE   ';  sy := ENDPRIMITIVESY; add_keyword;
    id := 'PIN             ';  sy := PINSY;          add_keyword;
    id := 'END_PIN         ';  sy := ENDPINSY;       add_keyword;
    id := 'BODY            ';  sy := BODYSY;         add_keyword;
    id := 'END_BODY        ';  sy := ENDBODYSY;      add_keyword;
    id := 'BINDINGS        ';  sy := BINDINGSY;      add_keyword;
    id := 'END_BINDINGS    ';  sy := ENDBINDINGSY;   add_keyword;
    id := 'SIGNALS         ';  sy := SIGNALSY;       add_keyword;
    id := 'END_SIGNALS     ';  sy := ENDSIGNALSY;    add_keyword;
    id := 'FILE_TYPE       ';  sy := FILETYPESY;     add_keyword;
  end { init_keywords } ;
      

  procedure init_assertions;
    { init the assertion messages }
  begin
    assert_strings[0]   := 'Unimplemented assertion message         ';
    assert_strings[1]   := 'Reassignment of path element forbidden  ';
    assert_strings[2]   := 'Null path element found in add_path_elem';
    assert_strings[3]   := 'Path length exceeded in add_path_element';
    assert_strings[4]   := 'NULL string passed to evaluate_string   ';
    assert_strings[5]   := 'Tried to fix instance of non_UNDEFINED  ';
    assert_strings[6]   := 'Non vector signal has non-NIL subscript ';
    assert_strings[7]   := 'String pointers not at end in insert_quo';
    assert_strings[8]   := 'Parse stack underflow                   ';
    assert_strings[9]   := 'Expected a constant describing the net  ';
    assert_strings[10]  := 'Expected ,                              ';
    assert_strings[11]  := 'Body properties are not permitted here  ';
    assert_strings[12]  := 'Expected END_BODY symbol                ';
    assert_strings[13]  := 'Pin properties are not permitted here   ';
    assert_strings[14]  := 'Expected pin name string                ';
    assert_strings[15]  := 'Expected END_PIN symbol                 ';
    assert_strings[16]  := 'Expected END_PARAMETER                  ';
    assert_strings[17]  := 'Expected identifier = EXPR, not this    ';
    assert_strings[18]  := 'Expected a string                       ';
    assert_strings[19]  := 'Expected a constant                     ';
    assert_strings[20]  := 'Unexpected symbol in property body      ';
    assert_strings[21]  := 'Expected END_PROPERTY symbol            ';
    assert_strings[22]  := 'Expected BINDINGS                       ';
    assert_strings[23]  := 'Expected formal parameter name string   ';
    assert_strings[24]  := 'Expected actual parameter name string   ';
    assert_strings[25]  := 'Expected END_BINDINGS                   ';
    assert_strings[26]  := 'Expected macro name                     ';
    assert_strings[27]  := 'Expected END_INVOKE                     ';
    assert_strings[28]  := 'Expected MACRO                          ';
    assert_strings[29]  := 'Unexpected symbol in macro definition   ';
    assert_strings[30]  := 'Expected END_MACRO                      ';
    assert_strings[31]  := 'Illegal width in convert_into_binary    ';
    assert_strings[32]  := 'Expected signal name string             ';
    assert_strings[33]  := 'X is already in the symbol table        ';
    assert_strings[34]  := 'Expected END                            ';
    assert_strings[35]  := 'Expected ;                              ';
    assert_strings[36]  := 'Parameter not found in table: expansion ';
    assert_strings[37]  := 'PATH property not found for invocation  ';
    assert_strings[38]  := 'Undefined formal CSP not found in list  ';
    assert_strings[39]  := 'Created abbreviation not valid          ';
    assert_strings[40]  := 'New synonym lst width incompatible w/old';
    assert_strings[41]  := 'Formal/actual list not NIL to evaluate  ';
    assert_strings[42]  := 'Illegal width to resolve undefined inst ';
    assert_strings[43]  := 'Parameter is not a text macro!          ';
    assert_strings[44]  := 'Expected .                              ';
    assert_strings[45]  := 'Left and right margins invalid          ';
    assert_strings[46]  := 'Path string has no room!  What happened?';
    assert_strings[47]  := 'Parameter is not a text macro!          ';
    assert_strings[48]  := 'Parameter not found in table: P1 status ';
    assert_strings[49]  := 'Expected property value string          ';
    assert_strings[50]  := 'No appending bit in middle of sub list  '; 
    assert_strings[51]  := 'NIL args to copy subscript element      '; 
    assert_strings[52]  := 'Non-NIL args to copy subscript          '; 
    assert_strings[53]  := 'NIL subscript passed to bit in range    '; 
    assert_strings[54]  := 'NIL sig desc passed to width of sig desc'; 
    assert_strings[55]  := 'NIL sig inst passed to size of sig inst '; 
    assert_strings[56]  := 'NIL sig inst passed to width of sig inst'; 
    assert_strings[57]  := 'NIL subscript passed to find subscript  '; 
    assert_strings[58]  := 'Too small ordinal into nth_bit_subscript'; 
    assert_strings[59]  := 'Too big ordinal into nth_bit_subscript  '; 
    assert_strings[60]  := 'NIL CS passed to find_bit_in_CS         '; 
    assert_strings[61]  := 'Too big ordinal passed to find_bit_in_CS'; 
    assert_strings[62]  := 'Bad sub to resolve_instance_of_parameter'; 
    assert_strings[63]  := 'Non-empty sub to resolve_instance_of_par'; 
    assert_strings[64]  := '<BAD> basescript to find_basescript     ';
    assert_strings[65]  := 'NIL SD or sig_def passed add_SD_onto_PCS';
    assert_strings[66]  := 'Too small ordinal into leading_n_bits...'; 
    assert_strings[67]  := 'Too big ordinal into leading_n_bits_o...'; 
    assert_strings[68]  := 'Invalid arguments into create_synonym   '; 
    assert_strings[69]  := 'NIL sig def passed to width_of_sig_def  '; 
    assert_strings[70]  := 'Non-NIL destination ptr in copy_property'; 
    assert_strings[71]  := 'NIL formal passed to resolve_instance_of';
    assert_strings[72]  := 'NIL CSL to find youngest mtree node     '; 
    assert_strings[73]  := 'NIL sig inst to synonym_signal_instances';
    assert_strings[74]  := 'NIL arg passed to new_SD_for_create_syno'; 
    assert_strings[75]  := 'Arg with undef width to create_synonyms '; 
    assert_strings[76]  := 'Bad first argument passed to map_bit    '; 
    assert_strings[77]  := 'Bad second argument passed to map_bit   '; 
    assert_strings[78]  := 'Processed def into find_base_of_signal1 ';
    assert_strings[79]  := 'Bad bit subscript in find_base_of_signal';
    assert_strings[80]  := 'Bad rep_factor passed to replicate_CS   ';
    assert_strings[81]  := 'NIL sig inst into find_base_of_sig_insta';
    assert_strings[82]  := 'Real bad sub into find_base_of_sig_insta';
    assert_strings[83]  := 'Bad sub into find_base_of_signal_instanc';
    assert_strings[84]  := 'Incompatible widths in is_same_constant ';
    assert_strings[85]  := 'Subscript already > width in insert_subs';
    assert_strings[86]  := 'Undefined width SD in augment_sig_descri';
    assert_strings[87]  := 'Undefined width SD in augment_sig_descri';
    assert_strings[88]  := 'Fix_no_width_signal failed to converge  ';
    assert_strings[89]  := 'Inconsistent width assign in insert_sub1';
    assert_strings[90]  := 'Incorrect sub on def & desc in quick_res';
    assert_strings[91]  := 'Sig def is undef and desc is VEC or UND ';
    assert_strings[92]  := 'Out of range sub in synonym_1st_BD_to...';
    assert_strings[93]  := 'Convergence failure in fix_no_width_sig1';
    assert_strings[94]  := 'Ref of a bit of formal with undef. width';
    assert_strings[95]  := 'SI with undef width in insert_subscript1';
    assert_strings[96]  := 'No bit lists to insert_subscript1       ';
    assert_strings[97]  := 'Horrible error in synonym bag list      ';
    assert_strings[98]  := 'Width of CS <> width of synonyn element ';
    assert_strings[99]  := 'Out of range sub in get_next_base_bit   ';
    assert_strings[100] := '1 bit lookup find_base_of_base_desc fail';
    assert_strings[101] := 'Out of range offset in subrange_occurs_i';
    assert_strings[102] := 'NIL base descriptro to find_base_of_base';
    assert_strings[103] := 'Bogus bit number in find_base_of_base_of';
    assert_strings[104] := 'Inst with undef width in find_base_of_ba';
    assert_strings[105] := 'Bogus bit number in find_base_of_base_of';
    assert_strings[106] := 'Quick_synonym failed on 1 bit wide args ';
    assert_strings[107] := 'Net number not found in the net table   ';
    assert_strings[108] := 'Net already entered in the net table    ';
    assert_strings[109] := 'n is too big in nth_bit_of_signal_inst  ';
    assert_strings[110] := 'signal has undef width in nth_bit_sig_in';
    assert_strings[111] := 'n outside rang in nth_bit_signal_inst   ';
    assert_strings[112] := 'WHAT? delete_subscript_element(NIL) ??? ';
    assert_strings[113] := 'Expected identifier.                    ';
    assert_strings[114] := 'Expected #                              ';
    assert_strings[115] := 'Expected $                              ';
    assert_strings[116] := 'Unexpected end of data.                 ';
    assert_strings[117] := 'Expected &                              ';
    assert_strings[118] := 'Expected , or ;                         ';
    assert_strings[119] := 'Expected D                              ';
    assert_strings[120] := 'Expected :<time> or rest of page spec   ';
    assert_strings[121] := 'Expected id/macro lists or next page    ';
    assert_strings[122] := 'Expected #<constant> (a numbered id)    ';
    assert_strings[123] := 'Expected $<constant> (a numbered string)';
    assert_strings[124] := 'Dictionary entry number out of range    ';
    assert_strings[125] := 'Expected macro list or next page        ';
    assert_strings[126] := 'Expected parm list or next context      ';
    assert_strings[127] := 'Expected (                              ';
    assert_strings[128] := 'Expected %                              ';
    assert_strings[129] := 'Expected :R or next item.               ';
    assert_strings[130] := 'Expected <constant> or $<constant>      ';
    assert_strings[131] := 'Expected :I or :S or next item.         ';
    assert_strings[132] := 'Expected -                              ';
    assert_strings[133] := 'NIL formal_actual to gather_pin_properti';
    assert_strings[134] := 'NIL macro to a UNIX directory routine   ';
    assert_strings[135] := 'NIL node^.called_by on non-root node    ';
    assert_strings[136] := 'Non-canonical bit order in synonyms tabl';
    assert_strings[137] := 'Base cannot be found for signal instance';
    assert_strings[138] := 'Too many passes in find base            ';
    assert_strings[139] := 'Undefined signal in find base           ';
    assert_strings[140] := 'Bit must occur on base_BD               ';
    assert_strings[141] := 'NIL list of actuals in synonyms_actuals ';
    assert_strings[142] := 'Error in build_SI_from_SD               ';
    assert_strings[143] := 'Offset into scalar signal               ';
    assert_strings[144] := 'NIL list of actuals in de_NC_return_actu';
    assert_strings[145] := 'PCS is too short in get_bit_of_PCS      ';
    assert_strings[146] := 'NIL PCS in get_bit_of_PCS               ';
    assert_strings[147] := 'Bad property attr in old_copy_props_to_b';
    assert_strings[148] := 'nth_bit_sub ret FALSE in merge_subscrip ';
    assert_strings[149] := 'NIL instance passed to nth_bit_subscr   ';
    assert_strings[150] := 'Expected version constant               ';
    assert_strings[151] := 'Expected page number                    ';
    assert_strings[152] := 'Expected file name for macro definition ';
    assert_strings[153] := 'UNNAMED signal cannot have width        ';
    assert_strings[154] := 'Duplicate parameter found in create_symb';
    assert_strings[155] := 'Structure has already been defined      ';
    assert_strings[156] := 'Duplicate text macro definition found   ';
    assert_strings[157] := 'Popped string has wrong parse state     ';
    assert_strings[158] := 'Ill-formed NC internally                ';
    assert_strings[159] := 'Key word already found in the name table';
    assert_strings[160] := 'TM recursion depth counter underflow    ';
    assert_strings[161] := 'Parse environment stack underflow       ';
    assert_strings[162] := 'Reserved text macro has invalid attribut';
    assert_strings[163] := 'NIL subscript for vector in width_of_sub';
    assert_strings[164] := 'Expected :                              ';
    assert_strings[165] := 'Pin property found on non-existent pin  ';
    assert_strings[166] := 'Actual signal is NIL in output_expansion';
    assert_strings[167] := 'Non-NIL subscript in fix_instance_width ';
    assert_strings[168] := 'Could not find old instance for VECTOR  ';
    assert_strings[169] := 'Tried to open two files at once         ';
    assert_strings[170] := 'Tried to open UNKNOWN file type         ';
    assert_strings[171] := 'Tried to close file type not open       ';
    assert_strings[172] := 'Tried to close UNKNOWN file type file   ';
    assert_strings[173] := 'Tried to read file not opened           ';
    assert_strings[174] := 'Constant found at non-root node         ';
    assert_strings[175] := 'Binding has NIL formal and pin name     ';
    assert_strings[176] := 'Expected general property prefix symbol ';
    assert_strings[177] := 'Expected signal instance specifier      ';
    assert_strings[178] := 'Expected =                              ';
    assert_strings[179] := 'Expected an identifier                  ';
    assert_strings[180] := 'Unknown scope specification             ';
    assert_strings[181] := 'Expected >                              ';
    assert_strings[182] := 'Expected formal param subscript const   ';
    assert_strings[183] := 'Expected drawing name string            ';
    assert_strings[184] := 'Expected a constant for scope spec      ';
    assert_strings[185] := 'Expected UNDEFINED subscript specifier  ';
    assert_strings[186] := 'Bit lists are not permitted in pin names';
    assert_strings[187] := 'Signal to be fixed has known polarity   ';
    assert_strings[188] := 'Scope is UNKNOWN in enter_def_into_stack';
    assert_strings[189] := 'Local signal on stack out of order      ';
    assert_strings[190] := 'Scope value from CmpTmp is garbage      ';
    assert_strings[191] := 'Interface signal not released from node ';
    assert_strings[192] := 'Cannot fix assertion in signal stack    ';
    assert_strings[193] := 'Choose better base fails to decide      ';
    assert_strings[194] := 'Non-NIL stack in def passed to PUSH     ';
    assert_strings[195] := 'Could not find non-virtual signal       ';
    assert_strings[196] := 'Synonym of 2 non-virtual signals        ';
    assert_strings[197] := 'Actual signal is virtual!               ';
    assert_strings[198] := 'Assertion error detected in check_and_fi';
    assert_strings[199] := 'Determining signal has UNKNOWN polarity ';
    assert_strings[200] := 'Signal found without NN property        ';
    assert_strings[201] := 'Numbered token table bucket out of order';
    assert_strings[202] := 'Duplicate numbered tokens (same value)  ';
    assert_strings[203] := 'Looking for UNKOWN_NUMBERED_TOKEN ???   ';
    assert_strings[204] := '"New" token number already exists!!!    ';
    assert_strings[205] := 'Nil numbered token value encountered!   ';
    assert_strings[206] := 'Nil token field in token list.          ';
    assert_strings[207] := 'Reference to an undefined numbered tok !';
    assert_strings[208] := 'Numbered token dictionary overflow.     ';
    assert_strings[209] := 'Unrecognized numbered token type.       ';
    assert_strings[210] := 'Failed call to enter_expandable_id      ';
    assert_strings[211] := 'Enter_expandable_id(NIL) ????           ';
    assert_strings[212] := 'Unrecognized evaluation kind.           ';
    assert_strings[213] := 'Nil token field !!! (it is bad)         ';
    assert_strings[214] := 'Id number duplicated in expanded_ids    ';
    assert_strings[215] := 'NIL TM_name to expand/substitue_text_mac';
    assert_strings[216] := 'Non-canonical base_BD to synonym_1st_BD_';
    assert_strings[217] := 'Expected !                              ';
    assert_strings[218] := 'directory found under different auto-nam';
    assert_strings[219] := 'structure not counted in heap estimate  ';
    assert_strings[220] := 'Nil string passed as argument           ';
    assert_strings[221] := 'Nil name passed as argument             ';
    assert_strings[222] := 'Unrecognized open mode                  ';
    assert_strings[223] := 'Unable to dup a file descriptor         ';
    assert_strings[224] := 'Illegal numbered token dictionary insert';
    assert_strings[225] := 'UNKNOWN_TOKEN_NUMBER found in table     ';
    assert_strings[226] := 'Expected SEPCOMP or END.                ';
    assert_strings[227] := 'NIL version or page to read_macro_page  ';
    assert_strings[228] := 'Attempted to rewrite file ""            ';
    assert_strings[229] := 'Directory contains version with no pages';
    assert_strings[230] := 'NIL directory field in macro_entry      ';
    assert_strings[231] := 'Non-VECTOR instance to slice_of_instance';
    assert_strings[232] := 'NIL subs on VECTOR pin_name in output_ac';
    assert_strings[233] := 'illegal id in an id table               ';
    assert_strings[234] := 'expected a parameter list               ';
    assert_strings[235] := 'String length exceeded internally       ';
    assert_strings[236] := 'Redundant context definition entries    ';
    assert_strings[237] := 'Unable to get a time stamp              ';
    assert_strings[238] := 'illegal make_pass                       ';
    assert_strings[239] := 'number_non_leaf_nodes < 0               ';
    assert_strings[240] := 'internal integer overflow               ';
    assert_strings[241] := 'Severe problem with virtual stack ops   ';
    assert_strings[242] := 'nth_bit_of_instance FALSE in fix_basescr';
    assert_strings[243] := 'LOGIC prim read with new prim semantics ';
    assert_strings[244] := 'Illegitimate AVL type                   ';
    assert_strings[245] := 'Mismatched AVL types                    ';
    assert_strings[246] := 'Equal strings have unequal pointers     ';
    assert_strings[247] := 'find_base_of_PCS returns NIL            ';
    assert_strings[248] := 'nth_bit_of_PCS FALSE                    ';
    assert_strings[249] := 'insertion into non-active dictionary    ';
  end { init_assertions } ;


  procedure init_errors;
    { init the error messages }
  begin
    error_strings[0]   := 'Unimplemented error message             ';
    error_strings[1]   := 'Expected identifier                     ';
    error_strings[2]   := 'Expected =                              ';
    error_strings[3]   := '                                        ';
    error_strings[4]   := '                                        ';
    error_strings[5]   := 'Expected ,                              ';
    error_strings[6]   := '                                        ';
    error_strings[7]   := 'Expected )                              ';
    error_strings[8]   := '                                        ';
    error_strings[9]   := 'Wrong file type for text macros         ';
    error_strings[10]  := 'Expected <                              ';
    error_strings[11]  := 'Expected >                              ';
    error_strings[12]  := 'Expected ;                              ';
    error_strings[13]  := 'Expected :                              ';
    error_strings[14]  := 'Unexpected symbol in integer expression ';
    error_strings[15]  := 'Expected (                              ';
    error_strings[16]  := 'Bit value invalid                       ';
    error_strings[17]  := '                                        ';
    error_strings[18]  := '                                        ';
    error_strings[19]  := '                                        ';
    error_strings[20]  := 'Unmatched closing comment character     ';
    error_strings[21]  := '                                        ';
    error_strings[22]  := 'String length exceeded                  ';
    error_strings[23]  := 'Illegal character found                 ';
    error_strings[24]  := 'Expression value overflow               ';
    error_strings[25]  := 'Division by zero                        ';
    error_strings[26]  := '                                        ';
    error_strings[27]  := '                                        ';
    error_strings[28]  := '                                        ';
    error_strings[29]  := '                                        ';
    error_strings[30]  := 'Unexpected symbol in bit subscript      ';
    error_strings[31]  := 'Unknown REPORT specification            ';
    error_strings[32]  := 'Non-printing character found            ';
    error_strings[33]  := 'Expected a string                       ';
    error_strings[34]  := 'Comment not closed before end of input  ';
    error_strings[35]  := 'Specified parameter # > allowed # params';
    error_strings[36]  := 'Signal MUST have high assertion char    ';
    error_strings[37]  := 'Expected .                              ';
    error_strings[38]  := 'File name has already been specified    ';
    error_strings[39]  := 'Undefined identifier in expression      ';
    error_strings[40]  := 'Expected END                            ';
    error_strings[41]  := 'Identifier length exceeded              ';
    error_strings[42]  := 'Unknown debug control specifier         ';
    error_strings[43]  := 'Text macro parameter exceeds max length ';
    error_strings[44]  := 'Constant width value out of range       ';
    error_strings[45]  := 'Directive has already been specified    ';
    error_strings[46]  := 'Duplicate global text macro definition  ';
    error_strings[47]  := 'Invalid specification for inheritance   ';
    error_strings[48]  := 'Unknown property attribute              ';
    error_strings[49]  := '                                        ';
    error_strings[50]  := 'Extraneous junk at end of number        ';{non-parse}
    error_strings[51]  := 'Unknown compiler directive              ';
    error_strings[52]  := 'Invalid specification for directive     ';
    error_strings[53]  := 'Input line exceeds maximum length       ';
    error_strings[54]  := '                                        ';
    error_strings[55]  := 'Wrong file type for property attributes ';
    error_strings[56]  := 'Text macro parameter cannot be found    ';
    error_strings[57]  := 'End of input before end of expression   ';
    error_strings[58]  := 'Extraneous characters at end of expr    ';
    error_strings[59]  := 'Identifier has not been defined         ';
    error_strings[60]  := '                                        ';
    error_strings[61]  := 'Radix must be in range 2..16            ';
    error_strings[62]  := 'Extraneous junk at end of menu version  ';
    error_strings[63]  := 'Extraneous junk at end of boolean expr  ';
    error_strings[64]  := 'Max text macro nesting depth exceeded   ';
    error_strings[65]  := 'Compile extension name is too long      ';
    error_strings[66]  := 'Compilation to .PRIM files not permitted';
    error_strings[67]  := 'Subrange symbol must be .. or :         ';
    error_strings[68]  := 'Library file has already been specified ';
    error_strings[69]  := 'Unknown signal syntax specification     ';
    error_strings[70]  := 'Version number is outside allowed range ';
    error_strings[71]  := 'Page number is outside allowed range    ';
    error_strings[72]  := 'Duplicate page number                   ';
    error_strings[73]  := 'Signal syntax element found twice       ';
    error_strings[74]  := 'Every syntax MUST have a name portion   ';
    error_strings[75]  := 'Every syntax MUST have a subscript      ';
    error_strings[76]  := 'Bool expr already defined for this vers ';
    error_strings[77]  := 'Specified version is not in directory   ';
    error_strings[78]  := 'Only MENU bodies are allowed here       ';
    error_strings[79]  := 'Expected a version 1 with MENU body(s)  ';
    error_strings[80]  := 'Illegal property on MENU body           ';
    error_strings[81]  := 'Illegal MENU property number            ';
    error_strings[82]  := 'Same MENU expr property found twice     ';
    error_strings[83]  := 'Expected signal name or constant        ';
    error_strings[84]  := 'Replication factor is out of range      ';
    error_strings[85]  := 'Expected FILE_TYPE specification        ';
    error_strings[86]  := 'File is not of the correct type         ';
    error_strings[87]  := 'Directory file name previously specified';
    error_strings[88]  := '                                        ';
    error_strings[89]  := 'String not closed before the end of line';
    error_strings[90]  := 'Illegal file type for configuration file';
    error_strings[91]  := '                                        ';
    error_strings[92]  := 'Invalid (warnings and oversights only)  ';
    error_strings[93]  := 'Expected directory file name            ';
    error_strings[94]  := 'Invalid value for print width           ';
    error_strings[95]  := 'Drawings have not been written with 5.5 ';
    error_strings[96]  := 'Bit subscript on constant not permitted ';
    error_strings[97]  := 'Unknown output file name                ';
    error_strings[98]  := '                                        ';
    error_strings[99]  := 'This symbol cannot be used here         ';
    error_strings[100] := 'Illegal form for signal syntax          ';
    error_strings[101] := 'Drawing path name is missing closing )  ';
    error_strings[102] := 'Symbol must be one character            ';
    error_strings[103] := 'Library not found in master directory   ';
    error_strings[104] := 'Wrong FILE_TYPE for master library      ';
    error_strings[105] := 'Reserved text macro name                ';
    error_strings[106] := 'Cannot find definition for text macro   ';
    error_strings[107] := 'Duplicate library entry in master lib   ';
    error_strings[108] := 'No SIZE in context for SIZEd drawing    ';
    error_strings[109] := 'Body properties are not allowed here    ';
    error_strings[110] := 'Undefined text macro (null value)       ';
    error_strings[111] := 'No directory was specified              ';
    error_strings[112] := 'Separate AND single drawing compilation ';
    error_strings[113] := 'Replication is not permitted on pin name';
    error_strings[114] := 'Text macro has already been defined     ';
    error_strings[115] := 'Same MENU version property found twice  ';
    error_strings[116] := 'Expanded string exceeds max string len  ';
    error_strings[117] := 'Textmacro and parameters exceeds max len';
    error_strings[118] := 'Expression value is empty               ';
    error_strings[119] := 'NC is not permitted as a pin name       ';
    error_strings[120] := 'Path name exceeds maximum length        ';
    error_strings[121] := 'Path element name exceeds maximum length';
    error_strings[122] := 'Drawing has incompatible extensions     ';
    error_strings[123] := 'Selection expr and MENU expr mismatch   ';
    error_strings[124] := 'Versioned drawings not written w 7.0 GED';
    error_strings[125] := 'Pin properties are not permitted here   ';
    error_strings[126] := 'Text macro is not an identifier         ';
    error_strings[127] := 'ABBREV property not found for drawing   ';
    error_strings[128] := 'ABBREV value must be letters, digits & _';
    error_strings[129] := 'Menu entry for version is not permitted ';
    error_strings[130] := 'Scalar reference to vector signal       ';
    error_strings[131] := 'Vector reference to scalar signal       ';
    error_strings[132] := 'Concatenated signal as pin name         ';
    error_strings[133] := 'This property has already been defined  ';
    error_strings[134] := 'Terminal drawing is not a primitive part';
    error_strings[135] := 'Cannot open compiler directives file    ';
    error_strings[136] := 'Signals cannot be attached to this body ';
    error_strings[137] := 'Text macro nesting depth exceeded       ';
    error_strings[138] := 'Cannot open error documentation file    ';
    error_strings[139] := 'More than 1 selection expression is true';
    error_strings[140] := 'This signal cannot be DECLAREd          ';
    error_strings[141] := 'SIZE property on non SIZE-wide body     ';
    error_strings[142] := 'MENU bodies are not supported           ';
    error_strings[143] := 'Illegal rotation on this body           ';
    error_strings[144] := 'This body should not be given SIZE prop ';
    error_strings[145] := 'Pin name does not exist                 ';
    error_strings[146] := 'Pin name does not have this bit         ';
    error_strings[147] := 'Root drawing specified as primitive.    ';
    error_strings[148] := 'No root drawing was specified           ';
    error_strings[149] := 'Synonyms must use single assertion      ';
    error_strings[150] := 'PERMIT attribute value invalid          ';
    error_strings[151] := 'This property not permitted on a SIGNAL ';
    error_strings[152] := 'This property not permitted on a BODY   ';
    error_strings[153] := 'This property not permitted on a PIN    ';
    error_strings[154] := 'Signal''s assertion cannot be determined ';
    error_strings[155] := 'Attempt to synonym 0 and 1              ';
    error_strings[156] := 'Signal''s width cannot be determined     ';
    error_strings[157] := 'Error found in configuration file: fatal';
    error_strings[158] := '8.0 SIZE replication not yet implemented';
    error_strings[159] := 'Synonym of unequal width signals        ';
    error_strings[160] := 'Cannot SIZE replicate plumbing drawings ';
    error_strings[161] := '2 signals w/ timing assertions synonymed';
    error_strings[162] := 'Interface and local signals conflict    ';
    error_strings[163] := 'Local and global signals conflict       ';
    error_strings[164] := 'Global and interface signals conflict   ';
    error_strings[165] := 'This signal cannot have scope property  ';
    error_strings[166] := 'Cannot access CMPDRAW file for input    ';
    error_strings[167] := 'Cannot open synonyms file for input     ';
    error_strings[168] := 'Cannot close file                       ';
    error_strings[169] := 'Cannot open file for output             ';
    error_strings[170] := 'Cannot open master library file         ';
    error_strings[171] := 'Bit subscript increment of 0 not allowed';
    error_strings[172] := 'Bit subscript should be right to left   ';
    error_strings[173] := 'Bit subscript should be left to right   ';
    error_strings[174] := '                                        ';
    error_strings[175] := '                                        ';
    error_strings[176] := '                                        ';
    error_strings[177] := 'Selection expr for drawing is FALSE     ';
    error_strings[178] := 'Max error value must be >= 1            ';
    error_strings[179] := 'Extraneous junk at end of signal        ';
    error_strings[180] := 'Parameter was declared twice            ';
    error_strings[181] := 'Cannot access drawing directory         ';
    error_strings[182] := 'Drawing title does not match directory  ';
    error_strings[183] := 'X_FIRST must be >= 0 (set to 0)         ';
    error_strings[184] := 'PIN_EQUIVALENT no longer supported      ';
    error_strings[185] := 'SIZE must be >= 0 (set to 1)            ';
    error_strings[186] := 'X_STEP must be > 0 (set to 1)           ';
    error_strings[187] := 'Assertion chk failure: save CMPLOG file ';
    error_strings[188] := 'Parameters not permitted on this body   ';
    error_strings[189] := 'Timing assertion not allowed on pin name';
    error_strings[190] := 'No selection expression evaluates true  ';
    error_strings[191] := 'Drawing not found in the directories    ';
    error_strings[192] := 'PATH name element is not unique         ';
    error_strings[193] := 'No versions found for drawing           ';
    error_strings[194] := 'Text macro refers to itself (recursive) ';
    error_strings[195] := 'Cannot open specified attributes file   ';
    error_strings[196] := 'Default value used for SIZE (1)         ';
    error_strings[197] := 'PATH property not found for body        ';
    error_strings[198] := 'Bit subscript on undefined width pin    ';
    error_strings[199] := 'Pin name conflicts with previous pin    ';
    error_strings[200] := 'Pin name and signal widths do not match ';
    error_strings[201] := 'Signal fails bubble check on this pin   ';
    error_strings[202] := 'Pin name with NWC cannot have subscript ';
    error_strings[203] := 'LOGIC primitive used as terminal drawing';
    error_strings[204] := 'Pin name cannot use signal negation     ';
    error_strings[205] := 'Cannot open file                        ';
    error_strings[206] := 'Cannot open specified directory file    ';
    error_strings[207] := 'Cannot open syntax configuration file   ';
    error_strings[208] := 'Too many errors in this compile!        ';
    error_strings[209] := 'Cannot open specified text macro file   ';
    error_strings[210] := 'Primitive cannot have NWC pin           ';
    error_strings[211] := 'Pin name is vector but used as a scalar ';
    error_strings[212] := 'A pin name cannot be a constant         ';
    error_strings[213] := 'Versioned drawing must have EXPR prop   ';
    error_strings[214] := 'String not closed before end of signal  ';
    error_strings[215] := 'Pin name is scalar but used as vector   ';
    error_strings[216] := 'PART not allowed; COMPILE LOGIC assumed ';
    error_strings[217] := 'Fatal error(s) encountered - run stopped';
    error_strings[218] := 'Bit lists are not permitted in pin names';
    error_strings[219] := 'DECLARE bodies are no longer supported  ';
    error_strings[220] := 'PART_NAME property should not be used   ';
    error_strings[221] := 'Bodies with NWC cannot expand to parts  ';
    error_strings[222] := 'DELETE_DRAWING specifies unfound drawing';
    error_strings[223] := 'SCHEMA file is not a SCHEMA file.       ';
    error_strings[224] := 'Extraneous junk at end of command line  ';
    error_strings[225] := 'This directive is obsolete              ';
    error_strings[226] := 'auto-SCALD dir name not in master dir   ';
    error_strings[227] := 'Cannot open expansion file              ';
    error_strings[228] := 'Incorrect use of seplink command        ';
    error_strings[229] := 'Illegal COMMAND value                   ';
    error_strings[230] := 'Page directory is not a directory       ';
    error_strings[231] := 'No connectivity file in page directory  ';
    error_strings[232] := 'Unable to access schema file            ';
    error_strings[233] := 'Expected an expansion file -- wrong type';
    error_strings[234] := 'Cannot access DESIGN file for output    ';
    error_strings[235] := 'Signal synonymed to its own complement  ';
    error_strings[236] := 'Cannot make a directory                 ';
    error_strings[237] := 'Cannot get file "last modified" time    ';
    error_strings[238] := 'Context not found in schema             ';
    error_strings[239] := '                                        ';
    error_strings[240] := '.PRIM and .PART both found for drawing  ';
    error_strings[241] := 'Pin connected to its own complement     ';
    error_strings[242] := 'Different pins on bodies for same module';
    error_strings[243] := 'Compiler errors in a drawing            ';
    error_strings[244] := 'Needed module was not loaded            ';
    error_strings[245] := 'ABBREV property conflict in drawing     ';
    error_strings[246] := 'Unable to remove file                   ';
    error_strings[247] := 'Pages of version across SCALD dirs      ';
    error_strings[248] := 'Pin conflict between instances of module';   
    
    


    { initialize environment variables for error display }

    exception_code := NULL_ERROR_CODE;

    { ------- error sets ------- }

    scan_past_errors := [1..8,10..13,15,33,37,40,83,85,88,93,179];
  end { init_errors } ;


  procedure init_sets;
    { initialize various constant sets }
  begin
    valid_chars[2]  := ['0','1'];
    valid_chars[3]  := valid_chars[2]  + ['2'];
    valid_chars[4]  := valid_chars[3]  + ['3'];
    valid_chars[5]  := valid_chars[4]  + ['4'];
    valid_chars[6]  := valid_chars[5]  + ['5'];
    valid_chars[7]  := valid_chars[6]  + ['6'];
    valid_chars[8]  := valid_chars[7]  + ['7'];
    valid_chars[9]  := valid_chars[8]  + ['8'];
    valid_chars[10] := valid_chars[9]  + ['9'];
    valid_chars[11] := valid_chars[10] + ['A'];
    valid_chars[12] := valid_chars[11] + ['B'];
    valid_chars[13] := valid_chars[12] + ['C'];
    valid_chars[14] := valid_chars[13] + ['D'];
    valid_chars[15] := valid_chars[14] + ['E'];
    valid_chars[16] := valid_chars[15] + ['F'];

    constant_chars := ['0'..'9','(',')'];
    legal_chars := ['0'..'9','A'..'I','J'..'R','S'..'Z',
                    'a'..'i','j'..'r','s'..'z',
                    ' ','!','"','#','$','%','&','''','(',')',
                    '*','+',',','-','.','/',':',';','<','>',
                    '=','?','@','[',
#if SVS
                    '\\',
#else
                    '\', 
#endif 
                    ']','^','{','|','}','~','_','`'];

    allowed_key_words := [FILETYPESY,PRIMITIVESY,ENDPRIMITIVESY,
                          SIGNALSY,ENDSIGNALSY,BINDINGSY,ENDBINDINGSY,
			  BODYSY,ENDBODYSY,PINSY,ENDPINSY,ENDSY];
    inheritance_attributes := [INHERIT_BODY, INHERIT_PIN, INHERIT_SIGNAL];
    signal_inheritance_attributes := [INHERIT_PIN, INHERIT_SIGNAL];
    permission_attributes := [PERMIT_SIGNAL, PERMIT_PIN, PERMIT_BODY];
    default_attributes := [INHERIT_BODY, INHERIT_SIGNAL] +
                          permission_attributes;
    parameter_attributes := [IS_INT_PARAMETER, IS_PARAMETER];
  end { init_sets } ;


  procedure init_string_structures;
    { init the table describing the discrete string lengths that can be
      created on the heap }
    var
      i: 1..33;                  { index into list of free strings }
      j: hash_string_range;      { index into the string table }
  begin
    for j := 0 to HASH_STRING_TABLE_SIZE do string_table[j] := NIL;

    free_pointers := NIL;
    for i := 1 to 33 do free_strings[i] := NIL;
    s_length[1] := 4;
    s_length[2] := 8;
    s_length[3] := 12;
    s_length[4] := 16;
    s_length[5] := 20;
    s_length[6] := 24;
    s_length[7] := 28;
    s_length[8] := 32;
    s_length[9] := 36;
    s_length[10] := 40;
    s_length[11] := 44;
    s_length[12] := 48;
    s_length[13] := 52;
    s_length[14] := 56;
    s_length[15] := 60;
    s_length[16] := 64;
    s_length[17] := 68;
    s_length[18] := 72;
    s_length[19] := 76;
    s_length[20] := 80;
    s_length[21] := 84;
    s_length[22] := 88;
    s_length[23] := 92;
    s_length[24] := 96;
    s_length[25] := 100;
    s_length[26] := 120;
    s_length[27] := 140;
    s_length[28] := 160;
    s_length[29] := 180;
    s_length[30] := 200;
    s_length[31] := 220;
    s_length[32] := 240;
    s_length[33] := 256;

    create_a_string(nullstring, 0);
  end { init_string_structures } ;


  procedure init_lexical_analyzer;
    { initialize the lexical analyzer }
    var
      i: radix_range;     { index into the table of radix digit sizes (bits) }
  begin
    id.next := NIL;
    sy := nullsy;
    const_val := 0;
    const_width := 0;
    read_state := FINIT;
    line_pos := 0;
    last_sym_pos := 0;
    upper_case_strings := TRUE;
    current_file := UNKNOWN_FILE;
    parse_SCALDconstants := TRUE;

    create_a_string(lex_string,   MAX_STRING_LENGTH);
    create_a_string(input_buffer, MAX_STRING_LENGTH);
    create_a_string(instring,     MAX_STRING_LENGTH);
    create_a_string(last_string,  MAX_STRING_LENGTH);
    instring^[0] := chr(0);  last_string^[0] := chr(0);

    for i := MIN_RADIX to MAX_RADIX do
      radix_width[i] := round(ln(i) / 0.6931471805 + 0.4);   { ceil log2(i) }
  end { init_lexical_analyzer } ;


  function make_and_enter_string(val: alpha): xtring;
    { make a string from the alpha and enter in string table }
    var
      temp: xtring;
  begin
    create_a_string(temp, alpha_length(val));  temp^[0] := chr(0);
    if add_alpha_to_string(temp, val) then ;
    make_and_enter_string := enter_and_release_string(temp);
  end { make_and_enter_string } ;


  procedure init_constants;
    { init some global constants }
  begin
    digits := ['0'..'9'];
    letters := ['A'..'I','J'..'R','S'..'Z'];     { EBCDIC compatibility }
    lower_case := ['a'..'i','j'..'r','s'..'z'];  { EBCDIC compatibility }
    identifier_chars := letters + digits + ['_'];
    alphanumeric := letters + digits;
    NC_string := make_and_enter_string('NC              ');
    dev_null := make_and_enter_string('/dev/null       ');
  end { init_constants } ;


  procedure init_scalars;
    { initialize standard scalars }
  begin
    prim_table_1 := NIL;
    prim_table_2 := NIL;
  end { init_scalars } ;


  procedure init_debug_controls;
    { initialize debug flags and directives }


    procedure add_specifier(specifier: debug_controls; name: alpha);
      { add a debug specifier to table }
    begin
      debug_control_specifier[specifier] := enter_name(name);
    end { add_specifier } ;


  begin { init_debug_controls }
    debug := FALSE;
    debugging := FALSE;
    debug_1 := FALSE;
    debug_2 := FALSE;
    debug_3 := FALSE;
    debug_4 := FALSE;
    debug_5 := FALSE;
    debug_6 := FALSE;
    debug_7 := FALSE;
    debug_8 := FALSE;
    debug_9 := FALSE;
    debug_10 := FALSE;
    debug_11 := FALSE;
    debug_12 := FALSE;
    debug_13 := FALSE;
    debug_14 := FALSE;
    debug_15 := FALSE;
    debug_16 := FALSE;
    debug_17 := FALSE;
    debug_18 := FALSE;
    debug_19 := FALSE;
    debug_20 := FALSE;
    debug_21 := FALSE;
    debug_22 := FALSE;
    debug_23 := FALSE;
    debug_24 := FALSE;
    debug_25 := FALSE;
    debug_26 := FALSE;
    debug_27 := FALSE;
    debug_28 := FALSE;
    debug_29 := FALSE;
    debug_30 := FALSE;

    add_specifier(control_dumptree         , 'DUMPTREE        ');
    add_specifier(control_dumpsignals      , 'DUMPSIGNALS     ');
    add_specifier(control_printmacros      , 'PRINTMACROS     ');
    add_specifier(control_printdirectory   , 'PRINTDIRECTORY  ');
    add_specifier(control_printhistograms  , 'PRINTHISTOGRAMS ');
    add_specifier(control_dumpsigdeflist   , 'DUMPSIGDEFLIST  ');
    add_specifier(control_dump_all_names   , 'DUMP_ALL_NAMES  ');

    debug_at_path := FALSE;  undebug_at_path := FALSE;
    path_for_debug := nullstring;  path_for_undebug := nullstring;
    debug_flags := [];  undebug_flags := [];
    dumptree_ok := FALSE;
    dumpsignals_ok := FALSE;
    printmacros_ok := FALSE;
    printdirectory_ok := FALSE;
    dumpsigdeflist_ok := FALSE;
    dump_all_names_ok := FALSE;

    histograms := [];
    histogram_specifiers[directory_histogram   ] :=
                                               enter_name('DIRECTORY       ');
    histogram_specifiers[signal_histogram      ] :=
                                               enter_name('SIGNAL          ');
    histogram_specifiers[name_table_histogram  ] :=
                                               enter_name('NAME_TABLE      ');
    histogram_specifiers[string_table_histogram] :=
                                               enter_name('STRING_TABLE    ');
  end { init_debug_controls } ;


  procedure init_free_lists;
    { initialize lists of "free" structures }
  begin
    free_avls := NIL;
    free_avl_object_lists := NIL;
    free_properties := NIL;
  end { init_free_list } ;


begin { init }
  { NOTE: these initialization routines are order sensitive.  The routines
          called first are those that use no other "constant" variables
          for initializations.  The other routines do, and some of them
          must be called in this specific order.  Check very carefully
          before changing any of this. }

  { these initializations do NOT rely on other initializations }

  init_free_lists;    { this must be first because of NEW recording }

  init_sets;
  init_string_structures;
  init_constants;
  init_assertions;
  init_scalars;
  init_directives;

  { these initializations rely on other initializations }

  init_keywords;
  init_built_in_identifier_names;
  init_errors;
  init_lexical_analyzer;
  init_debug_controls;
  init_cli_arg_structures;


  if not rewrite_file(monitor, nullstring, 'STANDARD_ERROR  ') then
    halt_with_status(FATAL_COMPLETION);
  writeln(monitor);
  write(monitor, WELCOME_MESSAGE);
  dump_string(monitor, vversion);
  writeln(monitor);
  writeln(monitor, COPYRIGHT_NOTICE);
  writeln(monitor, DISCLAIMER);
end { init } ;

