(**){--------------- NEW & RELEASE for AVL objects --------}

{---------------------------------------------------------------}
{ All new and release routines for avl objects are simple news  }
{ and releases.  They do not insert or delete the objects from  }
{ lists (other than, of course, the free list).  Release        }
{ routines always return NIL.                                   }
{---------------------------------------------------------------}

procedure new_avl(var avlp: avl_ptr;  tag_val: avl_type);
  { new an avl and initialize for the appropriate type.
    The free list is threaded by left_child. }
begin
  if free_avls <> NIL then
    begin  
      avlp := free_avls;
      free_avls := free_avls^.left_child;  
    end
  else new(avlp);
  with avlp^ do
    begin
      left_child := NIL;  right_child := NIL;
      balance_factor := EVEN_BF;
{     object.tag := tag_val;                                      }(*AVL*)
      case tag_val of
        AVL_FIRST: object.bogus := NIL;
        AVL_PRIMITIVE: object.prim := NIL;
	AVL_PIN: object.pin := NIL;
	AVL_PROPERTY: object.prop := NIL;
	AVL_SIGNAL: object.sig := NIL;
	OTHERWISE assert(244 { unknown AVL type });
      end;
    end;
end { new_val } ;


procedure release_avl(var avlp: avl_ptr);
  { Release the avl and return NIL }
begin
  if avlp <> NIL then
    begin
      avlp^.left_child := free_avls;  free_avls := avlp;  avlp := NIL;
    end;
end { release_avl } ;


procedure release_entire_avl_tree(var root: avl_ptr);
  { release all avl elements in the tree and return NIL }
begin
  if root <> NIL then
    begin
      if root^.left_child <> NIL then
        release_entire_avl_tree(root^.left_child);
      if root^.right_child <> NIL then
        release_entire_avl_tree(root^.right_child);
      root^.left_child := free_avls;  free_avls := root;  root := NIL;
    end;
end { release_entire_avl_tree } ;


(**)     { ------- free lists -------------------- }


procedure insert_pin_in_list(var head: avl_object_list_ptr; pin: pin_ptr);
  var
    p: avl_object_list_ptr;
begin
  if free_avl_object_lists = NIL then new(p)
  else 
    begin
      p := free_avl_object_lists;
      free_avl_object_lists := free_avl_object_lists^.next;
    end;
  p^.next := head;
  p^.object.pin := pin;
  head := p;
end { insert_pin_in_list } ;


procedure insert_property_in_list(var head: avl_object_list_ptr;
                                  prop: property_ptr);
  var
    p: avl_object_list_ptr;
begin
  if free_avl_object_lists = NIL then new(p)
  else 
    begin
      p := free_avl_object_lists;
      free_avl_object_lists := free_avl_object_lists^.next;
    end;
  p^.next := head;
  p^.object.prop := prop;
  head := p;
end { insert_property_in_list } ;


procedure release_entire_avl_object_list(var head: avl_object_list_ptr);
  var
    last: avl_object_list_ptr;
begin
  if head <> NIL then
    begin
      last := head;
      while last^.next <> NIL do last := last^.next;
      last^.next := free_avl_object_lists;
      free_avl_object_lists := head;
      head := NIL;
    end;
end { release_entire_avl_object_list } ;


{ property_type records are newed within enter_property }


procedure release_property(var prop: property_ptr);
begin
  if prop <> NIL then
    begin
      prop^.next := free_properties;
      free_properties := prop;
    end;
end { release_property } ;


procedure release_all_properties(var prop: avl_ptr);
begin
  if prop <> NIL then
    begin
      release_all_properties(prop^.left_child);
      release_all_properties(prop^.right_child);
      release_property(prop^.object.prop);
      release_avl(prop);
    end;
end { release_all_properties } ;

