
 {----------------------------  CONSTS  --------------------------------}

  WELCOME_MESSAGE = ' Valid Logic Systems, Inc.  ValidEXPDIFF  ';
  COPYRIGHT_NOTICE = ' (C) Copyright 1985,1989 Valid Logic Systems, Inc.';
  DISCLAIMER = ' This is NOT a supported product.';

#if !VAX && !IBM
  MAXINT            = 2147483647;   { Maximum longint }
#endif 

  EOL                   = 0;       { end of line character }
  TAB_CHAR              = 9;       { ASCII tab character }
  CONTINUATION_CHAR     = '~';     { line continuation character }
  NC_PREFIX_CHAR        = 1;       { prefixes NC signals to make special }
  VIRTUAL_PREFIX_CHAR   = '*';     { char used when creating NET_ID props }
  UNIQUE_PREFIX_CHAR    = '%';     { char used for creating NET_ID props }
  TIMING_ASSERTION_CHAR = '!';     { character flagging timing assertions }

  ID_LENGTH           = 16;        { number of characters in an id }
  MAX_ERROR_NUM       = 255;       { maximum error number }
  MAX_ASSERT_NUM      = 255;       { maximum assertion error number }
  MAX_BIT_VALUE       = MAXINT;    { maximum bit value for bit subscripts }
  INPUT_BUFFER_LENGTH = 80;        { length of the input line buffer }

  MAX_OUTPUT_FILE_LENGTH = 76;     { length of output files }

  NAME_TABLE_SIZE        = 126;  { size of the identifier name table - 1 }

  MIN_RADIX           = 2;         { minimum allowed input radix }
  MAX_RADIX           = 16;        { maximum allowed input radix }

  MESSAGE_LENGTH      = 17;        { length of debug messages }
  
  CLOCK_UNITS         = 1000;      { basic CLOCK time units }

#if IBM
  SUCCESSFUL_COMPLETION = 0;
  DIFFERENCE_COMPLETION = 1;
  FATAL_COMPLETION      = 4;
#endif
#if VAX
  SUCCESSFUL_COMPLETION = 1;
  DIFFERENCE_COMPLETION = 0;
  FATAL_COMPLETION      = 4;
#endif
#if UNIX
  SUCCESSFUL_COMPLETION = 0;
  DIFFERENCE_COMPLETION = 1;
  FATAL_COMPLETION      = 11;
#endif
  NULL_ALPHA          = '                ';  

  CLOSED_ALPHA        = 'CLOSED          ';
  DEFINE_ALPHA        = 'DEFINE          ';

  DEBUG_PASSWORD      = 'FRAMITZ         ';
  CONFIGURE_PASSWORD  = 'ZZYZYX          ';

    
  { -- special characters -- }

  PATH_ELEMENT_SEPARATOR    = ' ';  { separator char for path names }
  PATH_PIECE_SEPARATOR      = '.';  { separator char between element pieces }
  SIZE_PREFIX_CHAR          = '#';  { prefix for size spec in path names }
  TM_PARAMETER_PREFIX_CHAR  = '%';  { prefix char for text macro parameters }
  OUTPUT_QUOTE_CHAR         = ''''; { quote character for full compilation 
				      output files }
  ERROR_POSITION_CHAR       = '^';  { pointer to position of error in line }
  OUTPUT_NWC_CHAR           = 'N';  { flags formal as NWC pin for linker }


  { -- consts for procedure parameters -- }

  MENUS_ONLY          = TRUE;      { parse menu bodies only in parse_macro_d }
  ALL_BODIES          = FALSE;     { parse all bodies in parse_macro_def }

  ALLOW_DUPLICATIONS  = TRUE;      { allow text macro duplications in add_TM }
  NO_DUPLICATIONS     = FALSE;     { the opposite of above }

  CRLF                = TRUE;      { output CRLF (passed parameter) }
  NOCRLF              = FALSE;     { don't output CRLF (passed parameter) }

  CHECK_AND_FIX       = FALSE;     { check AND fix unresolved width synonyms }
  JUST_CHECK          = TRUE;      { just check for existence of unresolved }

  PAD                 = TRUE;      { pad the output line (print_string_for) }
  NOPAD               = FALSE;     { don't pad the line }

  READ_AS_PARAMETERS  = TRUE;      { read user body parameters }
  READ_AS_PROPERTIES  = FALSE;     { read user body properties }

  ASSERT_LOW          = TRUE;      { signal is asserted low }
  ASSERT_HIGH         = FALSE;     { signal is asserted high }


  { -- special text macro defaults -- }

  DEFAULT_SIZE               = '1               ';
  DEFAULT_X_FIRST            = '0               ';
  DEFAULT_X_STEP             = 'SIZE            ';
  DEFAULT_X_STEP_FOR_LEAF    = '1               ';
  DEFAULT_X                  = 'X_FIRST         ';



  SCALAR_BIT = -1;


#if VAX
  TIME_BUFFER_LENGTH  = 11;
#endif
#if IBM
  TIME_BUFFER_LENGTH  = 16;
#endif
#if UNIX
  TIME_BUFFER_LENGTH  = 26;
#endif

  {------- string consts ---------------}

  HASH_STRING_TABLE_SIZE    = 1110;  { hash string table size - 1 }
  NUMBER_STRING_SIZES       = 33;    { number of discrete string sizes }

    { - misc -- }

    BUFSIZ = 1024; { 4.2 BSD -- BUFSIZ is 512 for 4.1c, so use the larger }

    UNIX_SUCCESS = 0;
    IBM_SUCCESS  = 0;
    VAX_SUCCESS = 0;


  MAX_CLI_ARG_NUMBER = 10; { maximum number of command line arguments 
			     other than the program name }

  { If the CMPTMP_ARGS_NUMBERth command line argument = CMPTMP_ARGS_FLAG, 
    then the command line arguments are obtained from line one of the
    (logical) CMPTMP file.  This kludge bypasses the command line 
    mechanism for systems that munge arguments -- such as CMS }

  CMPTMP_ARGS_NUMBER = 3;   { same as separate compilation arg number }
  CMPTMP_ARGS_FLAG         = 'CMPTMP          ';


  { -- a display constant -- }

  INDENT              = 4;         { indent space for broken output lines }


  MAX_DEBUG_FLAG_NUMBER = 30;

  { -- file name constants -- }

  MAX_NAME_LENGTH      = 250;      { length of a file name in Unix }
