(**){--------------- NEW & RELEASE for AVL objects --------}

{---------------------------------------------------------------}
{ All new and release routines for avl objects are simple news  }
{ and releases.  They do not insert or delete the objects from  }
{ lists (other than, of course, the free list).  Release        }
{ routines always return NIL.                                   }
{---------------------------------------------------------------}

procedure new_avl(var avlp: avl_ptr;  tag_val: avl_type);
  { new an avl and initialize for the appropriate type.
    The free list is threaded by left_child. }
begin
  if free_avls <> NIL then
    begin  
      avlp := free_avls;
      free_avls := free_avls^.left_child;  
    end
  else
    begin
      new(avlp);
      increment_heap_count(HEAP_AVL, 3*POINTER_SIZE+ENUM_SIZE
#if AVLDEBUG
                                     +ENUM_SIZE
#endif
                                                              );
    end;
  with avlp^ do
    begin
      left_child := NIL;  right_child := NIL;
      balance_factor := EVEN_BF;
#if AVLDEBUG
      object.tag := tag_val; 
#endif
      case tag_val of
        AVL_FIRST: object.dummy_first := 0;
        AVL_COMPLEMENTED_ACTUAL: object.complemented_actual := NIL;
        AVL_INVOKE: object.invoke := NIL;
	AVL_CONTEXT: object.context := NIL;
	AVL_CONTEXT_NUMBER: object.context_number := NIL;
	AVL_STRING: object.str := nullstring;
	AVL_COMPERR_DRAWING: object.cerr_drawing := NIL;
	AVL_COMPERR_MODULE: object.cerr_module := NIL;
        AVL_LAST: object.dummy_last := 0;
	OTHERWISE
	  begin
	    assert(244 { unknown AVL type });
	    object.complemented_actual := NIL;
	  end;
      end;
    end;
end { new_avl } ;


procedure release_avl(var avlp: avl_ptr);
  { Release the avl and return NIL }
begin
  if avlp <> NIL then
    begin
      avlp^.left_child := free_avls;  free_avls := avlp;  avlp := NIL;
    end;
end { release_avl } ;


procedure release_entire_avl_tree(var root: avl_ptr);
  { release all avl elements in the tree and return NIL }
begin
  if root <> NIL then
    begin
      if root^.left_child <> NIL then
        release_entire_avl_tree(root^.left_child);
      if root^.right_child <> NIL then
        release_entire_avl_tree(root^.right_child);
      root^.left_child := free_avls;  free_avls := root;  root := NIL;
    end;
end { release_entire_avl_tree } ;


