#include <stream.h>
#include "stringt.h"


const BUF_SIZE = 8192;  // ought to be big enough for any line
const TSIZE = 500;

// essentially a readln operation
istream& operator>>(istream& f, string& st)
{
    char s[BUF_SIZE];
    
    if (!f.get(s, BUF_SIZE)) {
	return f;
    }
    char c; while (f.get(c) && c != '\n' && c != EOF); // truncate line
    st = s;
    return f;
}


gavl_define(name,thing,string);
class thing {
    friend ostream& operator<<(ostream&, const thing&);
    char junk[5];
    gavl_inst(name,thing,string);
    char otherjunk[5];
public:
    thing(const string& nm) { name = nm; }
};
gavl_inline(name,thing,string);


ostream& operator<<(ostream& s, const thing& t)
    { return s << (string)t.name; }


class thing_table {
    gavlroot(name,thing,string) things;
public:
    void enter(const string&);
    void dump(ostream&);
}  things;

void thing_table::enter(const string& s)
{
    thing* t = things.find(s);
    if (t) return;
    t = new thing(s);
    things.insert(t);
}

void thing_table::dump(ostream& stm)
{
    gavlinorder(name,thing,string) itr(things);
    thing* t;
    while (t = itr.next()) stm << *t NL;
}

main()
{
    string table[TSIZE];
    int i = 0;

    int line = 0;
    while (cin) {
        cin >> table[i];
#ifndef COUNT_STRING_REFS
	things.enter(table[i]);
#endif
        i++;  i %= TSIZE;
    }
#ifdef COUNT_STRING_REFS
    for (i = 0 ; i < TSIZE ; i++) 
        if ((char *)table[i]) cout << table[i] << "\n";
#else
    things.dump(cout);
#endif
    cerr << "Tree:\n";  table[0].dump();
}
