#ifndef	OOPSCONFIGH
#define	OOPSCONFIGH

/* oopsconfig.hxx -- OOPS configuration file

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

28-Feb-87	K. E. Gorlen

1.  Eliminate MAX_X_COORD and MAX_Y_COORD.

15-Jan-87	K. E. Gorlen

1.  Change machine/os identifiers to be defined/undefined.

6-Jan-87	K. E. Gorlen

1.  Correct implementation of AST_SAVE for System V.

*/

// oopsconfig.hxx -- OOPS configuration file

/* Machine Model Implementation Status:

	ATT3B		partially implemented and tested
	MASSCOMP	implemented and tested
	RTPC		partially implemented and tested
	SUN3		implemented and tested
	VAX		implemented and tested
*/

// Machine Model (only one can be defined)

//#define ATT3B
//#define MASSCOMP
//#define RTPC
#define SUN3
//#define VAX

/* Operating System Implementation Status:

	ACIS42		implemented and tested
	AIX		partially implemented and tested
	RTUATT		implemented and tested
	RTUUCB		implemented and tested
	SYSV		partially implemented, partially tested
	UCB42BSD	implemented and tested
	ULTRIX		NOT implemented, NOT tested
*/

// Operating System (only one can be defined)

//#define ACIS42
//#define AIX
//#define RTUATT
//#define RTUUCB
//#define SYSV
#define UCB42BSD
//#define ULTRIX

#if defined(ATT3B) | defined(MASSCOMP) | defined(RTPC) | defined(SUN3) | defined(VAX)

#define	LOG2_SHORT	1	/* log2(sizeof(short)) */
#define	LOG2_INT	2	/* log2(sizeof(int)) */
#define LOG2_LONG	2	/* log2(sizeof(long)) */
#define	LOG2_FLOAT	2	/* log2(sizeof(float)) */
#define	LOG2_DOUBLE	3	/* log2(sizeof(double)) */
#define	LOG2_PTR	2	/* log2(sizeof(void*)) */

const int UNINITIALIZED	=0xa5a5a5a5;	// data value to flag uninitialized variables 

// Pseudo-random number generator 
const int MAX_INT = 0x7fffffff;
inline int DRAW(long& x)	{ return (x = x*1103515245 + 12345) & MAX_INT; }

#endif

#if defined(ATT3B) | defined(MASSCOMP) | defined(VAX) | defined(RTPC) | defined(SUN3)

#define STACK_GROWS_DOWN 1

#endif

// defines for interfacing with ASTs or signals

extern int ast_level;		// AST/signal nesting level

#if defined(MASSCOMP)

extern int setpri(int);
extern int astpause(int,int);
#define	AST_DISABLE	int prior_AST_state = setpri(127)
#define AST_ENABLE	setpri(prior_AST_state)
#define	AST_STATE	setpri(-1)
#define AST_SAVE(m)	m = prior_AST_state
#define AST_RESTORE(m)	setpri(m)
#define AST_PAUSE	astpause(0,1000)
#define AST_ENTER	::ast_level++
#define AST_EXIT	::ast_level--
#define	AST_ACTIVE	(::ast_level != 0)

#endif

#if defined(UCB42BSD) | defined(ACIS42)

extern int sigblock(int);
extern void sigpause(int);
extern int sigsetmask(int);
#define	AST_DISABLE	int prior_AST_state = sigblock(0xFFFFFFFF)
#define AST_ENABLE	sigsetmask(prior_AST_state)
#define	AST_STATE	sigblock(0)
#define AST_SAVE(m)	m = prior_AST_state
#define	AST_RESTORE(m)	sigsetmask(m)
#define	AST_PAUSE	sigpause(0)
#define AST_ENTER	::ast_level++
#define AST_EXIT	::ast_level--
#define	AST_ACTIVE	(::ast_level != 0)

#endif

#if defined(SYSV)

// Signals do not queue under System V, so they are unusable

#define	AST_DISABLE
#define AST_ENABLE
#define	AST_STATE	0
#define AST_SAVE(m)
#define	AST_RESTORE(m)
#define	AST_PAUSE
#define AST_ENTER	::ast_level++
#define AST_EXIT	::ast_level--
#define	AST_ACTIVE	(::ast_level != 0)

#endif

#if defined(RTUUCB) | (defined(UCB42BSD) & !defined(SUN3)) | defined(ACIS42)
#define strchr(s,c) index(s,c)
#define strrchr(s,c) rindex(s,c)
#endif

#endif
