#ifndef STACKH
#define STACKH

/* Stack.hxx -- declarations for class Stack

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "OrderedCltn.hxx"

extern Class class_Stack;

class Stack : public SeqCltn {
	OrderedCltn contents;
public:
	Stack(UNSIGNED size =CLTN_DEFAULT_CAPACITY) : contents(size) {}
	Stack(const Stack& s) : contents(*((OrderedCltn*)&s)) {}
	Stack(fileDescTy&,Stack&);
	Stack(istream&,Stack&);
	bool operator==(const Stack& s)
		{ return contents == ((Stack*)&s)->contents; }
	bool operator!=(const Stack& s)	{ return !(*this==s); }
	void operator=(const Stack& s)	{ contents = ((Stack*)&s)->contents; }
	obid& operator[](int i)		{ return contents.at(size()-i-1); }
	void push(const Object& ob)	{ contents.addLast(ob); }
	obid pop()			{ return contents.removeLast(); }
	obid top()			{ return contents.last(); }
	virtual obid add(const Object& ob);
	virtual Collection& addContentsTo(Collection& cltn);
	virtual obid& at(int i);
	virtual UNSIGNED capacity();
	virtual void deepenShallowCopy();
	virtual UNSIGNED hash();
	virtual const Class* isA();
	virtual bool isEmpty();
	virtual bool isEqual(const Object& ob);
	virtual obid last();
	virtual void printOn(ostream& strm);
	virtual void reSize(UNSIGNED newSize);
	virtual obid removeLast();
	virtual UNSIGNED size();
	virtual const Class* species();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
};

#endif
