#ifndef SHELLREGEXPH
#define SHELLREGEXPH
/*
 *  SHELLREGEXP - Process shell regular expressions
 *  
 *  example of usage:
 *
 *  ShellRegExp regexp("*");
 *  if (regexp.Match("./abc")) {
 *      ...
 *  }
 */

extern String MATCHALL;

class ShellRegExp : public RegExp {
    String trShellExp(const String&);
public:
    ShellRegExp() {};
    ShellRegExp(const String& pat) {
	RegExp::Pattern(trShellExp(pat));
    }
    ShellRegExp(const ShellRegExp& SRE) : (SRE) {}
    ShellRegExp(fileDescTy&, ShellRegExp&);
    ShellRegExp(istream&, ShellRegExp&);

    virtual const Class* isA();
    void operator=(const ShellRegExp&);
    bool operator==(const ShellRegExp&);
    void storer(ostream &strm);
    void storer(fileDescTy &fd);
    virtual bool isEqual(const Object&);

    virtual void Pattern(const String& regexp) {
	RegExp::Pattern(trShellExp(regexp));
    }

    virtual const String& Pattern() {
	return RegExp::Pattern();
    }

    void ReloadPattern(const String& Pat) {RegExp::Pattern(Pat);}
    
};

#endif

