/* SeqCltn.c -- implementation of abstract sequential collections

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	September, 1985

Function:
	
SeqCltn is an abstract class representing collections whose elements are
ordered and are externally named by integer indices.

Modification History:

06-Oct-86	S. M. Orlow

1.  Added binary I/O constructor, storer, and reader functions

*/

#include "SeqCltn.hxx"

#define	THIS	SeqCltn
#define	BASE	Collection
DEFINE_CLASS(SeqCltn,Collection,1,NULL,NULL);

extern const int OOPS_RDABSTCLASS;

obid& SeqCltn::at(int)
	{ derivedClassResponsibility("at"); }
	
void SeqCltn::atAllPut(const Object&)
	{ derivedClassResponsibility("atAllPut"); }

void SeqCltn::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
}

obid SeqCltn::first()
	{ derivedClassResponsibility("first"); return 0; }
	
int SeqCltn::indexOf(const Object&)
	{ derivedClassResponsibility("indexOf"); return 0; }
	
int SeqCltn::indexOfSubCollection(const SeqCltn& /*cltn*/, int /*start*/)
	{ derivedClassResponsibility("indexOfSubCollection"); return 0; }
	
obid SeqCltn::last()
	{ derivedClassResponsibility("last"); return 0; }

obid SeqCltn::doNext(DoCltnPos& pos)
{
	if (pos.index < size()) return at(pos.index++);
	return 0;
}

void SeqCltn::replaceFrom(int /*start*/, int /*stop*/, const SeqCltn& /*replacement*/, int /*startAt*/)
	{ derivedClassResponsibility("replaceFrom"); }
