/* Semaphore.c -- implementation of Semaphore

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	December, 1985

Function:

Objects of class Semaphore are used to synchronize Processes.

Modification History:

06-Oct-86	S. M. Orlow

1.  Added binary I/O constructor, storer, and reader functions

29-Apr-86	K. E. Gorlen

1.  Eliminate copy().
2.  Implement shallowCopy() as shouldNotImplement.

5-Mar-86	K. E. Gorlen

1.  Redefine copy() as deepCopy().

*/

#include "Semaphore.hxx"
#include "Process.hxx"
#include "Scheduler.hxx"
#include "oopsIO.hxx"

#define	THIS	Semaphore
#define	BASE	Object
DEFINE_CLASS(Semaphore,Object,1,NULL,NULL);

extern const int OOPS_ASTBLK,OOPS_DLSEMWAIT,OOPS_CPSEMWAIT,OOPS_STSEMWAIT;

void Semaphore::signal()
{
	AST_DISABLE;
		register Process* next;
		while (count++ < 0) {
			next = (Process*)waitList.removeFirst();
			if (next->state() != TERMINATED) {
				next->resume();
				break;
			}
		}
	AST_ENABLE;
}

void Semaphore::wait()
{
	AST_DISABLE;
		if (--count < 0) {
			if (AST_ACTIVE) setOOPSerror(OOPS_ASTBLK,DEFAULT,this,className(),"wait");
			activeProcess().suspend();
			waitList.addLast(activeProcess());
		}
	AST_ENABLE;
	if (count < 0) schedule();
}

Semaphore::~Semaphore()
{
	if (count<0) setOOPSerror(OOPS_DLSEMWAIT,DEFAULT,-count,this,className());
}

void Semaphore::deepenShallowCopy()
{
	if (count < 0) setOOPSerror(OOPS_CPSEMWAIT,DEFAULT,-count,this,className());
	BASE::deepenShallowCopy();
}

UNSIGNED Semaphore::hash()	{ return (UNSIGNED)this; }

bool Semaphore::isEqual(const const Object& ob)	{ return isSame(ob); }

void Semaphore::printOn(ostream& strm)
{
	strm << className() << "  count: " << count << "\n";
	DO(waitList,Process*,p) strm << "\t" << *p; OD
}

obid Semaphore::shallowCopy()	{ shouldNotImplement("shallowCopy"); return 0; }

int Semaphore::value()		{ return count; }

Semaphore::Semaphore(istream& strm, Semaphore& where)
{
	this = &where;
	strm >> count;
}

void Semaphore::storer(ostream& strm)
{
	if (count < 0) setOOPSerror(OOPS_STSEMWAIT,DEFAULT,-count,this,className());
	BASE::storer(strm);
	strm << count << " ";
}

Semaphore::Semaphore(fileDescTy& fd, Semaphore& where)
{
	this = &where;
	readBin(fd,count);
}

void Semaphore::storer(fileDescTy& fd) 
{
	if ( count < 0 )
		setOOPSerror(OOPS_STSEMWAIT,DEFAULT,-count,this,className());
	BASE::storer(fd);
	storeBin(fd,count);
}
