#ifndef ORDEREDCLTNH
#define ORDEREDCLTNH

/* OrderedCltn.hxx -- declarations for abstract ordered collections

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "SeqCltn.hxx"
#include "Arrayobid.hxx"

extern Class class_OrderedCltn;
class SortedCltn;

class OrderedCltn : public SeqCltn {
	int endIndex;
	Arrayobid contents;
	obid addAtIndex(int i, const Object& ob);
	void errEmpty(const char* fn);
	void errNotFound(const char* fn, const Object& ob);
	obid removeAtIndex(int i);
	friend SortedCltn;
public:
	OrderedCltn(UNSIGNED size =CLTN_DEFAULT_CAPACITY);
	OrderedCltn(const OrderedCltn&);
	OrderedCltn(fileDescTy&,OrderedCltn&);
	OrderedCltn(istream&,OrderedCltn&);
	bool operator!=(const OrderedCltn& a)	{ return !(*this==a); }
	void operator=(const OrderedCltn&);
	bool operator==(const OrderedCltn&);
	OrderedCltn operator&(const SeqCltn& cltn);	// concatenation operator 
	void operator&=(const SeqCltn& cltn);
	virtual obid add(const Object&);
	virtual obid addAfter(const Object& ob, const Object& newob);
	virtual obid addAllLast(const OrderedCltn&);
	virtual obid addBefore(const Object& ob, const Object& newob);
	virtual Collection& addContentsTo(Collection& cltn);
	virtual obid addLast(const Object& ob);
	virtual obid after(const Object&);
	virtual obid& at(int i);
	virtual void atAllPut(const Object& ob);
	virtual obid before(const Object&);
	virtual UNSIGNED capacity();
	virtual void deepenShallowCopy();
	virtual obid first();
	virtual UNSIGNED hash();
 	virtual int indexOf(const Object& ob);
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0);
	virtual const Class* isA();
	virtual bool isEmpty();
	virtual bool isEqual(const Object&);
	virtual obid last();
	virtual UNSIGNED occurrencesOf(const Object&);
	virtual void printOn(ostream& strm);
	virtual obid remove(const Object&);
	virtual obid removeId(const Object&);
	virtual obid removeLast();
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0);
	virtual void reSize(UNSIGNED newSize);
	virtual UNSIGNED size();
	virtual void sort();
	virtual const Class* species();
};

#endif
