/* Nil.c -- implementation of the nil object

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	September, 1985

Function:
	
Declarations and member functions for the nil object.

Modification History:

06-Oct-86	S. M. Orlow

1.  Added binary I/O constructor, storer, and reader functions

*/

#include "Object.hxx"

extern Class class_Nil;

class Nil : public Object {
public:	
	Nil() {}
	Nil(fileDescTy&,Nil&) {}
	Nil(istream&,Nil&) {}
	virtual int compare(const Object&);	// compare objects 
	virtual obid copy();			// copy returns nil 
	virtual obid deepCopy();		// copy returns nil 
	virtual UNSIGNED hash();		// calculate object hash 
	virtual const Class* isA();
	virtual bool isEqual(const Object&);	// equality test 
	virtual void printOn(ostream& strm);
	virtual obid shallowCopy();		// copy returns nil 
	virtual void storer(ostream&);		// shouldNotImplement 
	virtual void storer(fileDescTy&);	// shouldNotImplement 
};

#define	THIS	Nil
#define	BASE	Object
DEFINE_CLASS(Nil,Object,1,NULL,NULL);
static Nil nil_object;				// the nil object 
extern const obid const nil = (obid)&nil_object; // pointer to the nil object 

bool Nil::isEqual(const Object& ob) {	return (&ob==nil); }

UNSIGNED Nil::hash() { return 0; }

int Nil::compare(const Object& ob)
{
	assertArgSpecies(ob,class_Nil,"compare");
	return 0;
}

obid Nil::copy() { return nil; }

obid Nil::shallowCopy() { return nil; }

obid Nil::deepCopy() { return nil; }

void Nil::printOn(ostream& strm) { strm << "NIL"; }

void Nil::storer(ostream&)
/*
The Nil object is always implicitly stored as object number zero; all
references to nil are stored as @0.
*/
{
	shouldNotImplement("storer");
}

void Nil::storer(fileDescTy&)
{
	shouldNotImplement("storer");
}
