#ifndef FLOATH
#define FLOATH 

/* Float.hxx -- declarations for Float object

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Object.hxx"

extern Class class_Float;

class Float: public Object {
	double val;
	void parseFloat(istream& strm)	{ strm >> val; }
public:
	Float(double v =0)		{ val = v; }
	Float(fileDescTy&,Float&);
	Float(istream&);
	Float(istream&,Float&);
	double value()			{ return val; }
	double value(double newval)	{ return val = newval; }
	virtual int compare(const Object&);
	virtual obid	copy();			// { return shallowCopy(); }
	virtual void	deepenShallowCopy();	// {}
	virtual UNSIGNED hash();
	virtual const Class* isA();
	virtual bool isEqual(const Object&);
	virtual void printOn(ostream& strm);
	virtual void scanFrom(istream& strm);
	virtual const Class* species();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
};

#endif
