#ifndef COLLECTIONH
#define COLLECTIONH

/* Collection.hxx -- declarations for abstract Collection class

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

30-Jun-87	K. E. Gorlen

1. Made Collection::Collection constructor protected since Collection is an
abstract class.

*/

#include "Object.hxx"

const UNSIGNED CLTN_DEFAULT_CAPACITY	= 16;	// default initial collection capacity 
const UNSIGNED CLTN_EXPANSION_INCREMENT = 32;	// collection (OrderedCltn) expansion increment 
const UNSIGNED CLTN_EXPANSION_FACTOR = 2;	// collection (Set,Bag,Dictionary) expansion factor 

#define DO(cltn,cls,arg)\
{ register cls arg; DoCltnPos DO_pos; while (arg = (cls)((cltn).doNext(DO_pos))) {
#define OD }}

struct DoCltnPos {		/* Collection position for the DO macro */
	int	index;	// used by most Collections 
	void*	ptr;	// used by LinkedLists 
	UNSIGNED num;	// used by Bags 
	DoCltnPos()	{ index = num = 0; ptr = 0; }
};

extern Class class_Collection;

class Arrayobid;
class Bag;
class Heap;
class OrderedCltn;
class Set;
class SortedCltn;
class CollectionEnu;

class Collection: public Object {	// abstract class 
protected:
	Collection() {}
public:
	Collection(fileDescTy&,Collection&) {}
	Collection(istream&,Collection&) {}
	Arrayobid	asArrayobid();
	Bag		asBag();
	Heap		asHeap();
	OrderedCltn	asOrderedCltn();
	Set		asSet();
	SortedCltn	asSortedCltn();
	virtual	obid		add(const Object&);
	virtual const Collection& addAll(const Collection&);
	virtual Collection&	addContentsTo(Collection&);
	virtual void		deepenShallowCopy();
	virtual	obid		doNext(DoCltnPos& pos);
	virtual bool		includes(const Object&);
	virtual const Class*	isA();
	virtual bool		isEmpty();
	virtual UNSIGNED	occurrencesOf(const Object&);
	virtual obid		remove(const Object&);
	virtual const Collection& removeAll(const Collection&);
	virtual obid		shallowCopy();		// shouldNotImplement
	virtual UNSIGNED	size();
	virtual void		storer(fileDescTy&);
	virtual void		storer(ostream&);
	CollectionEnu		*newEnu();
};

class CollectionEnu: public Object {
    friend Collection;
    const Collection  *Coll;
    DoCltnPos	Do;
protected:
			CollectionEnu(fileDescTy&, CollectionEnu&){}
			CollectionEnu(istream&, CollectionEnu&){}
    			CollectionEnu(const Collection *C) {Coll = C;}
    virtual const Class *isA();
    virtual obid	next() {return Coll->doNext(Do);}
public:
    obid		Next(){return next();};
};

#endif
