#ifndef ARRAYOBIDH
#define ARRAYOBIDH

/* Arrayobid.hxx -- declarations for array of object pointers (object IDs)

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Collection.hxx"

extern Class class_Arrayobid;

class Arrayobid: public Collection {
	obid* v;
	UNSIGNED sz;
	void AllocSizeErr();
	void IndexRangeErr();
public:
	Arrayobid(UNSIGNED size =CLTN_DEFAULT_CAPACITY);
	Arrayobid(const Arrayobid&);
	~Arrayobid()		{ delete v; }
	Arrayobid(fileDescTy&,Arrayobid&);
	Arrayobid(istream&,Arrayobid&);
	obid& elem(int i)	{ return v[i]; }
	bool operator!=(const Arrayobid& a)	{ return !(*this==a); }
	void operator=(const Arrayobid&);
	bool operator==(const Arrayobid&);
	obid& operator[](int i) {
		if ((unsigned)i >= sz) IndexRangeErr();
		return v[i];
	}
	virtual Collection& addContentsTo(Collection&);
	virtual obid& at(int i);
	virtual UNSIGNED capacity();
	virtual void deepenShallowCopy();
	virtual obid doNext(DoCltnPos&);
	virtual UNSIGNED hash();
	virtual const Class* isA();
	virtual bool isEqual(const Object&);
	virtual void printOn(ostream& strm);
	virtual void reSize(UNSIGNED);
	virtual UNSIGNED size();
	virtual void sort();
	virtual const Class* species();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
	virtual void clearForReadFrom();
};

#endif
