#include <ctype.h>
#include <memory.h>
#include <string.h>
#include <stdio.h>
#include "GrowingBuf.h"
#define THIS GrowingBuf

#define INITIAL 64
#define UNREASONABLE 16383


THIS::~THIS() 
{ 
    int buf_size = ++end - buf;
    if (h) {
	h->memfree(buf, buf_size);
	if (allocated) {
	    h->memfree(this, sizeof(THIS));
	    this = 0;
	}
    }
    else delete[buf_size] buf;
}


THIS::THIS(heap& hp)
{
    boolean alloc = !this;
    this = this ? this : (THIS*)hp.mem(sizeof(THIS));
    h = &hp;  allocated = alloc;
    buf = (char*)h->mem(INITIAL);

    end = buf + INITIAL - 1; // Always leave room for trailing 0
    pos = buf;
};


THIS::THIS()
{
    h = 0;  allocated = FALSE;
    buf = new char[INITIAL];

    end = buf + INITIAL - 1; // Always leave room for trailing 0
    pos = buf;
};


void THIS::grow(unsigned minimum)
{
    int size = ++end - buf;
    minimum += size;
    if (minimum > UNREASONABLE) fault("Can't grow buffer any larger");

    unsigned newsize = size * 2;
    while (newsize < minimum) newsize *= 2;

    unsigned offset = pos - buf;

    if (h)
	buf = (char*)h->rmem(buf, size, newsize);
    else {
	char* oldbuf = buf;
	buf = new char[newsize];
	memcpy(buf, oldbuf, size);
	delete[size] oldbuf;
    }
    end = buf + newsize - 1;
    pos = buf + offset;
}


THIS& THIS::operator<<(char* s)
{
    if (!s) return *this;
    unsigned size = strlen(s);
    if (end - pos < size) grow(size - (end - pos));
    while (*s) *pos++ = *s++;
    return *this;
}


THIS& THIS::operator<<(long i)
{
    char b[32];
    sprintf(b, "%d", i);
    return *this << b;
}


void THIS::uppercase()
{
    register char* p;
    for (p = buf; p < pos; p++) if islower(*p) *p = toupper(*p);
}


void THIS::lowercase()
{
    register char* p;
    for (p = buf; p < pos; p++) if isupper(*p) *p = tolower(*p);
}
