;	title	'REL-LIST version 0.1'
;
;
;	Program to list modules from
;	a microsoft library
;
;	See Microsoft 'linking loader' manual
;	for more information on .rel files
;
;	based on RELDUMP, also by me
;
;	Requires Digital Research 'MAC'
;	assembler, or alternatively, you
;	can expand the macros and use
;	the cp/m assembler 'asm'.
;
;
;	03/02/81	by Ron Fowler
;			   Westland, Mich.
;
cr	equ	13
lf	equ	10
bdos	equ	5
fcb	equ	5ch
buf	equ	80h
;
cifnc	equ	1
prtchr	equ	2
printf	equ	9
cstsf	equ	11
openf	equ	15
readf	equ	20
;
;	define some macros
;
pchar	macro	x
	if not nul x
	mvi	a,x
	endif
	call	outchr
	endm
;
print	macro	string
	local	overstring
	call	overstring
	db	string
overstring:
	pop	d
	mvi	c,printf
	call	bdos
	endm
;
bits	macro	num
	mvi	b,num
	call	getbits
	endm
	page
;
;	get local stack and
;	set up fcb
;
	ORG	100H
;
base:	lxi	sp,stack
	lda	fcb+9	;look at filetype
	cpi	' '	;see if type specified
	jnz	sk1	;jmp if so
	lxi	h,'RE'	;part of 'REl'
	shld	fcb+9	;store into fcb
	mvi	a,'L'	;rest of 'reL'
	sta	fcb+11
sk1:	mvi	c,openf ;open the .rel file
	lxi	d,fcb
	call	bdos
	cpi	0ffh	;should not be
	jnz	main	;jump if not
	call	msgxit	;else say can't find
	db	'File not found.$'
	page
;
;	main work loop
;
main:	mvi	c,cstsf
	call	bdos
	ora	a
	jz	main1
	mvi	c,cifnc
	call	bdos
	cpi	'C'-40h
	jnz	main1
	jmp	endfil
main1:	bits	1	;get item type
	ora	a
	jnz	dorel	;jump if a rel type
	bits	8	;it's absolute,get byte
	jmp	main	;and ignore it
;
dorel:	bits	2	;get 2 bit adrs type
	ora	a	;check for "special"
	jz	dospl	;jump if so
	bits	8	;just normal word, get
	bits	8	;  past it then
	jmp	main	;  go to next
;
;	"special" type rel field...this is
;	where all the goodies are
;
dospl:	bits	4	;get 4 bit control field
	mov	l,a	;make 16 bit word
	mvi	h,0
	lxi	d,jmptbl ;now do table offset
	dad	h	;adjust for word entries
	dad	d	;add in offset
	mov	e,m	;pull address out of tbl
	inx	h
	mov	d,m
	xchg		;jump address in hl
	lxi	d,main	;first set up a return
	push	d	;  to main
	pchl		;then go
;
;	table of handlers for "special"
;	rel items
;
jmptbl: dw	entsym,selcom,prgnam,reqsrc
	dw	extlnk,comsiz,chnext,defent
	dw	xmoff,xpoff,defdat,setloc
	dw	chnadr,prgsiz,endprg,endfil
;
;	for entry symbols and select common,
;	these handlers do nothing but skip
;	past the "B" field
;
entsym: call	bfield
	ret
selcom: call	bfield
	ret
;
;	define program name
;
prgnam: call	bfield
	call	crlf
	print	'Module name:  $'
	call	symprt
	call	crlf		;make new line
	ret
;
;	request library search and external
;	link do nothing except skip past b field
;
reqsrc: call	bfield
	mvi	a,1	;flag extended link item
	sta	xlink
	ret
extlnk: call	bfield
	mvi	a,1
	sta	xlink
	ret
;
;	common-size handler does
;	nothing except skip a and b fields
;
comsiz: call	afield
	call	bfield
	ret
;
;	chain-external handler takes care
;	of printing the external references
;
chnext: lda	extflg	;been here before?
	ora	a
	jnz	cxt1	;jump if so
	call	crlf
	call	crlf	;roll up two lines
	print	'External References:$'
	call	crlf
	call	crlf
	xra	a	;show 0 symbol count
	sta	symcnt
	sta	entflg	;and no internal refs
	inr	a	;show doing externals
	sta	extflg
cxt1:	call	afield	;get a field
	call	bfield	;then b, which is name
	call	symprt
	print	'   $'	;leave margin between names
	lda	symcnt	;bump symbol count
	inr	a
	cpi	4	;4 symbols per line
	jc	cxt2
	call	crlf	;roll up new line
	xra	a	;no symbols yet on new
cxt2:	sta	symcnt	;update symbol count
	ret
;
;	this routine handles entry symbols
;
defent: lda	entflg	;been here before?
	ora	a
	jnz	cxt1	;if so, same as externals
	call	crlf
	call	crlf
	print	'Entry Points:$'
	call	crlf
	call	crlf
	xra	a	;show no symbols yet
	sta	symcnt
	sta	extflg	;show not doing externals
	inr	a	;show doing entrys
	sta	entflg
	jmp	cxt1	;now just like externals
;
;	external - offset and external + offset
;	do nothing except advance past a field
;
xmoff:	call	afield
	mvi	a,1
	sta	xlink
	ret
xpoff:	call	afield
	ret
;
;	define size of data area
;
defdat: call	crlf
	print	'Size of data area: $'
prtsiz: call	afield	;get the size
	lhld	avalue
	call	hex16	;now print it
	pchar	'H'
	call	crlf
	ret
;
;	set loc counter and chain address
;	do nothing except advance past
;	the a field
;
setloc: call	afield
	ret
chnadr: call	afield
	ret
;
;	define size of program
;
prgsiz: call	crlf
	print	'Size of prg  area: $'
	jmp	prtsiz	;now just like data size
;
;	end of module
;
endprg: call	afield
	call	refill	;make byte boundary
endx:	xra	a
	sta	entflg	;turn off entry pts flag
	sta	extflg	;and externals
formf:	call	crlf	;turn up new page
	lda	lincnt
	cpi	3	;to line 3
	jnz	formf
	ret
;
;	end of file, exit to cpm
;
endfil: print	'Done$'
	call	endx
	print	'Special extension flag:  $'
	lda	xlink
	adi	30h
	pchar
	call	crlf
	jmp	0
;*************************
;*     subroutines	 *
;*************************
;
;	get "A" field from input stream
;
afield: bits	2
	sta	atype	;get a field type
	bits	8
	sta	avalue	;ls byte of value
	bits	8
	sta	avalue+1 ;ms byte
	ret
;
;	get "B" field from input stream
;
bfield: lxi	h,symbuf ;first clear symbol buffer
	mvi	b,7	;length of 7 chars
bclr:	mvi	m,' '
	inx	h
	dcr	b
	jnz	bclr
	bits	3	;now get symbol length
	mov	e,a	;in e for a counter
	lxi	h,symbuf
bfil:	mov	a,e	;test for end of symbol
	ora	a
	rz
	bits	8	;get next char of symbol
	mov	m,a	;put in buffer
	inx	h
	dcr	e
	jmp	bfil
;
;	print hl in hex
;
hex16:	mov	a,h
	call	hexout
	mov	a,l
	call	hexout
	ret

;
;
;	get number of bits from
;	input stream as in b reg
;
getbits: 
	push	h
	push	d
	xra	a	;zero our byte
bitlop: call	nxtbit	;next bit into cy flg
	ral		;shift into our byte
	dcr	b	;count down
	jnz	bitlop
	pop	d
	pop	h
	ret
;
;	get next bit from input stream
;
nxtbit: push	b
	mov	b,a	;can't alter a
	lda	bitcnt	;any left this byte?
	ora	a
	cz	refill	;get another if not
	dcr	a
	sta	bitcnt	;update for nxt time
	lda	char	;current byte
	ral		;bit into cy
	sta	char
	mov	a,b	;restore accumulator
	pop	b
	ret
;
;	get the next byte from input buffer
;
refill: push	b
	lda	bufptr
	cpi	80h	;see if buf empty
	cz	diskrd	;fill if so
	mov	l,a
	mvi	h,0	;form 16 bits
	inr	a	;update buf pntr
	sta	bufptr
	lxi	d,buf
	dad	d	;point into buffer
	mov	a,m	;reach in and get byte
	sta	char	;save it
	mvi	a,8	;new bit count
	sta	bitcnt
	pop	b
	ret
;
;	read next sector from file
;
diskrd: mvi	c,readf
	lxi	d,fcb
	call	bdos
	cpi	0ffh	;should not be..
	mvi	a,0	;..early eof
	rnz
	call	msgxit	;oops!
	db	'??? Unexpected end of file.$'
;
;	print message pointed
;	to by tos then exit
;
msgxit: pop	d
	mvi	c,printf
	call	bdos
	jmp	endfil
crlf:	mvi	a,cr
	call	outx
	mvi	a,lf
	call	outx
	lda	lincnt
	inr	a
	sta	lincnt
	cpi	61	;lines/page
	rnz
	mvi	b,6	;lines to nxt page
formfd: mvi	a,lf
	call	outx	;<<<
	dcr	b
	jnz	formfd
	mvi	a,1	;say first line
	sta	lincnt
	ret
hexout: push	psw
	rar
	rar
	rar
	rar
	call	nybble
	pop	psw
nybble: ani	0fh
	cpi	10
	jc	xnum
	adi	7
xnum:	adi	'0'
	pchar
	ret
	page
;
;	print char in a (called from
;	macros only).
;
outchr: cpi	' '	;check for printable..
	jnc	chka	;..characters, make...
fix:	mvi	a,'.'	;...non-printing chars....
chka:	cpi	7fh	;....dots
	jnc	fix
outx:	push	h
	push	d
	push	b
	mvi	c,prtchr
	mov	e,a
	call	bdos
	lxi	h,chrpos
	inr	m	;increment line pos
	pop	b
	pop	d
	pop	h
	ret
;
;	print symbol in symbol buffer
;
symprt: lxi	h,symbuf
	mvi	b,7
splp:	mov	a,m
	inx	h
	pchar
	dcr	b
	jnz	splp
	ret
	page
;
;	variables
;
atype:	db	0	;"A" field type
avalue: dw	0	;"A" field value
symbuf: db	'       '      ;buffer for symbols
	db	'$'	;for printing
bufptr: db	80h	;force initial read
bitcnt: db	0	;and empty char
char:	db	0
ctrlfld: db	0
lincnt: db	1	;start paper at line 1
relflg: db	0
	db	0
chrpos: db	0	;line position
extflg: db	0	;'printing externals' flag
entflg: db	0	;'printing entry pts' flag
symcnt: db	0	;symbol count
xlink:	db	0	;flag for extended link feature
	ds	50	;stack space
stack:			;stk ptr save
	end
g
symcnt: db	0	;symbol count
xlink: