The entry point definition given above showed an example
declare statement for each assembly language routine. The
following small file called "PLIBITS.DCL" is a one statement
declare file that is put into the users PL/I-80 program with a
statement like:

       %include 'PLIBITS.DCL';

This prevents the programmer from having to retype the
declared entry point definition each time the functions of
PLIBITS is desired. It also saves mistakes.

       /* enhanced bit operation performance subroutine
          entry point definition                       */
       dcl
	       rtrot	entry (bit(16), bin fixed(7))
			returns (bit(16)),
               lfrot    entry (bit(16), bin fixed(7))
			returns (bit(16)),
               rtsft	entry (bit(16), bin fixed(7))
			returns (bit(16)),
	       lfsft	entry (bit(16), bin fixed(7))
			returns (bit(16)),
	       bitand	entry (bit(16), bit(16))
			returns (bit(16)),
	       bitor	entry (bit(16), bit(16))
			returns (bit(16)),   
	       bitxor	entry (bit(16), bit(16))
			returns (bit(16)),
	       bitasc	entry (bit(16))
			 returns (char(1)),
	       ascbit	entry (char(1))
			returns (bit(16));
