	name	'PLIBIOS'
	title	'Direct CP/M BIOS Vector Calls from PL/I-80'
;
;
;***********************************************************
;
;*          bios direct calls from pl/i for direct i/o     *
;
;***********************************************************
;
	public	cboot	;cold boot reload of cp/m entry
	public  wboot	;warm boot reload of ccp
	public	cstat	;return byte for console status
	public	conin	;return character input from console
	public	conout	;write character to console
	public  list	;write character to list device
	public	punch	;write character to punch device
	public  reader	;return character input from reader
	public  home	;home selected disk unit
	public  seldsk	;select disk unit and return
			;parameter table pointer
	public	settrk	;select track
	public  setsec  ;select sector number
	public  setdma  ;set disk i/o data buffer pointer
	public  read	;read selected sector and return status
	public  write   ;write selected sector and return status
	public  lstat	;return byte for console status
	public  sectran ;translate sector number
;
;
;Bios vector table offsets from the warm boot vector
;to access the vector table entry points off the
;loc 1 & 2 warm boot vector
;
cbooto	equ	-3	;cold boot offset
wbooto	equ	0	;warm boot offset
cstato	equ	3	;console status offset
conino	equ	6	;console input offset
conouto equ	9	;console output offset
listo	equ	12	;list device output offset
puncho	equ	15	;punch device offset
readero	equ	18	;reader device offset
homeo	equ	21	;disk home offset
seldsko	equ     24	;select disk offset
settrko	equ	27	;select disk offset
setseco	equ	30	;select sector offset
setdmao equ	33	;set dma address offset
reado	equ 	36	;read logical sector offset
writeo	equ	39	;write logical sector offset
lstato	equ	42	;list status offset
strano	equ	45	;sector translate offset
;
;
;Define position of CP/M 2.2 warm boot vector location
;
wbvect	equ	0	;addr of warm boot jump
;
;
;**********************************************************
;
;*         general purpose routines used upon entry       *
;
;**********************************************************
;
;
;get single byte parameter to register c
;
getp1:
	mov	e,m	;low (addr)
	inx	h	
	mov	d,m	;high(addr)
	xchg		;hl = .char
	mov	c,m	;to register c
	ret
;
;
;get single word value to BC
;
getp2:
	call	getp1	;get low byte of
	inx	h	;parameter
	mov	b,m     ;get high byte also
	ret
;
;
;transfer ctrl to indexed bios vector table entry
;enter with DE = entry offset index
;
gobios:
	lhid	wbvect+1  ;get cp/m warm boot vector
	dad	d         ;add in vector table offset
	pchl	          ;go to table entry
;
;
;
;*********************************************************
;
;direct bios access routines for pl/i-80 calls           *
;
;*********************************************************
;
;
;
;routine to enter bios cold boot to completely
;reload cp/m
cboot:
	lxi	d,cbooto  ;get offset
	jmp     gobios    ;on our way
;
;
;routine to enter bios warm boot to reload
;ccp and bdos
;
wboot:
	lxi	d,wbooto  ;get offset
	jmp	gobios    ;go reload
;
;
;routine to return console status byte
;return byte value to stack
;
cstat:
	lxi	d,cstato  ;status offset
	jmp     gobios    ;return bit(8) in (a)
;                         ;from bios
;
;routine to get character from the console
;for input
;
conin:
	lxi	d,conino  ;conin offset
;
ret1chr:			;entry pt for 1 character
				;return to pl/1-80 on stac	
       	call	gobios		;go get the status to (a)
	pop	h		;return address
	push	psw		;character to stack
	inx	sp		;delete flags
	mvi	a,1		;character length is 1
	pchl			;back to calling routine
;
;
;routine to output one character to the console
;
conout:
	call	getp1	 ;get single output char to (c)
	lxi	d,conouto;console output offset
	jmp	gobios   ;return to pl/1 direct from bios
;
;
;routine to output one character to the list device
;
list:
	call	getp1	;get single output char to (c)
	lxi	d,listo ;list output offset
	jmp	gobios	;return to pl/i direct from bios
;
;
;output routine to send one character to the punch
;
punch:
	call	getp1	;get single output char to (c)
	lxi	d,puncho;punch output offset
	jmp	gobios	;return to pl/i direct
			;from bios
;
;
;routine to get character from the reader for input
;
reader:
	lxi	d,readero;reader input offset
	jmp	ret1chr  ;let common code do rest
;
;
;routine to get list device status
;
lstat:
	lxi	d,lstato ;list status offset
	jmp	gobios   ;return bit(8) status
			 ;in (a) from bios
;
;
;home selected disk entry point
;
home:
	lxi	d,homeo	;home offset
	jmp	gobios	;return direct from bios
;
;
;entry point to select disk and return parameter
;table pointer for selected drive in (hl)
;
seldsk:
	call	getp1    ;get single byte drv select byte
	lxi	d,seldsko;select disk offset
	jmp	gobios	 ;return addr pointer
			 ;in (hl) from bios
;
;
;routine to send double byte track number to bios
;
settrk:
	call	getp2	 ;get track number to (bc)
	lxi	d,settrko;set track offset
	jmp	gobios	 ;return through bios
;
;
;routine to send double byte sector number to bios
;
setsec:
	call	getp2	 ;get sector number to (bc)
	lxi	d,setseco;set sector offset
	jmp	gobios	 ;return through bios
;
;
;routine to send data buffer pointer to bios
;
setdma:
	call	getp2	 ;get dma address to (bc)
	lxi	d,setdmao;setdma offset
	jmp	gobios   ;return through bios
;
;
;sector translate routine.
;
sectran:
	call	getp2	;get logsec to (bc)
	lxi	d,strano;sectran offset
	jmp	gobios  ;return through bios
;
;
;routine to read sector of 128 bytes
;
read:
	lxi	d,reado	;read sector offset
	jmp	gobios  ;return error status
			;through bios
;
;
;write sector routine. entry parameter of write type
;
write:
	call	getp1	;get write type to (c)
	lxi	d,writeo;write sector offset
	jmp 	gobios	;return error status
			;through bios
;
;
;+++...end of file
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                