                         Listing 1
;*********************************************************************
;  MICRO RESOURCES ASSEMBLY LANGUAGE PARAMETER SECTOR ACCESS PROGRAM
;*********************************************************************
;
;        This module of software is a small program that is to
;        be linked to the base of an application or PL/I-80
;        program. This module contains entry points that:
;
;        a)Read in the present contents of the first 128 bytes
;          of a file named as determined below. Buffer is in this
;          module.
;
;        b)Write out the present contents of the local 128 byte
;          buffer to the first sector of the file name defined
;          below.
;
;        c)Copy last 125 bytes of the buffer to an area of memory
;          pointed to by the entry pointer.
;
;        d)Copy 125 bytes from some area of memory to the buffer
;          pointed to by the entry pointer.
;
;       Written by:
;       Michael J. Karas
;       Micro Resources
;       2468 Hansen Court
;       Simi Valley, CA  93065
;       (805) 527-7922
;
**********************************************************************
;
;
;
;system interface equates for file i/o and error message printing
;
bdos	equ	0005h	;file manager entry point
print	equ	9	;print string function
open	equ	15	;open file function
readr	equ	20	;read record function
writer  equ     21      ;write record function
stdma	equ 	26	;set data buffer addr
;
	name	'parm'
	title	'parameter sector access mechanism for pl/I-80'
;
;
;define public entry points for the functions in this module
;
	public	rdbase	;entry to read first sector of file          
	public  wrbase	;entry to write first sector of file
	public  getparm ;entry to transfer 125 bytes of
			;..parameters to pl/I-80 program 
	public  putparm	;entry to move 125 bytes of
			;..parameters from a pl/I-80 program
;
;
;setup buffer area for first sector of file
;
buffer:
	ds	128	;local sector storage area for
			;parameters 125 bytes referencable
;
;
;object file access fcb
;
filefcb:
	db	0,'testprogcom',0,0,0,0
	ds	16
	db	0
;
;
;pointer parameter fetch subroutine
;
getpnt:
	mov	e,m	;get low byte address
	inx	h	
	mov	d,m	;high byte of address
	xchg		;(hl) = addr of pointer storage
	mov	c,m	;low byte of pointer to (c)
	inx	h
	mov	b,m	;high byte of pointr to (b)
	ret
;
;
;entry point to read first sector of file
;
rdbase:
	lxi	d,filefcb	;point to file fcb
	mvi	c,open		;try to open file
	call	bdos
	inr	a		;check return code
	jz	rderr		;print error before return
	lxi	d,buffer	;set dma address for read
	mvi	c,stdma	 
	call	bdos
	lxi	d,filefcb	;point to fcb for read
	mvi	c,readr		
	call	bdos		;go read it in
	ret
;
rderr:
	lxi	d,notpres	;point to not present error message
	mvi	c,print
	call	bdos
	ret
;
notpres:
	db	odh,oah,'executable file not present on default disk'
	db	odh,oah,'$'
;
;
;entry point to write first sector of file
;
wrbase:
	lda	filefcb+oeh	;fixup fcb for rewrite
	ani	07fh
	sta	filefcb+oeh
	xra	a
   	sta	filefcb+32
	lxi	d,buffer	;set dma address for write
	mvi	c,stdma
	call	bdos
	lxi	d,filefcb	;point for rewrite
   	mvi	c,writer
	call	bdos 
    	ret
;
;
;entry point to pass 125 bytes of parameters to the pl/I-80
;program
;
;       entry from pl/I-80 call with a pointer 
;
getparm:
	call	getpnt		;get pointer address to (bc)
	lxi	h,buffer+3      ;offset into buffer
	lxi	d,125		;size of parameter area
gpar1:
	mov	a,m		;from buffer
	stax    b		;to pl/I data area
	inx	h		;bump pointers
	inx	b		
	dcx	d		;decrement size counter
	mov	a,d		;check if done
	ora	e		
	jnz	gpar1
   	ret			;back to pl/I-80
;
;
;entry point to move 125 bytes of parameters from pl/I-80
;program to local buffer
;
;       entry from pl/I-80 call with a pointer
;
putparm:	
	call	getpnt		;get pointer address to (bc)
	lxi	h,buffer+3	;offset into buffer
	lxi	d,125		;size of parameter area
ppar1:
	ldax	b		;from pl/I data area
	mov	m,a		;to buffer
	inx	h		;bump pointers
	inx	b		
	dcx	d		;decrement size counter
	mov	a,d		;check if done
	ora	e
	jnz	ppar1
	ret			;back to pl/I-80
;
;
	end
;
;
;...+++end of file
                                                                                                                                                                                                                                                                