;
; Resident USER command for MP/M II
;    by Ron Fowler
;	Westland, Michigan
;
; version 1.0
;
; This RSP provides a means of changing the
; currently active user number for a console.
; Usage is identical to USER.PRL, provided
; by Digital Research with the distribution pkg.
;
; NOTE: This is an RSP.  You can't use this
;	program as a COM or PRL file without
;	a good deal of hacking.
;
	org	0		;standard rsp start
;
printf	equ	9		;print buffer
sysdat	equ	154		;return system data page
mkque	equ	134		;make queue
rdque	equ	137		;read queue
setpri	equ	145		;set priority
detach	equ	147		;detach console
;
tmploc	equ	243		;tmp pd loc offset into sysdat
usroff	equ	22		;user # offset into a pd
sysoff	equ	0FCH		;system segment loc offset
conoff	equ	13H		;# console offset into internal
				;MP/M data segment
;
cr	equ	13		;carriage return
lf	equ	10		;linefeed
;
; bdos entry point address
;
bdosad: dw	$-$	;ldr will fill this in
;
; USER process descriptor
;
userpd: dw	0		;link
	db	0		;status
	db	10		;priority (initial)
	dw	stack+38	;stack pointer
	db	'USER    '	;process name
usrcon: ds	1		;console number
	db	0ffh		;memseg
	ds	2		;b
	dw	2		;thread
	dw	80h		;disk set dma address
	ds	1		;user code & disk sel
	ds	2		;dcnt
	ds	1		;searchl
	ds	2		;searcha
	ds	2		;active drives
	ds	20		;register save area
	ds	2		;scratch
;
; user linked queue control block
;
ulqcb:	dw	0		;link
	db	'USER    '	;queue name
	dw	5		;message length
	dw	1		;nmbmsgs
	ds	2		;dqph
	ds	2		;nqph
	ds	2		;mh
	ds	2		;mt
	ds	2		;bh
	ds	7		;buf (72 + 2 byte length)
;
; USER user queue control block
;
usrqcb: dw	ulqcb		;pointer
	dw	field		;msgadr
;
; field for message read from user linked qcb
;
field:	ds	1		;disk select
consol: ds	1		;console
requsr: dw	5		;requested user #
;
; USER stack and other local data
;
stack:	ds	38		;20 level stack
	dw	user		;process entry point
ntmps:	ds	1		;number of TMP's
tmpbas: ds	2		;tmp proc descriptor base
sdata:	ds	2		;system data page location
ftflag: db	0		;initialization flag
;
; bdos call procedure
;
bdos:	lhld	bdosad		;hl = bdos address
	pchl
;
; USER main program
;
user:	mvi	c,mkque
	lxi	d,ulqcb 	;create the queue
	call	bdos
	mvi	c,sysdat	;get system data page adr
	call	bdos
	shld	sdata		;save it
	mvi	l,tmploc	;offset to loc of tmp pds
	mov	h,m		;make an address in hl
	mvi	l,usroff	;offset to user #
	shld	tmpbas		;save it
	mvi	c,setpri	;now set priority to 200
	lxi	d,200
	call	bdos
;
; eternal work loop
;
main:	lxi	sp,stack+38	;reset stack pointer
	mvi	c,rdque 	;go to sleep until queue posting
	lxi	d,usrqcb
	call	bdos
;
; Check for first-time initialization (get # system consoles).
; This can't be done in the initialization code, since the
; internal data segment is not set up at that time.
;
	lxi	h,ftflag	;point at flag
	mov	a,m		;fetch it
	mvi	m,1		;set it
	ora	a		;test it
	jnz	pasnit		;skip if we did it before
;
; Now find # of consoles.  Note that the number in
; the system data page is not NECESSARILY the true
; number.  The SYSDAT value is defined at gensys
; time; if the XIOS-returned number is different
; than GENSYSed number (a perfectly legitimate hap-
; penstance), then the data page value won't be
; right.  For that reason, we use the number of
; consoles specified in the internal data segment.
;
	lhld	sdata		;get system data page adr
	mvi	l,sysoff	;find internal data seg
	mov	a,m		;twist it sideways
	inx	h
	mov	h,m
	mov	l,a		;hl now points at int data
	lxi	d,conoff	;offset to # consoles
	dad	d
	mov	a,m		;fetch number
	sta	ntmps
pasnit: lda	consol		;make console ours
	sta	usrcon		;(only really necessary if msg printed)
	mov	b,a		;save as requested console
	lda	ntmps		;fetch number of tmps
	dcr	a		;make highest #ed console
	mov	c,a		;save as console counter
	lxi	d,64		;space between tmp pds
	lhld	tmpbas		;point to user # for highest consol
zlop:	mov	a,c		;fetch console counter
	cmp	b		;equal to requested console?
	jz	gotcon		;then skip out of loop
	dcr	c		;bump down console counter
	dad	d		;offset to next pd
	jmp	zlop
gotcon: push	h		;save pointer to pd user #
	lxi	d,0		;init new user #
	lxi	h,requsr	;point to queue msg adrs
	mov	a,m		;fetch a digit
	call	number		;got digit there?
	jc	badusr		;nope, what's he mean?
numlop: mov	a,m		;fetch next digit
	inx	h
	call	number		;got a digit?
	jc	putusr		;nope, go store req user #
	push	h		;save msg pointer
	mov	h,d		;copy accumulated # to de
	mov	l,e		;  for multiply by 10
	dad	h		;*2=2
	dad	h		;*2=2
	dad	d		;+1=5
	dad	h		;*2=2
	xchg			;get accumulation back to de
	pop	h		;restore msg pointer
	add	e		;add in new digit
	mov	e,a
	jnc	numlop		;continue if no 8-bit ovfl
	inr	d		;overflew
	jmp	numlop
;
; store requested user number
;
putusr: mov	a,d		;validate
	ora	a
	jnz	badusr		;error, just report user #
	mov	a,e		;more validation
	cpi	16		;test max
	jnc	badusr		;error, go report user #
	pop	h		;fetch user # ptr within tmp pd
	mov	a,m
	ani	0F0h		;save logged in drive
	ora	e		;or in new user number
	mov	m,a		;put back into pd
	jmp	done		;go clean up and detach
;
; bad user number
;
badusr: lxi	d,badmsg	;print diagnostic
	mvi	c,printf
	call	bdos
	pop	h		;unjunk stack
;
done:	mvi	c,detach	;all done, detach the console
	call	bdos
	jmp	main		;go await next request
;
; subroutine NUMBER tests the ascii digit in A
; for decimal numeric.	CY=not
;
number: sui	'0'
	rc			;oops, <'0'
	cpi	9+1		;>9?
	cmc			;pervert return
	ret
;
; bad user # message
;
badmsg: db	cr,lf
	db	'Invalid user number.'
	db	cr,lf,'$'
;
	end
cmc			;pervert return
	ret
;
; bad user # message
;
badmsg: db	cr,lf
	db	'Invalid