	TITLE	'SYSLIST.COM - ASSIGN LIST OUTPUT'

;
;	. . . . . . . . . . . . . . . . . . . . . . . . . . . .
;
;
;	MATCH MACRO	COMPARE 2 STRINGS OF SAME LENGTH SET CARRY IF EQUAL
;
;	MATCH	STR1,'LITERAL STRING'
;	MATCH	STR1,STR2,LENGTH
;	MATCH
;
;		DE POINTS TO STR1	MACRO WILL LOAD REG IF ARG
;		HL POINTS TO STR2	PRESENT
;		C CONTAINS LENGTH
;
;		SUBTRACT STR2 FROM STR1 AND SET FLAGS, ZERO INDICATES MATCH.
;		NORMALLY THE SECOND ARG IS A LITERAL STRING AND THE LENGTH
;		IS OMITTED. IF THE LEN ARG IS PRESENT THE SECOND STRING
;		ARG IS ASSUMED TO BE A MEMORY ADDR. IF ALL ARGUMENTS OMITTED
;		REGISTERS ASSUMED ALREADY LOADED.
;
MATCH	MACRO	STR1,STR2,LEN
	LOCAL	OVRSUB,M1
	JMP	OVRSUB
@MATCH:	INR	C		;;PRE INCREMENT COUNT (IT MIGHT BE ZERO)
M1:	DCR	C		;;DECR LENGTH COUNT
	RZ			;;RETURN IF MATCH FOUND
	LDAX	D		;;GET A BYTE FROM ONE STRING
	SUB	M		;;COMPARE WITH OTHER
	RNZ			;;RETURN
	INX	H
	INX	D		;;INCR STRING POINTERS
	JMP	M1		;;TRY SOME MORE
OVRSUB:
MATCH	MACRO	?STR1,?STR2,?LEN
	LOCAL	LITSTR,ENDLIT
	IF	NUL ?STR1&?STR2&?LEN
	CALL	@MATCH
	ELSE
	IF	NOT NUL ?STR1
	LXI	D,?STR1		;;LOAD STRING1 POINTER
	ENDIF
	IF	NUL ?LEN	;;TEST FOR LITERAL
	MVI	C,ENDLIT-LITSTR	;;LENGTH OF LITERAL STRING
	LXI	H,LITSTR	;;POINTER TO LITERAL
	CALL	@MATCH
	JMP	ENDLIT
LITSTR:	DB	?STR2		;;LITERAL STRING
ENDLIT:				;;END OF STRING
	ELSE
	IF	NOT NUL ?STR2
	LXI	H,?STR2		;;LOAD POINTER TO STRING2
	ENDIF
	MVI	C,?LEN		;;LOAD STRING LENGTH
	CALL	@MATCH		;;CALL MATCH SUBROUTINE
	ENDIF
	ENDIF
	ENDM
	MATCH	STR1,STR2,LEN
	ENDM

BDOS	EQU	0005h	;BDOS ENTRY CALL
BUFFER	EQU	0080h	;CCP INPUT BUFFER
IOBYTE	EQU	0003h	;MEMORY LOCATION OF IOBYTE
PSTRNG	EQU	9	;CP/M PRINT STRING CALL
BELL	EQU	07h	;ASCII BELL
TIME?	EQU	38	;CP/M TIME CALL
CR	EQU	0Dh
LF	EQU	0Ah

	ORG	100H

START:	LXI	H,0000
	DAD	SP
	SHLD	OLDSP
	LXI	SP,STACK
	LDA	IOBYTE
	PUSH	PSW		;SAVE IOBYTE
	LDA	BUFFER+1
	ORA	A
	JZ	ERROR1
	MATCH	BUFFER+2,'CRT'
	JZ	CRT
	MATCH	BUFFER+2,'PRINTER'
	JZ	PRINTR
	MATCH	BUFFER+2,'UL1'
	JZ	UL1
	MATCH	BUFFER+2,'?'
	JZ	HELP
	MATCH	BUFFER+2,'H'
	JZ	HELP
	CALL	INVALD
	DB	CR,LF,BELL,'Invalid parameter.  $'
INVALD:	POP	D
	MVI	C,PSTRNG
	CALL	BDOS
	JMP	REST

CRT:	POP	PSW
	ORI	40h
	STA	IOBYTE
	JMP	OK

PRINTR:	POP	PSW
	ANI	3Fh
	STA	IOBYTE
	JMP	OK

UL1:	POP	PSW
	ORI	0C0h
	STA	IOBYTE
	JMP	OK

OK:	CALL	POK
	DB	CR,LF,'Ok',CR,LF,'$'
POK:	POP	D
	MVI	C,PSTRNG
	CALL	BDOS
	JMP	GOBAK

HELP:	CALL	OHELP
	DB	CR,LF
	DB	'This is a command to direct list output to',CR,LF
	DB	'either the system console (CRT), the system print',CR,LF
	DB	'device (PRINTER) or alternate printer (UL1).  The',CR,LF
	DB	'correct command form is:',CR,LF,CR,LF
	DB	'		     {CRT    }',CR,LF
	DB	'	    SYSLIST  {PRINTER}',CR,LF
	DB	'		     {UL1    }',CR,LF,CR,LF
	DB	'The assignment persists until this command is used',CR,LF
	DB	'again, or until a cold boot is executed.',CR,LF,'$'
OHELP:	POP	D
	MVI	C,PSTRNG
	CALL	BDOS
	JMP	GOBAK

ERROR1:	CALL	PERROR
	DB	CR,LF,BELL,'No parameter given.  $'
PERROR:	POP	D
	MVI	C,PSTRNG
	CALL	BDOS
REST:	CALL	PREST
	DB	'Must be "?", "CRT", "PRINTER", or "UL1".',CR,LF,'$'
PREST:	POP	D
	MVI	C,PSTRNG
	CALL	BDOS

GOBAK:	LHLD	OLDSP
	SPHL
	RET

OLDSP:	DW	0
	DS	64
STACK:	END
