5000 REM
5010 REM *******************************************************************
5020 REM *              PLOTTING PROGRAM FOR THE MX-80                     *
5030 REM *                         BY                                      *
5040 REM *                  LAWRENCE J. BREGOLI                            *
5050 REM *******************************************************************
5060 REM
5070 REM *******************************************************************
5080 REM *     USE THE FOLLOWING SPACE TO CALCULATE A 101 BY 101           *
5090 REM *     DATA ARRAY IN X(I) AND Y(I).                                *
5100 REM *     ENTER PROGRAM BELOW THIS SECTION IF ARRAY EXISTS            *
5120 REM *******************************************************************
5130 REM			SAMPLE ARRAY -> CONCENTRIC CIRCLES
5140 REM
5150 REM
5160 DIM Y(101),X(101):REM		MOVE DIM TO MAIN PROGRAM
5170 FOR I=0 TO 50
5175 X(I)=SIN(I*6.282/50):Y(I)=COS(I*6.282/50)
5180 NEXT I
5185 FOR I=51 TO 100
5186 J=I-50
5187 X(I)=.5*SIN(J*6.282/50):Y(I)=.5*COS(J*6.282/50)
5190 NEXT I
5200 REM
5210 REM *******************************************************************
5220 REM *      ENTER TITLE OF PLOT AND AXIS LEGENDS                       *
5230 REM *******************************************************************
5240 REM
5250 XTITLE$=SPACE$(50):YTITLE$=SPACE$(50):PTITLE$=SPACE$(50)
5260 LINE INPUT "ENTER TITLE OF PLOT (50 CHARACTERS OR LESS)";T$
5270 LINE INPUT "ENTER Y AXIS TITLE (50 CHARACTERS OR LESS)";Y$
5280 LINE INPUT "ENTER X AXIS TITLE (50 CHARACTERS OR LESS)";X$
5290 MID$(YTITLE$,(LEN(YTITLE$)-LEN(Y$))/2)=Y$
5300 MID$(XTITLE$,(LEN(XTITLE$)-LEN(X$))/2)=X$
5310 MID$(PTITLE$,(LEN(PTITLE$)-LEN(T$))/2)=T$
5320 INPUT "DO YOU WANT (A)UTO OR (M)ANUAL SCALING";Y$
5330 IF Y$="M" THEN 5360
5340 IF Y$="A" THEN GOSUB 6550 ELSE 5320
5350 GOTO 5460
5360 INPUT "ENTER MAXIMUM VALUE OF Y AXIS";YMAX
5370 INPUT "ENTER MINUMUM VALUE OF Y AXIS";YMIN
5380 INPUT "ENTER MAXIMUM VALUE OF X AXIS";XMAX
5390 INPUT "ENTER MINIMUM VALUE OF X AXIS";XMIN
5400 REM
5410 REM **********************************************************************
5420 REM *	MAIN BODY OF PROGRAM STARTS HERE      			      *
5430 REM **********************************************************************
5440 REM
5450 REM
5460 LPRINT:LPRINT:LPRINT TAB(15);PTITLE$:REM 	PRINT TITLE OF PLOT
5470 LPRINT:LPRINT
5480 GOSUB 5810:REM			SET COMPRESSED CHARACTER MODE
5490 LSPACE=2:GOSUB 5780:REM		SET LINE SPACING
5500 RSTOP=20:CHAR$="|":GOSUB 5850:REM	FORCE CARRIAGE LEFT
5510 FOR LNNO=100 TO 0 STEP -1
5520 YN=YMAX-(((YMAX-YMIN)/100*(100-LNNO))):REM	NORMALIZED Y VALUE
5530 YD=ABS((YMAX-YMIN)/100):REM	VALUE OF EACH LINE
5540 GOSUB 6250:REM			PRINT VERTICAL TITLE
5550 IF LNNO/2-FIX(LNNO/2)=0 THEN GOSUB 5910:REM PLOT VERTICAL LINES
5560 GOSUB 6020:REM			PLOT DATA
5570 GOSUB 6140:REM			PRINT HORIZONTAL LINE
5580 LPRINT
5590 RSTOP=20:CHAR$="|":GOSUB 5850:REM	FORCE CARRIAGE LEFT
5600 LPRINT
5610 NEXT LNNO
5620 GOSUB 6350:REM			PRINT X SCALE
5630 GOSUB 6460:REM			PRINT X AXIS TITLE
5640 LSPACE=12:GOSUB 5780:REM		SET NORMAL LINE SPACING
5650 GOSUB 5830:REM			SET NORMAL CHARACTER WIDTH
5660 FOR I=1 TO 23:LPRINT:NEXT I:REM	TOP OF NEXT FORM
5670 END
5680 REM
5690 REM **********************************************************************
5700 REM *	END OF MAIN BODY, SUBROUTINES START HERE                      *
5710 REM **********************************************************************
5720 REM
5730 REM
5740 REM **********************************************************************
5750 REM *		PRINTER CONTROL SUBROUTINES 			      *
5760 REM **********************************************************************
5770 REM
5780 LPRINT CHR$(27)"A"CHR$(LSPACE):REM EDIT WITH GRAFTRAX OPTION
5790 RETURN:REM				SET LINE SPACING
5800 REM
5810 LPRINT CHR$(15):RETURN:REM SET COMPRESSED MODE
5820 REM
5830 LPRINT CHR$(18):RETURN:REM		SET NORMAL MODE
5840 REM
5850 LPRINT SPC(RSTOP);CHAR$;:RETURN:REM	PRINT CHAR AT RSTOP
5860 REM
5870 REM **********************************************************************
5880 REM *	PLOT VERTICAL LINE SUBROUTINE				      *
5890 REM **********************************************************************
5900 REM
5910 CHAR$="|":RSTOP=20:LPRINT CHR$(13);:GOSUB 5850
5920 RSTOP=9
5930 FOR I=1 TO 10
5940 GOSUB 5850
5950 NEXT I
5960 RETURN
5970 REM
5980 REM **********************************************************************
5990 REM *	PLOT DATA SUBROUTINE					      *
6000 REM **********************************************************************
6010 REM
6020 CHAR$="0"
6030 FOR I=0 TO 100
6040 IF (Y(I))>YN+.50001*YD OR (Y(I))<YN-.50001*YD THEN 6080
6050 XP=FIX((X(I)-XMIN)*100/(XMAX-XMIN))
6060 IF XP<0 OR XP>100 THEN 6080
6070 LPRINT CHR$(13);:RSTOP=XP+20:GOSUB 5850
6080 NEXT I:RETURN
6090 REM
6100 REM **********************************************************************
6110 REM *	PLOT Y SCALE AND HORIZONTAL LINE SUBROUTINE		      *
6120 REM **********************************************************************
6130 REM
6140 IF LNNO/10-FIX(LNNO/10)<>0 THEN RETURN
6150 LPRINT CHR$(13);:RSTOP=10:CHAR$="":GOSUB 5850
6160 LPRINT USING "######.##";(YMAX-YMIN)*LNNO/100+YMIN;
6170 LPRINT CHR$(13);:RSTOP=20:CHAR$="-":GOSUB 5850
6180 LPRINT STRING$(100,"-");
6190 RETURN
6200 REM
6210 REM **********************************************************************
6220 REM *		PRINT Y AXIS TITLE				      *
6230 REM **********************************************************************
6240 REM
6250 IF LNNO/2-FIX(LNNO/2)<>0 THEN RETURN
6260 LPRINT CHR$(13);:RSTOP=7
6270 CHAR$=MID$(YTITLE$,FIX(((100-LNNO)/2)+1),1)
6280 GOSUB 5850
6290 RETURN
6300 REM
6310 REM **********************************************************************
6320 REM *		PRINT X SCALE SUBROUTINE			      *
6330 REM **********************************************************************
6340 REM
6350 LPRINT:LPRINT
6360 RSTOP=13:CHAR$="":GOSUB 5850
6370 FOR I=0 TO 10
6380 LPRINT USING "#######.##";(XMAX-XMIN)*I/10+XMIN;
6390 NEXT I
6400 RETURN
6410 REM
6420 REM **********************************************************************
6430 REM *		PRINT X AXIX TITLE				      *
6440 REM **********************************************************************
6450 REM
6460 LPRINT:LPRINT:LPRINT
6470 LPRINT:LPRINT:LPRINT
6480 RSTOP=45:CHAR$=XTITLE$:GOSUB 5850
6490 RETURN
6500 REM
6510 REM **********************************************************************
6520 REM *		AUTO SCALING SUBROUTINES			      *
6530 REM **********************************************************************
6540 REM
6550 YMAX=Y(0):XMAX=X(0):YMIN=Y(0):XMIN=X(0)
6560 FOR I=1 TO 100:REM				FIND XMAX AND YMAX
6570 IF Y(I)>YMAX THEN YMAX=Y(I)
6580 IF Y(I)<YMIN THEN YMIN=Y(I)
6590 IF X(I)>XMAX THEN XMAX=X(I)
6600 IF X(I)<XMIN THEN XMIN=X(I)
6610 NEXT I
6620 RESTORE 6830:REM----------------------------------------------------------
6630 MSD=(YMAX-YMIN)/10:REM			SCALE THE Y AXIS
6640 FOR I=-2 TO 4
6650 FOR K=1 TO 3:READ J
6660 IF MSD<=J*10^(I) THEN MSD=J*10^(I):GOTO 6680
6670 NEXT K:RESTORE 6830:NEXT I
6680 FOR I=10 TO -10 STEP -1
6690 IF (YMAX<=I*MSD)*(YMAX>I*MSD-.99999*MSD) THEN YMAX=I*MSD
6700 NEXT I
6710 YMIN=YMAX-10*MSD
6720 RESTORE 6830:REM----------------------------------------------------------
6730 MSD=(XMAX-XMIN)/10:REM			SCALE THE X AXIS
6740 FOR I=-2 TO 4
6750 FOR K=1 TO 3:READ J
6760 IF MSD<=J*10^(I) THEN MSD=J*10^(I):GOTO 6780
6770 NEXT K:RESTORE 6830:NEXT I
6780 FOR I=10 TO -10 STEP -1
6790 IF (XMAX<=I*MSD)*(XMAX>I*MSD-.99999*MSD) THEN XMAX=I*MSD
6800 NEXT I
6810 XMIN=XMAX-10*MSD
6820 RETURN
6830 DATA 1,2,5
6840 REM
6850 REM **********************************************************************
6860 REM *		LIST OF VARIABLE NAMES USED IN PROGRAM		      *
6870 REM **********************************************************************
6880 REM
6890 REM	Y(I)	Y AXIS DATA ARRAY
6900 REM	X(I)	X AXIS DATA ARRAY
6910 REM	YMAX	MAXIMUM VALUE OF Y AXIS
6920 REM	YMIN	MINIMUM VALUE OF Y AXIS
6930 REM	XMAX	MAXIMUM VALUE OF X AXIS
6940 REM	XMIN	MINIMUM VALUE OF X AXIS
6950 REM	LNNO	Y AXIS LINE NUMBER
6960 REM	RSTOP	CHARACTER TAB FEED
6970 REM	LSPACE	SIZE OF LINEFEED AT PRINTER
6980 REM	YN	NORMALIZED Y AXIS VALUE
6990 REM	YD	DELTA VALUE FOR EACH Y AXIS LINE
7000 REM	XP	CHARACTER POSITION ON X AXIS
7010 REM	MSD	MINIMUM SCALE DELTA
7020 REM	J	SCALE DELTA
7030 REM	K	INDEX COUNTER
7040 REM	I	INDEX COUNTER
7050 REM	T$	PLOT TITLE
7060 REM	PTITLE$	PLOT TITLE CENTERED IN 50 SPACES
7070 REM	Y$	Y AXIS TITLE
7080 REM	YTITLE$	Y AXIS TITLE CENTERED IN 50 SPACES
7090 REM	X$	X AXIS TITLE
7100 REM	XTITLE$	X AXIS TITLE CENTERED IN 50 SPACES
7110 REM	CHAR$	STRING PRINTED AT RSTOP
7120 REM
90 REM	X$	X AXIS TITLE
7100 REM	XTITLE$	X AXIS TITLE CENTERED IN 50