;
; ***********************************************
; *						*
; *		 J O B S . A S M		*
; *						*
; *		    version 1.0 		*
; *						*
; *   AN MP/M PROCESS STATUS DISPLAY PROGRAM	*
; *						*
; ***********************************************
;
; THIS PROGRAM PRINTS A LIST OF ALL THE JOBS
; IN THE MP/M SYSTEM, ALONG WITH PD INFORMATION.
;
; COPYRIGHT (C) 1982 BY RON FOWLER, WESTLAND MICHIGAN
;
;------------------------------------------------------
;
; useage:
;	JOBS [PROCESSNAME] ["-"]
;
;     Where processname specifies the name of the process
;     to be displayed.	The optional slash specifies that
;     a footnote be included within the display describing
;     abbreviations used.
;
;     Note: the process name may contain CP/M wildcards
;
;	Version 1.0
;	03/06/82
;	  by Ron Fowler
;	     Westland, Michigan
;
;
; SET ORIGINS FOR .PRL FILE GENERATION
;
;
	.LOC	.PROG.# 	;PUT IN THE CODE-RELATIVE SEGMENT
;
BASE	=	.-100H		;DETERMINE SYSTEM BASE PAGE
DFCB	=	BASE+5CH;DEFAULT FILE CONTROL BLOCK
;
;
; MACROS FOR SIMPLIFYING INDIRECT ADDRESSING
;
	.SALL			;SUPPRESS MACRO EXPANSIONS
;
	.DEFINE POINT[AMOUNT]=[
	LXI	H,AMOUNT
	DAD	D
]
	.DEFINE LHLI=[		;;LOAD HL FROM @HL
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
]
;
; SYSTEM EQUATES
;
BDOS	=	BASE+5	;BDOS SYSTEM ENTRY POINT
PCHAR	=	2	;BDOS PRINT CHAR FNC #
SYSDAT	=	154	;GET SYSTEM DATA PAGE ADRS
;
MAXSTS	=	14	;HIGHEST USED MP/M STATUS VALUE
;
DSOFS	=	0FCH	;SYSTEM DATA SEG OFFSET INTO SYSDAT PAGE
THROOT	=	011H	;THREAD ROOT OFFSET INTO DATA SEGMENT
NAMOFS	=	6	;PROCESS NAME OFFSET INTO PROC DESCR
NAME	=	NAMOFS	;PSEUDONYM
THROFS	=	18	;THREAD OFFSET INTO PROCESS DESCRIPTOR
STATUS	=	2	;STATUS BYTE OFFSET
LSTCON	=	14	;LIST/CONSOLE PD OFFSET
DSKUSR	=	22	;DISK/USER PD OFFSET
DMAFLD	=	20	;DMA ADRS PD OFFSET
DCNT	=	23	;DELAY COUNT PD OFFSET
STKP	=	4	;STACK PTR PD OFFSET
DPAR	=	16	;DPAR VALUE OFFSET IN PD
SRCL	=	25	;SEARCHL VALUE OFFSET IN PD
SRCA	=	26	;SEARCHA VALUE OFFSET IN PD
MEMSEG	=	15	;OFFSET TO MEMORY SEGMENT
;
;
CR	=	13	;CARRIAGE RETURN CODE
LF	=	10	;LINEFEED CODE
ATAB	=	9	;TAB CHAR
NPL	=	5	;PROCESS NAMES PER LINE
;
	JMP	JOBLST	;SKIP COPYRIGHT BLURB
	.ASCII	'Copyright (C) 1982 by Ronald G. Fowler'
;
JOBLST: LXI	SP,STACK
	XRA	A	;ZAP PASS INDICATOR
	STA	PASI
	STA	FNDFLG	;FLAG NO PROCESSES FOUND YET
	LXI	H,BUFR	;INIT BUFFER
	SHLD	BUFPTR
	LDA	BASE+7	;GET TOP PAGE OF MEMORY
	STA	TOP
	DI		;DISCONTIGUOUS CODE
	CALL	GATHER	;ACCUMULATE THE DATA
	EI
	MVI	A,1	;FLAG PRINT PASS
	STA	PASI
	LDA	FNDFLG	;ANY PROCESSES FOUND?
	ORA	A
	JRZ	..NFND	;NOPE, TELL THAT
	LHLD	BUFPTR	;MARK END OF PRINT
	MVI	M,0
	LXI	H,HEADER;PRINT OUT THE REPORT
	CALL	PRINT
	LDA	DFCB+1	;LOOK AT SECOND FCB
	CPI	'-'	;FOOT REQUESTED?
	JRZ	..FOOT	;GO PRINT IT THEN
	LDA	DFCB+16+1 ;CHECK 2ND FCB FOR OPTION
	CPI	'-'	;GOT IT?
	JRNZ	..BASE	;NOPE, EXIT WITHOUT IT
..FOOT: LXI	H,FOOT	;PRINT REPORT FOOT
	CALL	PRINT
..BASE: JMP	BASE
;
..NFND: LXI	H,NFDEMS;PRINT NOT FOUND ERROR MSG
	CALL	PRINT
	JMPR	..BASE	;AND EXIT
;
; GATHER PROCESS INFORMATION, PRINT INTO BUFFER
;
GATHER: MVI	C,SYSDAT;GET SYSTEM DATA PAGE LOC
	CALL	BDOS
	MVI	L,DSOFS ;POINT TO SYS DATA SEG PTR
	MOV	E,M	;PICK UP THE POINTER
	INX	H
	MOV	D,M
	LXI	H,THROOT;OFFSET TO THREAD ROOT
..LOP:	DAD	D	;OFFSET TO NEXT PROCESS PTR
	MOV	E,M	;PICK UP POINTER
	INX	H
	MOV	D,M
	MOV	A,D	;ANYTHING THERE?
	ORA	E
	RZ		;DONE IF NOT
	LDA	DFCB+1	;SEE IF THERE IS A REQUESTED PROCESS NAME
	CPI	' '
	JRZ	..PRNT	;NO, GO PRINT ALL
	CPI	'-'	;SLASH OPTION INSTEAD OF PROCESSNAME?
	JRZ	..PRNT	;MEANS PRINT ALL ALSO
	POINT	NAME	;THERE IS, POINT HL TO CUR PD NAME FIELD
	PUSH	D	;SAVE PD POINTER
	LXI	D,DFCB+1;FOR COMPARISON
	MVI	B,8
	CALL	COMPAR
	POP	D	;RESTORE PD POINTER
	JNZ	..NXHD	;SKIP IF NOT REQUESTED PD
..PRNT: MVI	A,1	;FLAG THAT A PROCESS HAS BEEN FOUND
	STA	FNDFLG
	POINT	NAME	;GET NAME POINTER
	CALL	PRNAME	;PRINT IT
	POINT	STATUS	;POINT TO STATUS BYTE
	MOV	A,M	;FETCH IT
	CALL	PRTSTS	;PRINT IT
	INX	H	;POINT TO PRIORITY
	MOV	A,M	;FETCH IT
	CALL	DECBYT	;PRINT IT
	POINT	MEMSEG	;FETCH MEM SEGMENT
	MOV	A,M	;FETCH IT
	CALL	HEXBYT	;PRINT IT
	CALL	SPACE2	;FOLLOW WITH TWO SPACES
	POINT	LSTCON	;POINT TO LIST/CONSOLE
	MOV	A,M	;FETCH THEM
	CALL	PRNYBS	;PRINT THEM
	POINT	DSKUSR	;POINT TO DISK/USER
	MOV	A,M	;FETCH THEM
	CALL	PRNYBS	;PRINT THEM
	POINT	DMAFLD	;POINT TO DMA ADDRESS
	LHLI		;FETCH INTO HL
	CALL	HEXWRD	;PRINT IT
	POINT	DCNT	;POINT TO DELAY COUNT
	LHLI		;FETCH IT
	CALL	HEXWRD	;PRINT IT
	POINT	STKP	;POINT TO STACK POINTER
	LHLI		;FETCH IT
	CALL	HEXWRD	;PRINT IT
	LHLI		;FETCH PC (TOP OF STACK)
	CALL	HEXWRD	;PRINT IT
	POINT	DPAR	;GET DPAR VALUE
	LHLI		;FETCH IT
	CALL	HEXWRD	;PRINT IT
	POINT	SRCA	;POINT TO SEARCHL
	MOV	A,M	;FETCH IT
	CALL	HEXBYT	;PRINT IT
	CALL	SPACE2
	POINT	SRCA	;POINT SEARCHL
	LHLI		;FETCH IT
	CALL	HEXWRD	;PRINT IT
	CALL	CRLF	;TURN UP A NEW LINE
;
; HERE TO ADVANCE TO NEXT PROCESS
;
..NXHD: LXI	H,THROFS;POINT TO THEAD TO NEXT PD
	JMP	..LOP	;GO DO ANOTHER HEAD
;
; ***************
; * SUBROUTINES *
; ***************
;
; DECODE AND PRINT STATUS
;
PRTSTS: CPI	MAXSTS+1;LEGAL VALUE?
	JRC	..OK	;YEP
	MVI	A,MAXSTS;HMM...WELL, FIX IT
..OK:	PUSH	H	;DON'T ALTER ANY REGS
	PUSH	B
	MOV	C,A	;SET FOR MULTIPLY BY 3
	ADD	A	;A=A*2
	ADD	C	;*3
	MVI	B,0	;MAKE 16 BIT OFFSET INTO TABLE
	MOV	C,A
	LXI	H,..TBL ;POINT TO TABLE
	DAD	B	;ADD IN OFFSET
	MVI	B,3	;GET A PRINT COUNTER
..PRT:	MOV	A,M	;FETCH A CHAR
	INX	H
	CALL	TYPE	;PRINT IT
	DJNZ	..PRT	;PRINT ALL THREE CHARS
	CALL	SPACE	;PRETTY IT UP
	POP	B	;RESTORE AND RETURN
	POP	H
	RET
;
; TABLE OF STATUS MNEMONICS
;
..TBL:	.ASCII	'RUNDEQENQ'	;RUN, DEQUE, ENQUE
	.ASCII	'POLFLGDLY'	;POLL, FLAG WT, DELAYED
	.ASCII	'???TRMPRI'	;UNUSED, TERMINATE, SET PRI
	.ASCII	'DSPATTDET'	;DISPATCH ATTACH AND DETCH CON
	.ASCII	'SETATLDTL'	;SET CON, ATCH AND DETCH LIST
;
; PRINT A BYTE IN DECIMAL AND A TRAILING SPACE
;
DECBYT: PUSH	H	;DON'T ALTER HL
	PUSH	D	;SAVE PD ADDRESS
	MOV	L,A	;GET BYTE INTO HL
	MVI	H,0
	CALL	DECPUT	;MOVE DECIMAL INTO BUFFER
	MVI	A,4	;NOW TYPE THE BUFFER
	CALL	DECTYP
	POP	D	;RESTORE AND RETURN
	POP	H
	RET
;
; PRINT A WORD IN DECIMAL AND A TRAILING SPACE
;
DECWRD: PUSH	D	;SAVE PD ADDRESS
	CALL	DECPUT	;MOVE DECIMAL INTO BUFFER
	MVI	A,6	;PRINT THE BUFFER
	CALL	DECTYP
	POP	D	;RESTORE AND RETURN
	RET
;
; CONVERT HL TO DECMAL AND STORE DIGITS IN DECBUF
;
DECPUT: PUSH	H	;FIRST SAVE THE VALUE
	LXI	H,DECBUF;CLEAR THE BUFFER
	SHLD	DECPTR	;(STORE A POINTER)
	MVI	A,' '
	MVI	B,6	;DECIMAL BUFFER SIZE
..CLR:	MOV	M,A	;CLEAR A BYTE
	INX	H	;POINT AHEAD
	DJNZ	..CLR
	POP	H	;RESTORE VALUE
;
; DECIMAL OUTPUT ROUTINE
;
;
DECOUT: PUSH	B	;SAVE EVERYBODY
	PUSH	D
	PUSH	H
	LXI	B,-10	;DIVISOR
	LXI	D,-1	;COUNT
;
..DEC2: DAD	B
	INX	D
	JC	..DEC2
	LXI	B,10	;CORRECT OVERSHOOT
	DAD	B
	XCHG
	MOV	A,H
	ORA	L
	CNZ	DECOUT	;THIS IS RECURSIVE
	MOV	A,E	;GET THE DIGIT
	ADI	'0'	;MAKE IT PRINTABLE
	CALL	..TYPE	;PUT IT IN DEC BUFFER
	POP	H	;RESTORE EVRYBODY
	POP	D
	POP	B
	RET
..TYPE: LHLD	DECPTR	;GET DEC BUFR PTR
	MOV	M,A	;STUFF THE CHAR
	INX	H	;UPDATE POINTER
	SHLD	DECPTR
	RET
;
; TYPE OUT THE DECIMAL BUFFER
;
DECTYP: PUSH	B
	MOV	B,A	;INIT COUNTER PASSED IN A
	LXI	H,DECBUF;POINT TO DECIMAL BUFFER
..LOP:	MOV	A,M	;FETCH A CHAR
	INX	H	;POINT TO NEXT
	CALL	TYPE	;PRINT THE CHAR
	DJNZ	..LOP	;PRINT ALL REQUESTED DIGITS
	POP	B
	RET
;
; PRINT HL IN HEX, FOLLOWED BY A SPACE
;
HEXWRD: MOV	A,H	;GET HI BYTE
	CALL	HEXBYT	;PRINT IT
	MOV	A,L	;GET LOW
	CALL	HEXBYT	;PRINT IT
	CALL	SPACE	;PRINT THE SPACE
	RET
;
; PRINT A IN HEX
;
HEXBYT: PUSH	PSW	;SAVE IT
	RRC		;MOVE HIGH NYBBLE INTO LOW
	RRC
	RRC
	RRC
	CALL	..CONV	;PRINT HI NYBBLE
	POP	PSW	;RESTORE THE VALUE
..CONV: ANI	0FH	;MASK UPPER NYBBLE OUT
	ADI	90H	;CONVERT TO ASCII
	DAA
	ACI	40H
	DAA		;HAVE IT PRINTABLE NOW IN A
	CALL	TYPE	;PRINT IT
	RET
;
; PRINT THE BYTE IN A AS TWO SEPARATE VALUES,
; ONE IN EACH HALF OF THE ACCUMULATOR
;
PRNYBS: PUSH	PSW	;SAVE THAT BYTE
	ANI	0FH	;MASK OUT HIGH, LEAVING LOW
	CALL	DECBYT	;PRINT IT
	POP	PSW	;GET HI BACK
	RRC		;MOVE INTO LOW
	RRC
	RRC
	RRC
	ANI	0FH	;MASK OUT HI
	CALL	DECBYT	;PRINT IT
	RET
;
; PRINT @HL UNTIL NULL
;
PRINT:	MOV	A,M
	INX	H
	ORA	A
	RZ
	CALL	TYPE
	JMPR	PRINT
;
;
; PRINT PROCESS NAME
;
PRNAME: MVI	B,8	;PRINT ALL 8 CHARS OF NAME
..LOP:	MOV	A,M	;FETCH A CHAR
	INX	H	;POINT PAST IT
	CALL	TYPE	;PRINT IT
	DJNZ	..LOP	;PRINT ALL
	CALL	SPACE
	RET
;
; PRINT TWO SPACES
;
SPACE2: CALL	SPACE	;PRINT FIRST, FALL INTO SECOND
;
; PRINT A SPACE
;
SPACE:	MVI	A,' '
	JMPR	TYPE
;
; PRINT A COLON
;
COLON:	MVI	A,':'
	JMPR	TYPE
;
; PRINT A TAB
;
TAB:	MVI	A,ATAB
	JMPR	TYPE
;
; TURN UP A NEW LINE
;
CRLF:	MVI	A,CR
	CALL	TYPE
	MVI	A,LF
;
; TYPE A CHAR: INTO MEMORY ON PASS 0,
; TO CONSOLE ON PASS 1.
;
TYPE:	PUSH	H	;SAVE EVERYBODY
	PUSH	D
	PUSH	B
	ANI	7FH	;ZAP ATTRIBUTE BITS
	MOV	E,A	;IN E REG FOR BDOS PRINT
	LDA	PASI	;BUT FIRST...
	ORA	A	;WHAT PASS IS IT?
	JRZ	..IMEM	;GO STORE IF PASS 0
	MVI	C,PCHAR ;NOPE, GET BDOS FUNCT #
	CALL	BDOS	;PRINT THE CHAR
..EXIT: POP	B	;RESTORE ALL
	POP	D
	POP	H
	RET
..IMEM: LHLD	BUFPTR	;GET MEMORY BUFFER POINTER
	MOV	M,E	;STUFF CHAR AWAY
	INX	H	;ADVANCE POINTER
	SHLD	BUFPTR
	LDA	TOP	;CHECK MEMORY LIMIT
	CMP	H	;ARE WE IN TOP PAGE?
	JRNZ	..EXIT	;THEN GO BACK
	CALL	ERRXIT	;OUT OF MEMORY ERROR
	.BYTE	CR,LF
	.ASCII	'Out of memory.'
	.BYTE	CR,LF,'$'
;
; COMPARE @HL TO @DE, COUNT IN B
; COMPARISON IGNORES CASE OF THE
; STRING @HL.
;
COMPAR: XCHG		;GET UC STRING PTR TO HL (CMD LN PTR)
..CLP:	MOV	A,M	;FETCH SPEC STRING CHAR
	CPI	'?'	;WILDCARD?
	JRZ	..MAT	;THAT'S A MATCH
	LDAX	D	;NOPE, GET CHAR FROM PROC POINTER
	ANI	7FH	;KILL ATTRIBUTES
	CPI	'a'	;TEST CASE
	JRC	..COMP	;SKIP IF NOT LOWEST LOWER
	CPI	'z'+1	;TEST HIGHEST LOWER
	JRNC	..COMP	;SKIP IF NOT HIGHEST LOWER
	ANI	0DFH	;MAKE IT UPPER CASE
..COMP: CMP	M
	RNZ
..MAT:	INX	H
	INX	D
	DJNZ	..CLP
	RET
;
; EXIT WITH ERROR MESSAGE
;
ERRXIT: POP	D	;GET MSG POINTER
	MVI	C,9	;BDOS PRINT BUFR FUNCT #
	CALL	BDOS
	JMP	BASE	;EXIT
;
; DATA AREA
;
TOP:	.BYTE	0	;TOP-OF-MEMORY PAGE
PASI:	.BYTE	0	;PASS INDICATOR
FNDFLG: .BYTE	0	;PROCESS FOUND FLAG
BUFPTR: .WORD	BUFR	;BUFFER POINTER
DECBUF: .ASCII	'      ';DECIMAL OUTPUT BUFFER
DECPTR: .WORD	DECBUF	;DECIMAL BUFFER POINTER
;
; PROCESS NOT FOUND ERROR MESSAGE
;
NFDEMS: .BYTE	CR,LF
	.ASCII	'Process not found.'
	.BYTE	CR,LF,0
;
; REPORT FOOT
;
FOOT:	.BYTE	CR,LF,CR,LF
	.ASCII	'-----------------------------'[CR][LF]
	.ASCII	'
	      Abbreviations used:

status column			column abbreviations
-------------			--------------------

RUN: process running	     STS:  status of process
DEQ: process dequeueing      PRI:  process priority
ENQ: process enqueueing      MEM:  memory segment
POL: process polling	     CON:  assigned console
FLG: process flag-waiting    LST:  assigned lst device
DLY: process on delay list   USR:  logged in user #
TRM: terminate process	     DSK:  logged in drive
PRI: set priority	     DMAD: DMA address
DSP: dispatch		     DCNT: delay count
ATT: attach console	     STKP: stack pointer
DET: detach console	     PC:   program counter
SET: set console	     DPAR: MP/M var  (DPARAM)
ATL: attach list	     SRL:  srch/frst BDOS parm
DTL: detach list	     SRCA: srch/next BDOS parm
'
	.BYTE	0	;TERMINATE THE FOOT
;
	.BYTE	[100]0	;THE STACK
STACK	=	.
	.BYTE	0	;FORCE HEX RECORD
;
;
; LISTING HEADER
;
HEADER: .ASCII	"PD NAME  STS PRI MEM CON LST USR DSK DMAD DCNT"
	.ASCII	" STKP  PC  DPAR SRL SRCA "[CR][LF]
	.ASCII	"-------  --- --- --- --- --- --- --- ---- ----"
	.ASCII	" ---- ---- ---- --- ----"
	.BYTE	CR,LF
;
; NOTHING SHOULD BE PLACED BETWEEN HERE AND THE BUFFER
; UNLESS IT IS TO BE PRINTED AS PART OF THE REPORT.
;
BUFR	=	.	;DEFINE STORAGE BUFFER
;
; THE FOLLOWING MINIMUM BUFFER ALLOCATION MAY BE
; NECESSARY FOR USE IN SMALL MEMORY SEGMENTS.
;
	.BYTE	[2048]0
;
	.END
