1000 'ASSEMBLER/BASIC LOAD UTILITY
1010 'SAVE"HEXIT",A
1020 'COPYRIGHT 1982, MILES KEHOE. ALL RIGHTS RESERVED.
1030 'REV:  1.0      DATE:  6/ 2/82    AUTHOR: M. Kehoe/HP GSD
1040 'First initialize all program variables and functions
1050  BELL$=CHR$(7):LF$=CHR$(10):CR$=CHR$(13):DC1$=CHR$(17):ESC$=CHR$(27):

      BACK$=CHR$(8):T$="0123456789ABCDEF"
1060  HOME$=ESC$+"h":CLR$=ESC$+"J":CLL$=ESC$+"K":INL$=ESC$+"L":DL$=ESC$+"M"
1070  LFOFF$=ESC$+"&k0A":MOFF$=ESC$+"&k0M":BELON$=ESC$+"&k1D"
1080  KOFF$=ESC$+"&j@":KON$=ESC$+"&jB":KLOCK$=ESC$+"&jS":KUNLK$=ESC$+"&jR"
1090  HB$=ESC$+"&dJ":NV$=ESC$+"&d@":UL$=ESC$+"&dD"
1100  CW=80:PW=132    'Console width, printer width
1200 'Define Functions
1210  DEF FNC$(R,C)=ESC$+"&a"+STR$(R)+"r"+STR$(C)+"C"
1220  DEF FNCN$(A$,W)=STRING$(INT((W-LEN(A$))/2)," ")+A$
1230  DEF FNK$(K,K$)=ESC$+"&f0a"+STR$(K)+"k"+STR$(LEN(K$))+"d1L"+

                           K$+CHR$(16+K)
1235 DEF FNV(A$)=(INSTR(T$,LEFT$(A$,1))-1)*16+INSTR(T$,RIGHT$(A$,1))-1
1240  DEF FNUP$(A$)=CHR$(ASC(A$)+(32*((ASC(A$)>96) AND (ASC(A$)<123))))
1245  DEF FNKUP$(K,K$)=KUNLK$+KOFF$+FNK$(K,K$)+KON$+KLOCK$
1250  WIDTH 255
1260  GOTO 5000    'Initailization done. Branch to main program.
1300 'Subroutine: INKEY  - Input a key, set flag if softkey
1310  C99$=INPUT$(1):C99%=ASC(C99$)-16:

           IF C99%>0 AND C99%<9 THEN FLAG=C99%:RETURN
1320  FLAG=0:RETURN
1350 'Subroutine: GETSFK  - Input only a softkey - beep otherwise
1360  GOSUB 1300:IF FLAG=0 THEN PRINT BELL$;:GOTO 1360
1370  RETURN
1400 'Subroutine: BREAK  - Paint Break Line
1410  PRINT FNC$(19,0);UL$;STRING$(80," ");NV$;FNC$(20,0);
1420  RETURN
1425 'Subroutine: WARN  -  Warn message on line 21
1430 PRINT FNC$(21,0);CLR$;"Warning: ";MSG$;BELL$;
1435 RETURN
1440 'Subroutine: CLWARN  -  Clear Warning Message
1445 PRINT FNC$(21,0);CLR$; : RETURN
1450 'Subroutine: KEYINIT - Initialize Softkeys
1460  PRINT KUNLK$;KOFF$;:

            FOR I99%=1 TO 8:

                PRINT FNK$(I99%," ");:

            NEXT I99%:

      PRINT KON$;KLOCK$;
1470  RETURN
1500 'Subroutine: ECHO  - Print character in C99$
1510  PRINT C99$;:RETURN
1550 'Subroutine: INIT  -  Initialize parameters
1560  PRINT LFOFF$;MOFF$;BELON$;KON$;
1570  TITLE$=HB$+"HEXIT : Assembler/BASIC Utility"+NV$
1575  GOSUB 1450
1580  RETURN
1600 'Subroutine: LININ  (Rev 2)
1610  IF EOL=1 THEN GOTO 1640  'Re-entry: do not init
1620  BUF$="":LININ=0:EOL=1    'Set abnormal EOL stuff
1630 'Re-entry : from SFK handling
1640  IF LININ=255 THEN EOL=2:RETURN     'Max length - return
1650  GOSUB 1300     'Inkey
1660  IF FLAG=0 THEN 1690   'Not a SFK
1670  IF SFKOK=0 THEN 1650  'No SFK Allowed
1680  EOL=1:RETURN   'Interrupted by SFK, and allowed to return
1690  IF C99$<>BACK$ THEN 1750
1700  IF LININ=0 THEN 1650  'No chars to erase
1710  PRINT BACK$;" ";BACK$;  'Erase char
1720  IF LININ=1 THEN GOTO 1620  'Start over
1730  LININ=LININ-1:BUF$=LEFT$(BUF$,LININ)
1740  GOTO 1650
1750  IF ECHO=0 THEN GOSUB 1500
1760  IF C99$=CR$ THEN PRINT LF$;:EOL=0:RETURN 'Normally
1780  BUF$=BUF$+C99$: LININ=LININ+1
1790  GOTO 1640      'End of LININ
1800 'Subroutine: FCHECK  -  Check for Existing File
1810  EXISTS=0
1820  ON ERROR GOTO 1860
1830  OPEN"I",#3 ,FILE$
1840  EXISTS=1:CLOSE#3
1850  GOTO 1870
1860  IF ERR<>53 THEN GOTO 2200

                 ELSE RESUME 1870
1870  ON ERROR GOTO 2200
1880  RETURN
1900 'Subroutine: NCHECK  -  Check for valid filename in FILE$
1910  HOLD$=FILE$    'Hold filename for posterity
1920  VALID=0:DR$="":FILNM$="":FILTYP$=""
1930  COLON=INSTR(FILE$,":"):PERIOD=INSTR(FILE$,".")
1940  IF COLON=0 THEN DR$=CHR$(PEEK(4)+65):

                         GOTO 2000         'No colon in filename
1950  IF COLON>PERIOD THEN 2180            'Error 
1960  IF COLON<>2 THEN 2180                'Error
1970  DR$=FNUP$(LEFT$(FILE$,1))            'Always upper case drive code
1980  IF INSTR("ABCDEFGH",DR$)=0 THEN 2180  'Error
1990  FILE$=MID$(FILE$,3):PERIOD=INSTR(FILE$,"."):

      IF INSTR(FILE$,":")>0 THEN 2180      'Check for second ':'
2000  IF PERIOD=0 THEN FILNM$=FILE$:

                       FILTYP$="":

                       GOTO 2060           'No file type included
2010  IF LEN(FILE$)=PERIOD THEN 2180       'No file type w/ period
2020  TLEN = LEN(FILE$) -  LEN(RIGHT$(FILE$,PERIOD+1))    'Len of file type
2030  IF TLEN>3 THEN 2180
2035 PERIOD=INSTR(FILE$,".")
2040  FILTYP$=MID$(FILE$,PERIOD+1)    'Extract file type 
2050  FILNM$=LEFT$(FILE$,PERIOD-1)         'Extract file name
2060 'Now have filename, etc.  Start validity checking
2070  IF INSTR(FILNM$,"<>.,;:=?*")<>0 THEN 2180
2080  IF INSTR(FILTYP$,"<>.,;:=?*")<>0 THEN 2180
2090  IF UPC=0 THEN 2150                   'Skip upper casing
2100  TMP$=""
2110  FOR I99%=1 TO LEN(FILNM$):

           TMP$=TMP$+FNUP$(MID$(FILNM$,I99%,1)):

          NEXT I99%
2120  FILNM$=TMP$: TMP$="" : IF LEN(FILTYP$)=0 THEN 2150
2130  FOR I99%=1 TO LEN(FILTYP$):

           TMP$=TMP$+FNUP$(MID$(FILTYP$,I99%,1)):

          NEXT I99%
2140  FILTYP$=TMP$
2150  FILE$=DR$+":"+FILNM$ 
2160  IF LEN(FILTYP$)>0 THEN FILE$=FILE$+"."+FILTYP$
2170  VALID=1:RETURN      
2180  FILE$=HOLD$:VALID=0:DR$="":FILNM$="":FILTYP$=""
2190  RETURN
2200 'Subroutine:  ERROR  -  Error handling routine
2210  PRINT"ERR = ";ERR;" ERL = ";ERL
2220 STOP
3000 PAUSE=500:FOR I=1 TO PAUSE:NEXT I:RETURN
3500 'Define softkeys
3510  PRINT KUNLK$;
3520  PRINT FNK$(8,"EXIT TO  BASIC");
3530  PRINT KLOCK$;
3540 RETURN
4000 'Write first line of data - line org and linebytes count
4005 PRINT#2,STR$(LINUM);" DATA ";
4010 LINUM=LINUM+10
4015 PRINT#2,ORGADDR;",";LINEBYTES
4020 RETURN
4500 'Write data lines
4510 PRINT#2,STR$(LINUM);" DATA ";
4515 LINUM=LINUM+10
4520 FOR I99=1 TO LINEBYTES
4530 PRINT#2,FNV(MID$(BUF$,8+I99*2,2));
4535 IF I99=LINEBYTES THEN PRINT#2," "
4540 IF I99<>LINEBYTES THEN PRINT#2,",";
4545 IF I99=8 THEN PRINT#2,CHR$(10);"          ";
4550 NEXT I99
4560 RETURN
5000 'Main Entry Point
5010 GOSUB 1550     'Init
5020 PRINT HOME$;CLR$;FNCN$(TITLE$,CW);
5030 GOSUB 1400     'Break
5040 GOSUB 3500   'Define Softkeys
5050 PRINT FNC$(20,0);"Enter hex file name>";CLL$;
5060 SFKOK=1:GOSUB 1600  'sfk are OK; get line of data
5070 IF EOL=0 THEN 5120   'Normal EOL - no sfks
5080 IF EOL=2 THEN 5050   'Line too long
5090 ON FLAG GOTO 5060,5060,5060,5060,5060,5060,5060,5100
5100 'Exit has been pressed
5110 GOTO 8000
5120 'Normal eol
5130 IF INSTR(BUF$,".")=0 THEN FILE$=BUF$+".HEX"
5140 GOSUB 1440  'Clear warn
5150 UPC=1   'Upper case file name
5160 GOSUB 1900   'Check for valid file name in buf$
5170 IF VALID=0 THEN MSG$="Bad File Name. Please re-enter above":

                     GOSUB 1425:

                     GOTO 5050
5180 GOSUB 1800  'Exists check
5190 IF EXISTS=0 THEN MSG$="Cannot find file "+SRC$:

                      GOSUB 1425:

                      GOTO 5050
5200 'File exists, has valid name.
5210 IF INSTR(FILE$,".")=0 THEN SRC$=FILE$:

                                DST$=FILE$+".BAS":

                                GOTO 5250
5220 'File type is with name
5230 SRC$=FILE$
5240 DST$=LEFT$(FILE$,INSTR(FILE$,".")-1)+".BAS"
5250 ON ERROR GOTO 2200
5260 PRINT FNC$(8,5);"Source File Name: ";SRC$
5270 PRINT FNC$(10,5);"Destination Name: ";DST$
5280 PRINT KUNLK$;FNK$(4," CHANGE FILENAME");KLOCK$;
5290 PRINT FNC$(20,0);"Enter Starting Line Number>"; CLL$;
5300 SFKOK=1:GOSUB 1600   'Get a line w/ sfk ok
5310 IF EOL=0 THEN 5390  'Normal EOL
5320 IF EOL=2 THEN 5300  '*********************************
5330 EOL=0  'Set for no re-entry
5340 ON FLAG GOTO 5290,5290,5290,5350,5290,5290,5290,5100
5350 'Change file parameters
5360 PRINT FNC$(8,0);CLL$;FNC$(10,0);CLL$;FNC$(20,0);CLL$;
5370 PRINT KUNLK$;FNK$(4," ");KLOCK$;
5380 GOTO 5030
5390 'Normal EOL on starting line number
5400 PRINT FNC$(20,0);CLL$;
5410 IF LEN(BUF$)=0 THEN FIRSTLINE=32000:

                         GOTO 5440
5420 FIRSTLINE=VAL(BUF$)
5430 IF FIRSTLINE=0 THEN FIRSTLINE=32000:

                         PRINT BELL$;
5440 PRINT FNC$(12,5);"Starting Line Number: ";FIRSTLINE;
5450 PRINT KUNLK$;FNK$(4," ");FNK$(8," ");
5460 'Now open the files, etc
5470 OPEN"I",#1,SRC$
5480 OPEN"O",#2,DST$
5490 TOTBYTE=0:LINEBYTES=0:ORGADDR=0:NUMDATS=0 :LNCNT=0
5500 LINUM=FIRSTLINE+50
5510 IF EOF(1) THEN 5660  '*****************************
5520 LNCNT=LNCNT+1
5530 INPUT#1,BUF$
5540 PRINT FNC$(20,0);"Processing Line ";LNCNT;CLL$;
5550 IF LEFT$(BUF$,7)=":000000" THEN 5670  'Done ****************
5560 IF LEFT$(BUF$,1)<>":" THEN MSG$="Invalid Line in Hex File":

                                GOTO 5510
5570 'Extract Call Address and Number of bytes on this line
5580 ORGADDR=FNV(MID$(BUF$,4,2))*256+FNV(MID$(BUF$,6,2))
5590 LINEBYTES=FNV(MID$(BUF$,2,2))
5600 TOTBYTE=TOTBYTE+LINEBYTES
5610 'Write output file
5620 GOSUB 4000   'Write data w/ org and numbytes this line
5630 GOSUB 4500   'Write however many datas are needed for linebyte
5640 NUMDATS=NUMDATS+1
5650 GOTO 5510   'Read next line
5660 'End w/o zero record
5670 'Normal end of file on input
5680 CLOSE#1  'Finished w/ source
5690 PRINT FNC$(14,5);CLL$;"Input records : ";STR$(LNCNT);
5700 PRINT FNC$(14,40);CLL$;"Processed ";STR$(TOTBYTE);" bytes of code";
5710 PRINT FNC$(20,0);CLL$;"Closing all files:";
5720 'Write original restore and for/next stuff
5730 PRINT#2,STR$(LINUM);" RESTORE ";STR$(FIRSTLINE)
5740 LINUM=LINUM+10
5750 'FOR I99=1 TO NUMDATS
5760 PRINT#2,STR$(LINUM);" FOR I98=1 TO ";STR$(NUMDATS)
5770 LINUM=LINUM+10
5780 PRINT#2,STR$(LINUM);" READ A99,L99"
5790 LINUM=LINUM+10
5800 PRINT#2,STR$(LINUM);" FOR I99=A99 TO A99+L99-1"
5810 LINUM=LINUM+10
5820 PRINT#2,STR$(LINUM);" READ D99: POKE I99,D99   'Read data and poke code"
5830 LINUM=LINUM+10
5840 PRINT#2,STR$(LINUM);" NEXT I99"
5850 LINUM=LINUM+10
5860 PRINT#2,STR$(LINUM);" NEXT I98  'End of routine"
5870 LINUM=LINUM+10
5880 PRINT#2,STR$(LINUM);" RETURN   'End of ";SRC$;" generated code"
5890 LINUM=FIRSTLINE
5900 PRINT#2,STR$(LINUM);" 'Assembly Language Routine: ";SRC$
5910 LINUM=LINUM+10
5920 PRINT#2,STR$(LINUM);" 'Created by HEXIT Rev 1.0 - (c) Miles Kehoe 1982"
5930 LINUM=LINUM+10
5940 PRINT#2,STR$(LINUM);" 'Hewlett-Packard Company"
5950 CLOSE#2
5960 PRINT " Processing Complete"
5970 GOSUB 3000    'Pause
5980 PRINT KUNLK$;FNK$(1,"  START   OVER");FNK$(8,"EXIT TO  BASIC");KLOCK$;
6000 PRINT FNC$(20,0);CLL$;"Select an option:";
6010 SFKOK=1:GOSUB 1600
6020 IF EOL=0 THEN 6400   
6030 IF EOL=2 THEN 6000   'Too long a line
6040 ON FLAG GOTO 6100,6050,6050,6050,6050,6050,6050,8000
6050 PRINT BELL$;
6060 GOTO 6010
6100 'Restart program
6105 GOTO 5010
8000 PRINT FNC$(20,0);CLL$;"End of program"
8010 PRINT KUNLK$;  : WIDTH 80
8020 END

6100 'Restart program
6105 GOTO 5010
8000 PRINT FNC$(20,0);CLL$;"End of program