
program psystem;
{ reads files from APPLE PASCAL UCSD and transfers to UCSD
format.}
{originally written for Turbo Users Group
by Paul Klarreich, Brooklyn, NY and modified for Apple CP/M
by Bill McGee,Nepean, Ontario}
{(c) 1983 Paul Klarreich This program is licensed for
non commercial use.}
type direntry=packed record
  firstblok,lastblok:integer;
  filtype,blank:byte;
  filname:string[15];
  fillast,daterec:integer;
  end;
  sectbuffer=array[0..511]of byte;
  pagebuffer=array[0..1023]of byte;
  short=string[40];
var
  mainbuf:sectbuffer;
  textpage:pagebuffer;
  directory:record case boolean of
    true: (dir:array[0..77] of direntry);
    false: (bufs:array[0..3]of sectbuffer);
  end;

procedure halt;
begin
  bdos(0,0)
end;

function yes(message:short):boolean;
{Gets a yes-no message from the user}
var resp:char;
begin
  write(message);
  repeat
    read(kbd,resp);resp:=upcase(resp);
  until (resp in ['Y','N',chr(27)]);
  if (resp=chr(27)) then halt;
  yes:=(resp='Y')
end;



procedure printentry(var bb:direntry);
begin
  with bb do write(filname:16,'   ',lastblok-firstblok,'  blocks.  ');
  case bb.filtype of
  0,1,5:write('data');
  2    :write('code');
  3    :write('text');
  4    :write('foto');
  6    :write('graf');
  else write('????');
  end;
  write('-file')
end;

function getblock(blockno:integer;var buffer:sectbuffer):integer;
{reads a UCSD block}
var returncode,side,drive,track,sector:integer;
  sectorcount,bufsegment,bufoffset:integer;
  otherbuffer:sectbuffer;
  procedure map(cpmblock:integer; var side,track,sector:integer);
  function apple(cpmsector:integer):integer;
  var evenodd,work:integer;
  begin
    evenodd:=cpmsector mod 2;
    work:=2*(cpmsector div 2);
    if work>15 then work:=(3*work+11) mod 16
    else work:=(3*work) mod 16;
    apple:=2*work+evenodd
  end;
  begin
    side:=0;
    track := cpmblock div 32;
    sector:=apple(cpmblock mod 32)
  end;
const BOOT=0;
      WBOOT=1;
      CONSTAT=2;
      CONIN=3;
      CONOUT=4;
      LIST=5;
      PUNCH=6;
      READER=7;
      HOME=8;
      SELDSK=9;
      SETTRK=10;
      SETSEC=11;
      SETDMA=12;
      CPMREAD=13;
      CPMWRITE=14;
      LISTST=15;
      SECTRAN=16;
var currdsk:byte;
    k:integer;
begin
  currdsk:=bdos(25);
  for k:=0 to 3 do begin
    map(4*blockno+k,side,track,sector);
    write('.');
    bios(SELDSK-1,1);
    bios(SETTRK-1,track);
    bios(SETSEC-1,sector);
    bios(SETDMA-1,addr(buffer[0])+128*k);
    returncode:=bios(CPMREAD-1);
  end;
  getblock:=returncode;
  bios(SELDSK-1,currdsk)
end;

procedure readdir;
var count,result:integer;
begin
  for count:=0 to 3 do begin
    result:=getblock(count+2,directory.bufs[count]);
    if result<>0 then begin
      writeln('Sorry--read error in getting directory');
      halt
    end
  end
end;

procedure getfile(var entry:direntry);
const CPMEOF=26;
var
  outfile:text;
  newname:string[16];
  result,blockno,k:integer;
  procedure pageout(var p:pagebuffer);
  const
    DLE=16; CR=13; ZERO=0; BLANK=32; LF=10; CPMEOF=26;

  var cursor,nblanks:integer;
      nextc,extra:byte;
  begin
    cursor:=0;
    while cursor<=1023 do begin
      nextc:=p[cursor]; cursor:=cursor+1;
      case nextc of
      CR:begin
          write(outfile,chr(nextc));
          write(outfile,chr(CR));
          write(outfile,chr(LF));
         end;
      ZERO:;
      DLE: begin {blank compression - we expand}
        extra:=BLANK;
        nblanks:=p[cursor]-32; cursor:=cursor+1;
        while nblanks > 0 do begin
          write(outfile,chr(BLANK));nblanks:=nblanks-1
        end;
        end;
        else write(outfile,chr(nextc));
      end
    end
  end;
begin
  writeln;write('Please give a CP/M file name ---->');
  readln(newname);assign(outfile,newname);
  {$I-}rewrite(outfile); {$I+}
  result:=ioresult;
  if result<>0 then begin
    writeln('Cant''t create the new file ',newname); halt end;
  with entry do
  if (filtype=3) then begin
    writeln('Reading starts at ',firstblok+2,' and goes for ',
      lastblok-firstblok-2,' blocks.');
    blockno:=firstblok+2;
    while blockno<=lastblok-1 do begin
      for k:=0 to 1 do begin
        result:=getblock(blockno+k,mainbuf);
        if result<>0 then begin
          writeln('Sorry--error reading file');halt end;
        move(mainbuf,textpage[k*512],512)
      end;
      blockno:=blockno+2;
      pageout(textpage)
    end;
    write(outfile,chr(CPMEOF))
  end else begin {not a text file}
    writeln('Reading starts at ',firstblok,' and goes for ',lastblok-firstblok,
      ' blocks.');
    for blockno:=firstblok to lastblok-1 do begin
      result:=getblock(blockno,mainbuf);
      if result<>0 then begin
        writeln('Sorry --  error reading the file'); halt end;
      if blockno<lastblok-1 then for k:=0 to 511 do write(outfile,chr(mainbuf[k]))
      else for k:=0 to 511 do if (k<=fillast)then write(outfile,chr(mainbuf[k]))
        else ;
    end;
  end;
  close(outfile);writeln
end;

var k:integer;
begin
  writeln('Place a p-system disk in drive B');
  writeln('then press <RETURN>.');
  readln;readdir;
  writeln('Finished reading the directory');
  for k:=1 to 77 do begin
    if length(directory.dir[k].filname) in [1..15] then begin
      writeln; printentry(directory.dir[k]);
      if yes('  Copy this file? <ESC> to exit.') then getfile(directory.dir[k])
    end
  end
end.
