program Transliterate;

{reads .pas source files, creating a .new file with selected uppercase
 reserved words.  written in turbo pascal by Glenn Brooke 9/10/85.
 may not be used for commercial profit or resale as a part of a package
 without the express written consent of Glenn Brooke}

{this is basically a demo file :
        -- how to use command line for filenames
        -- the Substitute procedure ; replace parts of strings

 As orginally written (9/11/85), PROCEDURE, FUNCTION, BEGIN, END are
 capatilized.  To modify this, see the Change_case function below}


type
    filename = string[14];
    line = string[255];
    word = string[20];

var
   infilename, outfilename : filename;
   Source, output_file : text;
   dot : integer;
   infile : string[14] absolute$80;   {command line filename}

function Exist(x : filename) : boolean;
var fil : file;
begin
     Assign(fil, x);
     {$I-}
     Reset(fil);
     {$I+}
     Exist := (IOresult = 0)
end;


procedure Xlit(infilename, outfilename : filename);
var
   nextline : line;
   R : char;

      function Change_case(var nextline : line) : line;
      {substitutes selected upper case reserved words}

      procedure Substitute(x : word);
      var i, where : integer;
          nline : line;
      begin
           nline := copy(nextline, 1, length(nextline));
           for i := 1 to length(nline) do nline[i] := upcase(nline[i]);
           where := pos(x, nline);
           if where <> 0 {match found} then
              begin
              insert(x,nextline,where);
              delete(nextline,(where + length(x)),length(x))
              end;
      end; {Substitute}

      begin {Change_case}
            {this is where you can modify what words get capitalized}
            Substitute('PROCEDURE');
            substitute('BEGIN');
            substitute('END');
            substitute('FUNCTION');
            Change_case := nextline;
      end;


begin
     Assign(Source, infilename);
     Reset(Source);
     Assign(Output_file, outfilename);
     Rewrite(Output_file);
     while not eof(Source) do
           begin
           readln(Source, nextline);
           nextline := Change_case(nextline);
           writeln(Output_file, nextline);
           writeln(nextline);      {write to screen, too}
           end;
     close(Source);
     close(Output_file);
end; {Xlit}


begin {main}
      ClrScr;
      writeln('       Pascal Program Transliterator ');
      writeln('               by Glenn Brooke ');
      writeln('             Last Update 9/11/85');
      writeln;
      writeln(' << Reads Pascal source file, capitalizes selected reserved >>');
      writeln(' << words.  Does not reformat the file.  Produces a separate>>');
      writeln(' << .XLT output file >>');
      writeln;
      writeln;

      infilename := infile;
      if infilename = '' then
         begin
         writeln(' USAGE : type XLIT fn.ext at the command line');
         writeln(' {program generates fn.xlt output file} ');
         writeln;
         end
      else if not exist(infilename) then
             begin
             writeln('Cannot find ', infilename);
             writeln
             end
      else {have ok source filename}
          begin
          dot := pos('.',infilename);
          if dot = 0 then outfilename := infilename + '.XLT'
          else
              begin
              outfilename := copy(infilename,1,dot) + 'XLT';
              writeln(' Now transliterating ',infilename,' to ', outfilename);
              writeln;
              Xlit(infilename, outfilename);
              writeln; writeln('##########################'); writeln;
              writeln('Job finished ! ');
              end
          end
end.
