program threeDplot;

{ Written for Kaypro 2-84 / 4-84 / 10 by Robert H. Maxwell
  201-2275 West 7th Avenue, Vancouver, B.C. Canada V6K 1Y3
  BBS NUMBER: Turbo BBS (604) 738-7811 (24 hrs, 300/1200)

  Program may be freely copied and distributed providing
  no charge is made for the program. Program can be modified
  to work with other computers/printers. Some modifications
  to the procedure "drawcurve" are needed to accomodate plotters.

  This program plots in columns from bottom to top, working left
  to right. To plot on a dot-matrix printer, this generally
  means the plot's left side will be a the top of the paper,
  and work downwards, so plot is effectively rotated 90 degrees.

  User hint: by using a printer and properly scaled plots, two plots
  done side-by-side, using slightly different values for "angle"
  (say 5-10 degrees), can be viewed in stereo viewer for true 3-D effect!
}

(*** Define Plot Function parameters here ***)

  const
    angle = 60; {Visual angle between X and Y axes in degrees 1..89}
    lines = 20; {Number of plot lines that will define 3-D figure}
    xmin = -1.0; xmax= 1.0;      {Range of plot variables}
    ymin = -2.0; ymax= 2.0;      { as well as limits of  }
    zmin = -0.25; zmax= 0.75;    {     plotting area     }
    zprop = 0.5; {Fraction of vertical resolution used to show height}
                 {zprop small: "top view";  zprop large: "side view"}

  function plotfunct(x, y: real): real;

  {Define the 3-D plot as a function of X and Y here}

  var r: real;

  begin
    r := 6 * sqrt(x*x + y*y);
    if r = 0 then plotfunct := 1 else plotfunct := sin(r)/r;
  end;

(*** End of Plot Function Parameters ***)

(*** Define Plot Device parameters here ***)

  const
    hresn = 160; {Total Horizonal resolution in dots}
    vresn = 100; {Total Vertical resolution in dots}

procedure initplot;

{Use this procedure to initialize the plotting device}

  begin
    clrscr;
  end;

procedure endplot;

{Clean up at end of plot. Can also loop to prevent disturbing screen}

  begin
    write(^G); {Hey, you! We're done!}
    repeat until keypressed;
  end;

procedure plotXY(x, y: integer);

{Plot the point defined by x and y, where (0,0) is bottom left
 and (hresn-1, vresn-1) is top right of plotting area}

  begin
    write(#27, '*', chr(131 - y), chr(32 + x));
  end;

procedure endrow;

{Procedure is called after each row of vertical dots is plotted:
 use it to dump the row to a printer, for example. If not needed,
 leave this procedure empty.}

  begin
  end;

(*** End of Plot Device parameters ***)

  var
    xrange, yrange, zrange, zstep, yoffset,
    tanang, base, height, y, z, bottom, increment: real;

    x, deltaY, ybase: array[0..lines] of real;

    lastpoint: array[0..lines] of integer;

    constantX, columns, vertical: integer;

    max, min: integer;

function tan(theta: real): real;

  begin
    tan := sin(theta)/cos(theta);
  end;

procedure initialize;

  var loop: 0..lines;
      xposn, xoffset: real;

  begin
    initplot;
    xrange := xmax - xmin;
    yrange := ymax - ymin;
    zrange := zmax - zmin;
    tanang := yrange/xrange/tan(angle * 0.0174533);
    bottom := yrange + xrange*tanang;
    increment := bottom / hresn;
    height := zprop * vresn;
    base := vresn - height;
    zstep := height/zrange;
    for loop := 0 to lines do begin
      xposn := loop/lines;
      ybase[loop] := xposn * base;
      xoffset := xrange * xposn;
      x[loop] := xmin + xoffset;
      deltaY[loop] := xoffset * tanang;
      lastpoint[loop] := -1;
    end;
  end;

function sign(value: integer): integer;

  begin
    if value = 0 then sign := 0 else sign := value div abs(value);
  end;

procedure drawcurve(x, y: integer);

  var oldmax, oldmin: integer;

  begin
    oldmax := max; oldmin := min;
    repeat
      if (y >= oldmax) or (y <= oldmin) then begin
        if y > max then max := y;
        if y < min then min := y;
        if (y >= 0) and (y < vresn) then plotXY(x, y);
      end;
      y := y + sign(lastpoint[constantX] - y);
    until y = lastpoint[constantX];
  end;

begin
  initialize;
  for columns := 0 to (hresn - 1) do begin
    yoffset := ymin + columns * increment;
    max := 0; min := vresn;
    for constantX := 0 to lines do begin
      y := yoffset - deltaY[constantX];
      if (y >= ymin) and (y <= ymax) then begin
        z := plotfunct(x[constantX], y);
        vertical := round(ybase[constantX] + (z - zmin) * zstep);
        if lastpoint[constantX] = -1 then lastpoint[constantX] := vertical;
        drawcurve(columns, vertical);
        lastpoint[constantX] := vertical;
      end else lastpoint[constantX] := -1;
    end;
    endrow;
  end;
  endplot;
end.