;		TITLE    'CCP patch for CM/M 2.2'
;
;
;7/15/81
;
;patch courtesy of the WASHINGTON D.C. AREA CP/M USERS GROUP
;
;Used in conjunction with the Tip offered in Volume 1 No 1
;of 'LIFELINES' (June 1980)  by Andy Johnson-Laird and Cathy
;Strutynsky which makes USER 0 universal to all USERS 
;or all USER areas as in MP/M.
;
;
;This patch to the CCP prints the current USER number along
;with the standard prompt just like MP/M. Example:
;
; 0A>USER 5<cr>
; 5A>B:
; 5B>USER 0
; 0B>A:
; 0A>..........and so forth
;
;Note: Neither the first patch to make USER 0 universal nor
;      this patch will fit in the memory area for the CCP or
;      BDOS. 
;      
;      The patches are best implemented in a CPMXX.COM file
;      which you have saved; where XX is the size of your
;      system.
;
;      A free memory area in your bios should be found and
;      the patches assembled to operate at this address.
;
;      Load the CPMXX.COM file with DDT, compute offsets
;      to the appropriate load address for the patch and
;      jumps. Once the patches are implemented in the 
;      CPMXX.COM file; save it; and finally sysgen the
;      patched system.
;
;
bdos		equ	0dd00h		;Change this address to the
					;start address of your bdos.
					;
ccp		equ	bdos - 800h	;The CCP is 800h in length
					;
					;
patch1area	equ	0fe06h		;You will have to change
					;this address to point to
					;a free memory area large
					;enough to hold the patch.
					;Bios or Bios user's area
					;is recommended.
					;
					;
;This code will be placed into your CCP at the start of ccp plus 388h
;and will cause a jump to the patch.
					;
	org	ccp+388h		;The jump will be
	jmp	patch1			;overlaying:	call	XXXX
					;next inst:	adi	41h
					;
					;
;This code will be placed in your BIOS at the location you have
;determined as free and indicated above as patch1area.
					;
					;
	org	patch1area
patch1:	call	ccp + 0113h		;call ccp routine to
					; get current user number.
	cpi	09			;check if zero thru nine
					; or if two digits
					; ten thru fifteen.
	jnc	double			;jump if two digits.
	adi	30h			;else convert to ascii.
single:	call	ccp + 08ch		;call ccp conout routine.
	call	ccp + 01D0h		;call ccp routine to
					; get the drive number;
					; this call was replaced by
					; the jump patch1 instruction.
	jmp	ccp + 38Bh		;return where ccp left off.
					;
double:	adi	26h			;subtract 10 from the user
					; number; the remainder 
					; will be the second digit.
					; Add 30 to convert it to 
					; ascii or just add 26h to
					; accomplish both.
	push	psw			;save the second digit
	mvi	a,31h			;load an ascii 'one'
	call	ccp + 08ch		;call ccp conout routine
	pop	psw			;return second digit
	jmp	single			;output second digit
					; and return
;
	end
