#include <a:bdscio.h>
#include "pacdefs.h"

update()
{
	char	str[10];

	sprintf(str, "%6d", pscore);
	SPLOT(0, 52, str);
	sprintf(str, "%6d", goldcnt);
	SPLOT(21, 57, str);
}

reinit()
{
	register int locx, locy;
	register char tmp;

	for (locy = 0; locy < BRDY; locy++)
	{
		for (locx = 0; locx < BRDX; locx++)
		{
			tmp = initbrd[locy][locx];
			brd[locy][locx] = tmp;
			if ((display[locy][locx] = tmp) == CHOICE)
			{
				display[locy][locx] = GOLD;
			};
		};
	};
	goldcnt = GOLDCNT;
	delay -= (delay / 10);	/* hot it up */
}

errgen(string)
char	*string;
{
	SPLOT(23,45,string);
}

dokill(mnum)
	int mnum;
{
	register struct pactyp *mptr;

	PLOT(0, 0, BEEP);
	if (pacptr->danger == TRUE)
	{
		if (++killcnt == MAXMONSTER)
		{
			if (display[TRYPOS][TRXPOS] == GOLD)
			{
				goldcnt--;
			};
			display[TRYPOS][TRXPOS] = TREASURE;
			PLOT(TRYPOS, TRXPOS, TREASURE);
			killcnt = 0;
		};
		SPLOT(5, 45, "MONSTERS KILLED: ");
		sprintf(message, "%1d", killcnt);
		SPLOT(5, 62, message);
		mptr = (&monst[mnum]);
		mptr->ypos = MSTARTY;
		mptr->xpos = MSTARTX + (2 * mnum);
		mptr->stat = START;
		PLOT(mptr->ypos, mptr->xpos, MONSTER);
		pscore += KILLSCORE;
		return(GOTONE);
	};
	return(TURKEY);
}

/*
 * clr -- issues an escape sequence to clear the display
 */

clr()
{
	puts(CLEARS);
	nap(4);
}

/*
 *	display initial instructions
 */

instruct()
{
	clr();
	POS(0, 0);
	printf("Attention: you are in a dungeon, being chased by monsters!\r\n\n");
	printf("There are gold coins scattered uniformly in the dungeon, marked by \"+\".\r\n");
	printf("One magic potion is available at each spot marked \"%\". Each potion will\r\n");
	printf("enable you to kill monsters by touch for a limited duration. It will also\r\n");
	printf("scare them away. When you kill a monster it is regenerated, but this takes\r\n");
	printf("time. You can also regenerate yourself %d times. Killing all the monsters\r\n", MAXPAC);
	printf("results in further treasure appearing magically somewhere in the dungeon,\r\n");
	printf("marked by \"$\". There is a magic tunnel connecting the center left and\r\n");
	printf("center right parts of the dungeon. The monsters know about it!\r\n\n");
	printf("        Type:   h       to move left\r\n");
	printf("                l       to move right\r\n");
	printf("                k or w  to move up\r\n");
	printf("                j or x  to move down\r\n");
	printf("                <space> to halt \r\n");
	printf("                q       to quit\r\n\n");
	printf("        Type:   1       normal game\r\n");
	printf("                2       blinking monsters\r\n");
	printf("                3       intelligent monsters\r\n");
	printf("                4       blinking intelligent monsters\r\n");
}

/*
 * over -- game over processing
 */

over()
{
	register int i;
	register int line;
/*
	int scorefile = 0;
	struct passwd *getpwuid(), *p;
*/
	sleep(50);	/* for slow readers */
	poll(0);	/* flush and discard input from player */
	clr();
	/* high score to date processing */
	if (game != 0)
	{
		line = 7;
		POS(line++, 20);
		printf(" ___________________________ ");
		POS(line++, 20);
		printf("|                           |");
		POS(line++, 20);
		printf("| G A M E   O V E R         |");
		POS(line++, 20);
		printf("|                           |");
		POS(line++, 20);
		printf("| Game type: %1d              |",game);
/*
		if ((scorefile = open(MAXSCORE, O_RDWR | O_CREAT, 0666)) != -1)
		{
			read(scorefile, (char *)scoresave, sizeof(scoresave));
			for (i = MSSAVE - 1; i >= 0; i--) {
				if (scoresave[game - 1].entry[i].score < pscore)
				{
					if (i < MSSAVE - 1)
					{
						scoresave[game - 1].entry[i + 1].score =
							scoresave[game - 1].entry[i].score;
						scoresave[game - 1].entry[i + 1].uid =
							scoresave[game - 1].entry[i].uid;
					};
					scoresave[game - 1].entry[i].score = pscore;
					scoresave[game - 1].entry[i].uid = getuid();
				};
			};
			lseek(scorefile, 0l, 0);
			write(scorefile, (char *)scoresave, sizeof(scoresave));
			close(scorefile);
			POS(line++, 20);
			printf("| High Scores to date:      |");
			for (i = 0; i < MSSAVE; i++)
			{
				setpwent();
				p = getpwuid(scoresave[game - 1].entry[i].uid);
				POS(line++, 20);
				printf("| Player : %-8s  %5u  |", p->pw_name,
					scoresave[game - 1].entry[i].score);
			};
		}
		else
		{
			POS(line++, 20);
			printf("|                           |");
			POS(line++, 20);
			printf("| Please create a 'paclog'  |");
			POS(line++, 20);
			printf("| file. See 'MAXSCORE' in   |");
			POS(line++, 20);
			printf("| 'pacdefs.h'.              |");
		};
 */
		POS(line++, 20);
		printf("|                           |");
		POS(line++, 20);
		printf("| Your score: %-5u         |", pscore);
		POS(line, 20);
		printf("|___________________________|");
	};
	leave();
}

/*
 * leave -- flush buffers,kill the Child, reset tty, and delete tempfile
 */

leave()
{
	POS(23, 0);
	puts(CURSORON);
	exit(0);
}

/*
 * init -- does global initialization and spawns a child process to read
 *      the input terminal.
 */

init()
{
	register int tries;

	tries = 0;
	TTYMode(0);	/* Tell cio.c to be REALLY raw! */
	initPOS();	/* initialize the fixed part of posnstr */
	pacsymb = PACMAN;
	pacptr = &pac;

	strcpy(initbrd[0], "#######################################");
	strcpy(initbrd[1], "# . . . * . . . . ### . . . . * . . . #");
	strcpy(initbrd[2], "# % ### . ##### . ### . ##### . ### % #");
	strcpy(initbrd[3], "# * . . * . * . * . . * . * . * . . * #");
	strcpy(initbrd[4], "# . ### . # . ########### . # . ### . #");
	strcpy(initbrd[5], "# . . . * # . . . ### . . . # * . . . #");
	strcpy(initbrd[6], "####### . ##### . ### . ##### . #######");
	strcpy(initbrd[7], "      # . # . . * . . * . . # . #      ");
	strcpy(initbrd[8], "      # . # . ### - - ### . # . #      ");
	strcpy(initbrd[9], "####### . # . #         # . # . #######");
	strcpy(initbrd[10],"        * . * #         # * . *        ");
	strcpy(initbrd[11],"####### . # . #         # . # . #######");
	strcpy(initbrd[12],"      # . # . ########### . # . #      ");
	strcpy(initbrd[13],"      # . # * . . . . . . * # . #      ");
	strcpy(initbrd[14],"####### . # . ########### . # . #######");
	strcpy(initbrd[15],"# . . . * . * . . ### . . * . * . . . #");
	strcpy(initbrd[16],"# % ### . ##### . ### . ##### . ### % #");
	strcpy(initbrd[17],"# . . # * . * . * . . * . * . * # . . #");
	strcpy(initbrd[18],"### . # . # . ########### . # . # . ###");
	strcpy(initbrd[19],"# . * . . # . . . ### . . . # . . * . #");
	strcpy(initbrd[20],"# . ########### . ### . ########### . #");
	strcpy(initbrd[21],"# . . . . . . . * . . * . . . . . . . #");
	strcpy(initbrd[22],"#######################################");

	strcpy(brd[0], "#######################################");
	strcpy(brd[1], "# . . . * . . . . ### . . . . * . . . #");
	strcpy(brd[2], "# % ### . ##### . ### . ##### . ### % #");
	strcpy(brd[3], "# * . . * . * . * . . * . * . * . . * #");
	strcpy(brd[4], "# . ### . # . ########### . # . ### . #");
	strcpy(brd[5], "# . . . * # . . . ### . . . # * . . . #");
	strcpy(brd[6], "####### . ##### . ### . ##### . #######");
	strcpy(brd[7], "      # . # . . * . . * . . # . #      ");
	strcpy(brd[8], "      # . # . ### - - ### . # . #      ");
	strcpy(brd[9], "####### . # . #         # . # . #######");
	strcpy(brd[10],"        * . * #         # * . *        ");
	strcpy(brd[11],"####### . # . #         # . # . #######");
	strcpy(brd[12],"      # . # . ########### . # . #      ");
	strcpy(brd[13],"      # . # * . . . . . . * # . #      ");
	strcpy(brd[14],"####### . # . ########### . # . #######");
	strcpy(brd[15],"# . . . * . * . . ### . . * . * . . . #");
	strcpy(brd[16],"# % ### . ##### . ### . ##### . ### % #");
	strcpy(brd[17],"# . . # * . * . * . . * . * . * # . . #");
	strcpy(brd[18],"### . # . # . ########### . # . # . ###");
	strcpy(brd[19],"# . * . . # . . . ### . . . # . . * . #");
	strcpy(brd[20],"# . ########### . ### . ########### . #");
	strcpy(brd[21],"# . . . . . . . * . . * . . . . . . . #");
	strcpy(brd[22],"#######################################");

	strcpy(display[0], "#######################################");
	strcpy(display[1], "# . . . . . . . . ### . . . . . . . . #");
	strcpy(display[2], "# % ### . ##### . ### . ##### . ### % #");
	strcpy(display[3], "# . . . . . . . . . . . . . . . . . . #");
	strcpy(display[4], "# . ### . # . ########### . # . ### . #");
	strcpy(display[5], "# . . . . # . . . ### . . . # . . . . #");
	strcpy(display[6], "####### . ##### . ### . ##### . #######");
	strcpy(display[7], "      # . # . . . . . . . . # . #      ");
	strcpy(display[8], "      # . # . ### - - ### . # . #      ");
	strcpy(display[9], "####### . # . #         # . # . #######");
	strcpy(display[10],"        . . . #         # . . .        ");
	strcpy(display[11],"####### . # . #         # . # . #######");
	strcpy(display[12],"      # . # . ########### . # . #      ");
	strcpy(display[13],"      # . # . . . . . . . . # . #      ");
	strcpy(display[14],"####### . # . ########### . # . #######");
	strcpy(display[15],"# . . . . . . . . ### . . . . . . . . #");
	strcpy(display[16],"# % ### . ##### . ### . ##### . ### % #");
	strcpy(display[17],"# . . # . . . . . . . . . . . . # . . #");
	strcpy(display[18],"### . # . # . ########### . # . # . ###");
	strcpy(display[19],"# . . . . # . . . ### . . . # . . . . #");
	strcpy(display[20],"# . ########### . ### . ########### . #");
	strcpy(display[21],"# . . . . . . . . . . . . . . . . . . #");
	strcpy(display[22],"#######################################");

	killcnt = 0;
	srand(0);	/* start rand randomly */
	delay = 2000;
	/*
	 * New game starts here
	 */
	game = 0;
	instruct();
	while (game == 0)
		poll(1);

	goldcnt = GOLDCNT;
	pscore = 0;
	clr();
	puts(CURSOROFF);
}

/*
 * poll -- read characters sent by input subprocess and set global flags
 */

poll(sltime)
{
	int stop;
	int command;

	if(!kbhit())
		return;
readin:
	command = getchar();

	switch(command & 0177)
	{
	case LEFT:
		pacptr->dirn = DLEFT;
		break;

	case RIGHT:
		pacptr->dirn = DRIGHT;
		break;

	case NORTH:
	case NNORTH:
		pacptr->dirn = DUP;
		break;

	case DOWN:
	case NDOWN:
		pacptr->dirn = DDOWN;
		break;

	case HALT:
		pacptr->dirn = DNULL;
		break;

	case ABORT:
	case DELETE:
	case QUIT:
		over();
		break;

	case CNTLS:
		stop = 1;
		goto readin;

	case GAME1:
		game = 1;
		break;

	case GAME2:
		game = 2;
		break;

	case GAME3:
		game = 3;
		break;

	case GAME4:
		game = 4;
		break;

	default:
		goto readin;
	}
}


getrand(range)
	int range;
{
	unsigned q;

	q = rand();
	return(q % range);
}

/*
 * Dummy nap() function
 */
nap(x)
{
	int i;
	for(i=0;i<20*x;i++);
}

/*
 * The PLOT function is normally defined using a preprocessor macro:
 * #define PLOT(A,B,C)  POS(A,B);putchar(C)
 */
PLOT(row,col,ch)
int row,col;
char ch;
{
	POS (row, col);
	putchar(ch);
}

/*
 * The SPLOT function is normally defined as:
 * #define SPLOT(A,B,S) POS(A,B);printf("%s",s)
 */
SPLOT(row,col,str)
int row,col;
char *str;
{
	POS (row, col);
	puts(str);
}

/* This function is called at initialization time to set up
 * the fixed portion of the cursor positioning string.
 */
initPOS()
{
	posnstr[0] = ESC;
	posnstr[1] = 'Y';
	posnstr[4] = '\0';
}

/*
 * The POS function us normally defined, using termcap, as:
 * #define POS(row,col) tputs(tgoto(vs_cm,(col),(row),1,putch)
 */
POS(row,col)
int row,col;
{
	posnstr[2] = 32 + row;
	posnstr[3] = 32 + col;
	puts(posnstr);
} readin;
	}
}


getr