* SETDATE.CMD      Steve Brecher       08Apr84
*
* This procedure arose out of dissatisfaction with the date-getting command
* file distributed by Ashton-Tate, which allows an illegal date without
* complaint.  For example, input of <digit><space><digit><space><digit><digit>
* looks like a dandy date on the screen and is accepted, but leaves DATE() as
* garbage.
*
* This procedure will display the previous system date, which it gets into
* MDate from SYSDATE.MEM (01Jan84 if SYSDATE.MEM doesn't exist).  It will
* prompt the user to re-type (over-type) as much of the date as needs
* to be changed.  The user presses RETURN if no change, types just the
* day-of-month and RETURN if only the day has changed, etc.  The format
* ddmmmyy (e.g., 08Apr84 ) is used because of its international nonambiguity
* and because the day,month,year order is most convenient for partial changes.
* It is converted to mm/dd/yy internally to satisfy dBase.
*
* The user is locked in until a valid date from 01Jan84 through 31Dec99
* is entered.  Then the dBase system date and the file SYSDATE.MEM are
* updated.  Memory variable MDate, in format mm/dd/yy, is set to the
* current date.
*
* The mm/dd/yy format is assumed for the dBase system date.  If it has
* been changed to dd/mm/yy via INSTALL, some string indexes below will
* need to be changed.
*
* The first two set commands are a matter of personal preference.  If COLON
* is not set OFF, then the ":" should be deleted from the Prompt string.
*
* The procedure exits with TALK set ON.
*
set colon off
set bell off
set talk off
store "Re-type as much as necessary: " to Prompt
store "JanFebMarAprMayJunJulAugSepOctNovDec" to MonthNames
if file("sysdate.mem")
  restore from sysdate
else
  store "01/01/84" to MDate
endif
*
* MDate           format is mm/dd/yy
* OldDate,NewDate format is ddmmmyy
*
store $(MDate,4,2)+$(MonthNames,val($(MDate,1,2))*3-2,3)+$(MDate,7,2) ;
      to OldDate
store F to DateOk
erase
do while .not. DateOk
  store OldDate to NewDate
  @ 1,0 say Prompt get NewDate
  read
  store trim(NewDate) to TrimDate
  if len(TrimDate) < 7
    store TrimDate+$(OldDate,len(TrimDate)+1,7-len(TrimDate)) to NewDate
    endif
  if $(NewDate,6,2)<"84".or.$(NewDate,6,2)>"99"
    loop
    endif
  if $(!(NewDate),3,3)$!(MonthNames)
    store (@($(!(NewDate),3,3),!(MonthNames))+3) / 3 to Month
  else
    loop
    endif
  store $("312831303130313130313031",Month*2-1,2) to MaxDay
  if Month=2 .and. $(NewDate,6,2)$"84,88,92,96"
    store "29" to MaxDay
    endif
  if $(NewDate,1,2)<"01".or.$(NewDate,1,2)>MaxDay
    loop
    endif
  store T to DateOk
  enddo
store str(Month,2)+"/"+$(NewDate,1,2)+"/"+$(NewDate,6,2) to MDate
if " "$Mdate
  store "0"+$(Mdate,2,7) to MDate
  endif
set date to &MDate
release all except MDate
save to sysdate
set talk on
return
 store "0"+$(Mdate,2,7) to MDate
  endif
