/* James' Justification & Print Program

  purpose: takes files created with perfect writer and justifies and
	   prints them on a gemini printer.  Justification commands
	   supported are listed below.  Paragraphs must start with a
	   tab. This program is written in C for the C/80 compiler.
*/
#define VT '\013'
#define HT '\011'
#define FF '\014'
#define WORDLEN    20
#define NUMLINES   56
#define NUMWORDS   15
#define NONE 	    0
#define UNDERLINE   1
#define SUBSCRIPT   2
#define CENTER      3
#define SUPERSCRIPT 4
#define RIGHT	    5
#define LEFT	    6
#define ITALICS     8
#define DSTRIKE    16
#define TRUE  	    1
#define FALSE       0
#define EOF        -1
#define SIZE       65
#include "printf.c"
char word[NUMWORDS][WORDLEN];
int apres[NUMWORDS],fstart[SIZE],letter,pageno,fend[SIZE],
    con,chan,ptr,stack[8],sp,place, wordnow, double, number, paraflag,
    wordlong[NUMWORDS],lines,wordsize,wordcount,linelen;
main (argc, argv)
char *argv[];
int argc;
{
int atfound,last,leftnow,rightnow, i, k, c;
char file[15];
con = fopen("CON:","u");
fprintf(con,"             James' Justification and Print Program\n\n");
if (argc == 1) {
    fprintf(con,"Usage: jp filename\n\n");
    fprintf(con," Formatting commands accepted:\n\n");
    fprintf(con," @u{..}  Underline    @b{..}  suBscript    @p{..}  suPerscript\n");
    fprintf(con," @r{..}  Rightify     @l{..}  Leftify      @c{..}  Centre\n");
    fprintf(con," @d{..}  Doublestrike @i{..}  Italics      @s	    Section\n\n");
    fprintf(con," Please use lower case for formatting commands;\n");
    fprintf(con," and use tabs to start paragraphs.\n");
    exit();}
/* Open printer */
ptr = fopen("LST:","w");
if (!ptr) {
    fprintf(con,"Can't open printer\n");
    exit(); }
/* Open input file */
chan = fopen(argv[1],"r");
if (chan == 0){
    fprintf(con,"Unable to open file: %s\n",argv[1]);
    exit();}
/* Ask option questions */
fprintf(con," Double spaced (y/n)? ");
double = giveresp();
fprintf(con," Pages numbered (y/n)? ");
number = giveresp();
/* Printer set up */
fprintf(ptr,"\033P\004\076");    /*  set vertical tabs at lines 4 & 62 */
putc('\0',ptr);
fprintf(ptr,"\033D\040");	 /*  set horizontal tab for page number at 40*/
putc('\0',ptr);
putc(VT,ptr);			 /* Go to line 4 */
/*   initialisation phase */
for (i=0;i<=NUMWORDS;apres[i++]=0);  
for (i=0;i<=SIZE;i++) { fstart[i] = NONE; fend[i] = NONE; }
lines = pageno = 1;
/*   Main loop starts */
while (1) {
/*   Per program initialisation  */
leftnow = paraflag = rightnow = atfound = wordnow = FALSE;
sp = letter = place = linelen = wordcount = 0; 
/* Input data to be formatted here */
while ((c = getc(chan)) != EOF) {
    c = c & 127;
    switch (c) {
    case '\012':
    case '\015':
    case ' ': finishword();       /* blank, cr, lf end a word */
	      if (c == '\012' && leftnow) 
		dumpline();
	      else if (c == '\012' && rightnow) rightfix();
              break;
    case '\t': if (wordcount) {   /* tab starts a paragraph */
	      	dumpline();
	      	linefeed(); }
       	      paraflag = TRUE;
	      linelen = 2;
	      break;
    case '@': atfound = TRUE;	/* at character used in formatting commands */
              break;
    case '{': if (atfound) {    /* { used in formatting */
		atfound = FALSE;
		stack[sp++] = last; /* push bracket indicator on stack */
		if (!(last==CENTER || last==RIGHT || last==LEFT))
		    fstart[place] |= last;
                break; }
	      else stack[sp++] = NONE;
    case '}': last = pop();	/* } used in formatting */
	      if (last) {
		switch (last) {
		    case UNDERLINE:
		    case SUBSCRIPT:
		    case SUPERSCRIPT:
		    case ITALICS:
		    case DSTRIKE: fend[place-1] |= last;
				  break;
		    case CENTER: finishword();
				 centerfix();
				 break;
		    case RIGHT: finishword();
				rightfix();
				rightnow = FALSE;
				break;
		    case LEFT: finishword();
		 	       dumpline(); 
			       leftnow = FALSE;
                  	       break; 
		}
		break;
	    }
/*    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9': if (atfound) {
		 sum = (sum * 10) + (c - '0');
		 break; } */
    case 's': if (atfound) {	/* Print the section character */
		atfound = FALSE;
		c = 201; }
    case 'r': if (atfound) {	/* rightify */
		linelen = 0;
		paraflag = FALSE;
		last = RIGHT;
		rightnow = TRUE;
		break; }
    case 'l': if (atfound) {	/* leftify */
		linelen = 0;
		leftnow = TRUE;
		last = LEFT;
		paraflag = FALSE;
		break; }
    case 'c': if (atfound) {	/* center */
		linelen = 0;
		paraflag = FALSE;
		last = CENTER;
		break; }
    case 'b': if (atfound) {	/* subscript */
		las  SUBSCRIPT;
	 	break; }
    case 'p': if (atfound) {	/* superscript */
		last = SUPERSCRIPT;
		break; }
    case 'i': if (atfound) {	/* italics */
		last = ITALICS;
		break; }
    case 'd': if (atfound) {	/* doublestrike */
		last = DSTRIKE;
		break; }
    case 'u': if (atfound) {	/* underline */
		  last = UNDERLINE;
                  break; }
    default: if (atfound) {
		word[wordcount][letter++] = '@';
		atfound = FALSE; }
	     word[wordcount][letter++] = c;  /* else add letter to word */
	     place++;
	     wordnow = TRUE;
	     break;
    }
/* If long enough, either dump (add no spaces) or justify line */
    if ((linelen-1) == SIZE) 
	dumpline();
    else if ((linelen-1) > SIZE) 
	justify();
}
/* finish off last word, close file, dump line */
word[wordcount++][letter] = '\0';
fclose(chan);
dumpline();
chan = 0;
/* ask for next file & open it */
while (!chan) { 
    fprintf(con," Next file name or <Return> if done? ");
    getline(file);
    if (file[0] == '\0') break;
    chan = fopen(file,"r");
    if (!chan)
	fprintf(con," Cannot Open: %s\n",file);
}
if (!chan) break;
}
/* when done, put on page number if desired, close files */
if (number) {
	putc(VT,ptr);
	putc(HT,ptr);
	fprintf(ptr,"%d\n",pageno++);
	putc(VT,ptr); }
else putc(FF,ptr);
fclose(ptr);
fclose(con);
exit();
}

/* pop a bracket indicator from the stack */
pop() {
    if (sp) return(stack[--sp]);
    else return(0);
}

/*resetdisk() {
#asm
    MVI  C,0DH
    CALL 0005H
#endasm
}*/

/* Input a line from the console */
getline(data) 
char data[];
{
    int c,i;
    i = 0;
    while ((c = getchar()) != '\012')
	data[i++] = c; 
    data[i] = '\0';
}

/* center text */
centerfix() {
int j;
    linelen--;
    linelen = SIZE - linelen;
    linelen /= 2;
    for (j=1;j<=linelen;j++) putc(' ',ptr);
    dumpline();
}

/* rightify text */
rightfix() {
int j;
    linelen--;
    linelen = SIZE - linelen;
    for (j=1; j<=linelen; j++) putc(' ',ptr);
    dumpline();
}

/* print paragraph spaces if necessary */
paragraph() {
    if (paraflag) {
	fprintf(ptr,"  "); 
	paraflag = FALSE;}
}

/* Dump a line: print it, adding no spaces to it */
dumpline() {
int j;
       paragraph();
       place = 0;
       for (j=0;j<=wordcount-1;j++) {
		showword(j);
		putc(' ',ptr); }
       linefeed();
       linelen = place = wordcount = 0;
}

/* add end character on word */
finishword() {
if (wordnow) {
    wordnow = FALSE;
    wordlong[wordcount] = letter; 
    word[wordcount++][letter] = '\0';
    linelen += (letter + 1);
    wordsize = letter;
    letter = 0; }
}

/* justify and print a line */
justify() {
int perword, extra, j, k, d;
       paragraph();
       place = 0;
       wordcount--;
/* calculate number of spaces to add */
       linelen -= (wordsize +2);
       linelen = SIZE - linelen;
       perword = (linelen / wordcount);
       extra = linelen % wordcount;
/* figure out where to add spaces */
	if (extra) {
 	    for (j=0;j<(wordcount-2);j++) {
		d = word[j][(wordlong[j] - 1)];
		if (d=='.' || d==',' || d==';' || d=='?' || d=='!') {
		    apres[j]++;
		    extra--; 
		    if (!extra) break; }
	    }
	}
	if (extra) {
	    for (k=1;k<=WORDLEN;k++) {
		for (j=0;j<(wordcount-2);j++) {
		    if (!apres[j]&&(wordlong[j] == k || wordlong[j+1] == k)) {
			apres[j]++;
			extra--; 
		        if (!extra) break; }
		}
		if (!extra) break;
	    }
	} 
/* Print the words */
       for (j=0;j<=(wordcount-1);j++){
	   showword(j);
           for (k=0;k<=perword;k++)
               putc(' ',ptr);
/* add spaces */
	   for (k=1;k<=apres[j];k++) {
	       putc(' ',ptr); 
	       apres[j] = 0; }
       }
       linefeed();
/* save last word for next sentence */
       for (j=0;j<=wordsize;j++)
		word[0][j] = word[wordcount][j];
       linelen = wordsize+1;
       wordcount = 1;
       place = wordsize;
}

/* Print a word and add in printer instructions */
showword(j)
int j; {
int k = 0;
  while (word[j][k] != '\0') {
/* print pre-letter printer instructions */
    if (fstart[place]) {
	if (fstart[place] & UNDERLINE) 
	    fprintf(ptr,"\033-\001"); 
	if (fstart[place] & SUBSCRIPT)
	    fprintf(ptr,"\033S\001"); 
	if (fstart[place] & SUPERSCRIPT) {
	    fprintf(ptr,"\033S"); putc('\0',ptr);}
	if (fstart[place] & ITALICS) 
	    fprintf(ptr,"\0334"); 
	if (fstart[place] & DSTRIKE) 
	    fprintf(ptr,"\033G"); 
	fstart[place] = NONE;
    }
/* print letter */
    putc(word[j][k++],ptr);
/* print post-letter printer instructions */
    if (fend[place]) {
	if (fend[place] & UNDERLINE) {
	    fprintf(ptr,"\033-"); putc('\0',ptr); }
	if (fend[place] & SUBSCRIPT) 
	    fprintf(ptr,"\033T"); 
	if (fend[place] & SUPERSCRIPT)
	    fprintf(ptr,"\033T"); 
	if (fend[place] & ITALICS) 
	    fprintf(ptr,"\0335"); 
	if (fend[place] & DSTRIKE) 
	    fprintf(ptr,"\033H");
	fend[place] = NONE; 
    }
    place++;
  }
}

/* print linefeed, count lines, end page if nec */
linefeed() {
    putc('\n',ptr);
    lines++;
    newpage();
    if (double) {
	putc('\n',ptr);
    	lines++;
	newpage();}
}

/* Print page number and go to new page when nec. */
newpage() {
    if (lines > NUMLINES) {
	putc(VT,ptr);
	putc(HT,ptr);
	if (number) fprintf(ptr,"%d\n",pageno++);
	putc(VT,ptr);
	lines = 1;}
}

/* get a y/n response from the console. <cr> = no */
giveresp() {
char resp[10];
    getline(resp);
    if (resp[0] == 'y' || resp[0] == 'Y')
	return(TRUE);
    else
	return(FALSE);
}
