/* isqrt - returns greatest unsigned int <= sqrt(arg)           */
/*                                                      1982/10/16 22:43
        submitted by    William G. Hutchison, Jr.
                        P.O. Box 278
                        Exton, PA 19481-0278
                        U.S.A.

                        CompuServe 70665,1307

 */

#ifdef UNIX
unsigned
#endif
isqrt(a)unsigned a;
{
        register unsigned x, y, z;
        for(x= 0, y=z=1; y<=a; x++) y+=(z+=2);
        return(x);
}
/* end isqrt */

/* Alagic, Suad & Arbib, Michael A. "The Design of Well Structured
and Correct Programs" Springer-Verlag, New York 1978, p. 166.   */

#ifdef MAINLY
#else
#include "c80def.h"
#include "printf.c"

main(){
        unsigned n;
        for (n= 0; n < 32767; n++)
                printf("%3d <= sqrt(%d)\n", isqrt(n), n);
} /* end main */

#endif
/* mult - multiply unsigned ints by the Rhind papyrus method    */
/*                                                      1982/10/16 22:49
        submitted by    William G. Hutchison, Jr.
                        P.O. Box 278
                        Exton, PA 19341-0278
                        U.S.A.

                        CompuServe 70665,1307

 */

#ifdef UNIX
unsigned
#endif
mult(a,b)unsigned a, b;
{
        register unsigned x, y, z; 
        x= a; 
        y= b; 
        z= 0; 
        while(y){
                while(y && ((y&1) == 0)){
                        y>>=1; 
                        x+=x;
                }
                y--;
                z+=x;
        }
        return(z);
} /* end mult */

/* Alagic, Suad & Arbib, Michael A. "The Design of Well Structured
and Correct Programs" Springer-Verlag, New York 1978, p. 243.   */

#ifdef MAINLY
#else
#include "c80def.h"
#include "printf.c"

main(){
        unsigned a, b, e;
        printf("Starting test of mult\n");
        for(e= a= 0; a < 256; a++){
                for(b= 0; b < 256; b++)
                        if(a*b != mult(a,b))
                                printf("Error #%d: %d*%d = %d?\n", ++e,
				a, b, mult(a,b));
                printf("%d tests finished.\n", 256*(a+1));
        }
        printf("Testing found %d errors.\n", e);
} /* end main */
#endif
