
/* Program in Small-C to convert a regular text file to Wordstar
   'document' format with soft spaces and carriage returns.

	by Gordon Brandly, R.R.2, Fort Sask., AB, CANADA  T8L 2N8
*/

#define CR 13
#define LF 10
#define EOF -1
#define FALSE 0
#define TRUE 1
#define CPM_EOF 26	/* CP/M's control-Z end of file character */

char startline, inword;
int *inptr, *outptr;

main(){
	char infile[16], outfile[16];
	int c;
	startline=TRUE;
	inword=FALSE;
	putchar(CR);
	puts("ENSOFT version 1.0:"); putchar(CR);
	puts("Converts text files to Wordstar document format.");
	putchar(CR); putchar(CR);
	while (1){	/* loop until we get a valid file name */
		puts("Input file's name? "); gets(infile);
		inptr=fopen(infile,"r");
		if (inptr!=0)  break;
		puts("Can't open '");
		puts(infile); puts("' for input.");
		putchar(CR); putchar(CR);
	}
	putchar(CR);
	puts("Output file's name? "); gets(outfile);
	outptr=fopen(outfile,"w");
	if (outptr==0){
		putchar(CR); puts("Can't open '");
		puts(outfile);
		puts("' for output. The disk directory is probably full.");
		exit();
	}
	/* main loop */
	while ((c=getc(inptr))!=EOF)
		putc(translate(c),outptr);
	fclose(inptr);
	fclose(outptr);
}

translate(c)
    int c; {
	if (c==CR){
		if (startline)
			return(c);	/* empty lines are 'hard' */
		else {
			c=getc(inptr);
			if (c==' '){	/* lines beginning with a space */
					/* probably begin a new paragraph */
				putc(CR,outptr);
			}
			else if ((c==CR)|(c==EOF)){
				putc(CR,outptr);   /* end of a paragraph? */
			}
			else {
				putc((CR | 128),outptr);
				putc(LF,outptr);  /* needed for Small-C */
			}
			startline=TRUE;
			return(translate(c));
		}
	}

	else if (c==' '){
		if (inword){
			inword=FALSE;	/* we just finished a word, */
			return(c);	/* so this is a 'hard' space */
		}
		if (startline)
			return(c);	/* spaces at the beginning of */
					/* a line are also 'hard' spaces */
		return(c | 128);
	}

	else if (c==EOF) {
		return(CPM_EOF);
	}

	else {
		inword=TRUE;	/* any other character counts as a word */
		startline=FALSE;
		return(c);
	}

}

                             ENSOFT
  A program to convert text files to Wordstar 'document' format


          by Gordon Brandly
          R.R. 2
          Fort Saskatchewan, Alberta, CANADA
          T8L 2N8


Introduction:

     Wordstar  owners,   have  you  ever  wanted  to  improve  on 
someone's dismal .DOC file? Have you ever printed a Wordstar file 
to  disk,  stripped  off the high bits,  then lost  the  original 
document file?  Both these things happen to me occasionally, so I 
wrote  this  program  to  convert a regular  CP/M  text  file  to 
Wordstar's 'document' mode. This allows  me to reform the text to 
a  different column width without a lot of pain.  Not  especially 
important,  you might say,  but try it some time with a file that 
has 'hard' carriage returns at the end of each line!


Operation:

     The program is very simple to use. Run the program by typing 
"ENSOFT". Answer the "Input file's name?" question by typing 
the  name  of the original text file you want  to  convert.  Then 
answer  the "Output file's name?" question by typing the name you 
want to use for the new document file.
     By the way,  if you want to go the other way (document  file 
to text file),  an easy way is to "PIP  TEXT.FIL=DOCUMENT.FIL[Z]" 
(the  'Z'  option  turns  off the high bit in each  byte  in  the 
document file).


How it works:

     Wordstar  represents  'soft'  carriage  returns  and  spaces 
(i.e.  those  that  can  appear or disappear when  you  reform  a 
paragraph)  by  turning  on the highest bit  of  the  appropriate 
return  or space code.  ENSOFT makes some educated guesses  about 
which  returns and spaces it should make  'soft'.  For  instance, 
if  there are multiple spaces between words,  it leaves the first 
one  after the word 'hard',  and 'softens' the others up  to  the 
beginning of the next word.
     The program is written in Ron Cain's Small-C, so if you have 
a  C  compiler you should be able to modify the program  to  your 
heart's  content.  A good test is to run this documentation  file 
through  the  program,  and  then reform it  to  80  columns.  If 
everything  works,  you should get good-looking text without  any 
garbage characters or strange looking paragraphs.


Possible bugs:

     I've  only  used  this program on my  own  Wordstar-produced 
files  and some public domain documentation files.  I don't  know 
how well it will stand up if you run weird files through it (e.g. 
100  carriage  returns  in  a  row,   strange  embedded   control 
characters,  etc.).  If  by  mistake  you process a  file  that's 
already  in  document  format the program won't mess  it  up  too 
badly. The original file is left alone, so you can always recover 
if things don't work out right.

* ͚
!9! }2!  }2!
 ͊!lt!
 ͊!t!
 ͊!
 ͊! |ʼ!t! 9"! 9!"*!  |ʐü!t! 9t!t!
 ͊!
 ͊S!
 ͊!t! 9"! 9!"*!  |!
 ͊!t! 9t!t!  9*
Ͳ! D|T!  9ͪ8*t*͟	*͟	!" 9ENSOFT version 1.0: Converts text files to Wordstar document format. Input file's name?  r Can't open ' ' for input. Output file's name?  w Can't open ' ' for output. The disk directory is probably full. ! 9ͪ!
 |:ͥ|b! 9ͪ! 9*
Ͳ! 9ͪ!  |ʗ!
 *t! 9ͪ!
 ! 9ͪ! D͸|!
 *t!
 ! ͸*t!
 *t! }2! 9ͪ8Ó! 9ͪ!  |_:ͥ|9!  }2! 9ͪ:ͥ|L! 9ͪ! 9ͪ! ͸Ó! 9ͪ! D|}! Ó! }2!  }2! 9ͪ!  <2~og~#fo}}|}o|g}o|g}o|g++++++{_z!  ɳ7++++z${! ||g}o))7{ozgI#|/g}/oDM!  y[xGyOȯ{_zWUDMzzx>  )ʝ}o{_zW=ʦÆͱͱz/W{/_x/Gy/O{_zW{z+++:_    å!G >!  6 ! 6!   ||g}o))7{ozgI  /g}/oDM!  y[xGyOȯ{_zWUDMzzx>  )ʝ}o{_zW=ʦÆͱͱz/W{/_x/Gy/O{_zW{z+++:_      å!G >!  6 ! 6!   ||g}o))7{ozgI  /g}/oDM!  y[xGyOȯ{_zWUDMzzx>  )ʝ}o  zW=ʦÆͱͱz/W{/_x/Gy/O{_zW{z+++:_      å!G >!  6 ! 6!   ||g}o))7{  gI  /g}/oDM!  y[xGyOȯ{_zWUDMzzx>  )ʝ}o  zW=ʦÆͱͱz/W{/_x/Gy/O{_z"""|$ "* *  	s#r**?
*n&  
*~r	RD	* 4	*!  *   s#rÛ	*~wR	W	* * t	*!  *  s#r*! >wÛ	*!  *"! "*! ~ 
! *t*$ "*  ^#V"* "**z	
{
*6#"	! *ͬ| 
!  "* 3
!  "**:\
@ _
 _
:& .{
.{
& .ͳ
! 	6 }ʞ
.ʞ
 ʞ
aڗ
{җ
 -{
.ʭ
 ʭ
Þ
.³
}ʿ
|-ó

}

"! ~
!*$ "  ^#V"* ~#;! *ͬ|$!*  s#r* "* ^#Vr+s*#*  	s#r*~p*! ~w!o& ͡|}
!
 ͡|!""$ "  ^#V"* ~#! *ͬ|!*  s#r* "* ^#Vr+s*#*  	s#r:*w& o"+V6 +^6O
 *+^# 6 s#r#
 * o& e!
s
 ~ʉ^# x" :
¦
 *& ""*n&  
*$   *M* ͥ"  *|!  !}
                                                                                                                                                                                                                                                