/*	TYPE - uses typesq.c for 'sqed' files
  derived from cnode 'cat', typesq, and others. W. Earnest 5/28/82
  Credit to the following and others for parts of the software:
	Dick Greenlaw	(usq)
	Bob Mathias	(typesq)
	Steve Passe	(cnode)
	Joe Shannon	(cnode)
  uses wildexp by Leor Zolman, which should be modified to strip
  attribute bit from the file characters (v 1.2)
*/
/* Ver 1.2 6/17/82 fix bug in null ended files */
/* Ver 1.3 6/19/82 Add option to ignore .SYS files */

#include "a:bdscio.h"

#define CNTRL_C 3
#define TAB 9
#define LF 10
#define FF 11
#define CR 13
#define CNTRL_S 19
#define CNTRL_X 24
#define SPACE 32
#define	CONST	2
#define CONIN	3
#define CONOUT	4
#define RECOGNIZE 0xFF76	/* unlikely pattern */
#define DLE 0x90		/* repeat byte flag */
#define	CHAR_AVAILABLE 0xff
#define SPEOF 256		/* special endfile token */
#define NUMVALS 257		/* 256 data values plus SPEOF*/
#define LARGE 30000
#define PATHLEN 20	/* file string size */
#define MAXLINES 200	/* comment out for no limit */
#define EXPAND		/* comment out for no tab expand */
#define NOSYS

struct _sqleaf {		/* Decoding tree */
	int _children[2];	/* left, right */
};
struct _sqleaf Dnode[NUMVALS - 1];

int col,line_cnt,early_exit;
char File_buf[BUFSIZ];

unsigned Sqcksum;
int Bpos;		/* last bit position read */
int Curin;		/* last byte value read */
int Repct;		/* Number of times to retirn value */
int Value;		/* current byte value or EOF */

main(p_argc, p_argv)
int p_argc;
char **p_argv;
{
	char file[PATHLEN];
	char x;

	wildexp(&p_argc,&p_argv);

	if (p_argc < 2) {
#ifdef EXPAND
		printf("Syntax: TYPE filname.typ ...\n");
#else
		printf("Syntax: XTYPE filname.typ ...\n");
#endif
		printf("Wild chars. (* and ?) OK,\n");
		printf("Multiple file names OK\n");
		exit();
		}

	printf("Ctrl-S pauses, Ctrl-C Aborts, Ctrl-X skips to next file\n");
	for (x = 1;x < p_argc;++x) {
		switch (catvalid(file, p_argv[x])) {
		case 'q':
			switch (qsend(file)) {
			case ERROR:	break;
			case 'a':	send_text(file);
			}
			break;
		case 'a':
			send_text(file);
			break;
		case 'x':
			break;
		case ERROR:
		default:
			printf("\n\tcan't type %s...\n", p_argv[x]);
		}
	}
	return (OK);
}

send_text(file)
char *file;
{
int c;
	printf("\nListing file %s\n\n",file);
	line_cnt = 0;
	early_exit = 0;
	col = 1;
	while( ((c = getc(File_buf)) != EOF) && (!early_exit) )
		dochar(c);
	fclose(File_buf);
	return (OK);
}

dochar(c)
char c;
{
	c = c & 0x7f;
	if (c == 0x1a) early_exit = 1;
	else
	if ( ((c > 0x1f) && (c < 0x7f)) 
	  || c == LF
	  || c == CR
	  || c == FF
	  || c == TAB)

		bios_putchar(c);

#ifdef MAXLINES
		if (c == 0x0a)
			if (++line_cnt >= MAXLINES)
			{	printf("\n\n TYPE ABORTED:");
				printf(" Maximum number of lines exceeded\n");
				printf("Use XTYPE for full file (but without");
				printf(" tab expansion).\n\n");
				early_exit = 1;
			}
#endif
}

catvalid(pname, name)
char *pname;
char *name;
{
	char *pptr, *qptr, *npnt;
	int fd;

	if (strlen(name) > 14) {
		printf("\n'%s' bad name, (name too long)", name);
		return ERROR;
	}
	if((fd = fopen(name, File_buf)) == ERROR) {
		printf("\n\tError on %s, check your spelling.",name);
		return ERROR;
	}
	npnt = fcbaddr(fd);
#ifdef NOSYS
	if(npnt[10] > 127) {
		printf("\n\tError on %s, check your spelling.",name);
		fclose(File_buf);
		return 'x';
}
#endif
	if (npnt[1] > 127 || npnt[2] > 127) {
		if (npnt[10] < 128)
			printf("\nFile %s not for distribution.\n",name);
		fclose(File_buf);
		return 'x';
		}

	strcpy(pname, name);
	if (	cisubstr(pname, ".COM")
	  ||	cisubstr(pname, ".OBJ")
	  ||	cisubstr(pname, ".BAD")
	  ||	cisubstr(pname, ".LOG")
	  ||	cisubstr(pname, ".OV")
	  ||	cisubstr(pname, ".REL")
	  ||	cisubstr(pname, ".CRL")
	  ||	cisubstr(pname, ".IRL")
	  ) {
		fclose(File_buf);
		return ERROR;
	    }
	if (pptr = index('.', pname)) {			/* squeezed file? */
		if (*(pptr + 2) == 'Q')
			return 'q';			/* yes... */
	}
	return 'a';					/* default to ascii */
}

/*
	The following code is primarily from typesq.c and utr.c.  Typesq
is a modification of USQ by Dick Greenlaw.  Those modifications (usq
to typesq) were made by Bob Mathias, I am responsible for the butchery
done to make it work with cat.

*/

qsend(infile)	/* #define VERSION "1.3   07/21/81" */
char *infile;
{
	char origname[14];	/* Original file name without drive */
	int i, c;
	char *p;
	unsigned filecksum;		/* checksum */
	int numnodes;			/* size of decoding tree */

	Sqcksum = 0;			/* Initialization */
	init_cr();
	init_huff();

	if(getw(File_buf) != RECOGNIZE) {	/* Process header */
		fclose(File_buf);
		return 'a';			/* not squeezed after all */
	}
	filecksum = getw(File_buf);
	p = origname;				/* Get original file name */
	do {					/* send it to array */
		*p = getc(File_buf);
	} while(*p++ != '\0');

	numnodes = getw(File_buf);
	if(numnodes < 0 || numnodes >= NUMVALS) {
		printf("%s has invalid decode tree size\n", infile);
		fclose(File_buf);
		return ERROR;
	}
	/* Initialize for possible empty tree (SPEOF only) */
	Dnode[0]._children[0] = -(SPEOF + 1);
	Dnode[0]._children[1] = -(SPEOF + 1);

	for(i = 0; i < numnodes; ++i) {	/* Get decoding tree from file */
		Dnode[i]._children[0] = getw(File_buf);
		Dnode[i]._children[1] = getw(File_buf);
	}
	/* Get translated output bytes and write file */
	printf("\n%s -> %s\n\n",infile,origname);
	line_cnt = 0;
	early_exit = 0;
	col = 1;
	while( ((c = getcr(File_buf)) != EOF) && (!early_exit) )
		dochar(c);
	fclose(File_buf);
	return OK;
}
/*** from utr.c - */
/* initialize decoding functions */

init_cr()
{
	Repct = 0;
}

init_huff()
{
	Bpos = 99;	/* force initial read */
}

/* Get bytes with decoding - this decodes repetition,
 * calls getuhuff to decode file stream into byte
 * level code with only repetition encoding.
 *
 * The code is simple passing through of bytes except
 * that DLE is encoded as DLE-zero and other values
 * repeated more than twice are encoded as value-DLE-count.
 */

int
getcr(ib)
char *ib;
{
	int c;

	if(Repct > 0) {
		/* Expanding a repeated char */
		--Repct;
		return Value;
	} else {
		/* Nothing unusual */
		if((c = getuhuff(ib)) != DLE) {
			/* It's not the special delimiter */
			Value = c;
			if(Value == EOF)
				Repct = LARGE;
			return Value;
		} else {
			/* Special token */
			if((Repct = getuhuff(ib)) == 0)
				/* DLE, zero represents DLE */
				return DLE;
			else {
				/* Begin expanding repetition */
				Repct -= 2;	/* 2nd time */
				return Value;
			}
		}
	}
}
/* Decode file stream into a byte level code with only
 * repetition encoding remaining.
 */

int
getuhuff(ib)
char *ib;
{
	int i;
	int bitval;

	/* Follow bit stream in tree to a leaf*/
	i = 0;	/* Start at root of tree */
	do {
		if(++Bpos > 7) {
			if((Curin = getc(ib)) == ERROR)
				return ERROR;
			Bpos = 0;
			/* move a level deeper in tree */
			i = Dnode[i]._children[1 & Curin];
		} else
			i = Dnode[i]._children[1 & (Curin >>= 1)];
	} while(i >= 0);

	/* Decode fake node index to original data value */
	i = -(i + 1);
	/* Decode special endfile token to normal EOF */
	i = (i == SPEOF) ? EOF : i;
	return i;
}


bios_putchar(c)
char c;
{
	int number_of_spaces;
	char t;

	if ( bios(CONST,0) == CHAR_AVAILABLE )
	{if ( (t = bios(CONIN,0)) == CNTRL_C ) 
			exit();
		else
			if (t == CNTRL_S)
		{
			while( bios(CONST,0) != CHAR_AVAILABLE);
			t = bios(CONIN,0);
		}
		else
			if (t == CNTRL_X) {
			printf("\n");
			early_exit = 1;
			}
	}
#ifdef EXPAND
	if ( c == TAB)
		for(number_of_spaces=8-((col-1)&7);number_of_spaces--;col++)
			bios(CONOUT,SPACE);
	else
#endif
	{bios(CONOUT,c);
		if (c == CR || c == FF)
			col = 1;
		else
			if (c != LF) col++;
	}
}
/*
 * cisubstr(string, token) searches for lower case token in string s
 * returns pointer to token within string if found, NULL otherwise
 */
char *
cisubstr(s, t)
char *s,*t;
{
	char *ss,*tt;
	/* search for first char of token */
	for(ss=s; *s; s++)
		if (*s==*t)
			/* compare token with substring */
			for(ss=s,tt=t; ;) {
				if(*tt==0)
					return s;
				if(*ss++ != *tt++)
					break;
			}
	return NULL;
}
/*
 * index returns a pointer to the first occurrence of c in s,
 * NULL otherwise.
 */
char *
index(c, s)
char c,*s;
{
	for(; *s; s++)
		if(c== *s)
			return s;
	return NULL;
}

/* endcode */
